/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.render.provider;

import com.alibabacloud.intellij.qoder.core.lsp.model.model.RewriteCodeAction;
import com.alibabacloud.intellij.qoder.editor.render.HighlighterDrawUtil;
import com.alibabacloud.intellij.qoder.editor.render.InlineDiffRenderContext;
import com.alibabacloud.intellij.qoder.editor.render.WordHighlighterRenderer;
import com.alibabacloud.intellij.qoder.editor.render.provider.DiffFloatingPanel;
import com.alibabacloud.intellij.qoder.editor.render.provider.NesAcceptPanel;
import com.alibabacloud.intellij.qoder.editor.render.provider.NesRenderProvider;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.CosyDiffDrawUtil;
import com.alibabacloud.intellij.qoder.util.DiffUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class BaseNesRenderProvider
implements NesRenderProvider {
    final int ACCEPT_PANEL_GAP = 4;
    List<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
    List<Inlay<?>> inlays = new ArrayList();
    List<DiffFloatingPanel> floatingPanels = new ArrayList<DiffFloatingPanel>();
    NesAcceptPanel acceptPanel = null;

    @Override
    public void render(InlineDiffRenderContext context) {
        List<LineFragment> diffResult = context.getDiffChangeModel().getDiffResult();
        Editor editor = context.getEditor();
        RewriteCodeAction item = context.getItem();
        if (diffResult.isEmpty()) {
            return;
        }
        if (this.isOnlyDeletedChanges(context)) {
            this.renderOnlyDeleted(editor, diffResult, item, context);
        } else if (this.isOneWordModifyForOneChange(diffResult)) {
            this.renderOneWordModifyForOneChange(editor, diffResult, item);
        } else {
            this.renderFragments(editor, diffResult, item);
        }
        this.renderAcceptButton(editor, diffResult, item, context.isFocused());
    }

    public abstract void renderFragments(Editor var1, List<LineFragment> var2, RewriteCodeAction var3);

    private void renderOnlyDeleted(Editor editor, List<LineFragment> diffResult, RewriteCodeAction item, InlineDiffRenderContext context) {
        int startOffsetOfLine = editor.getDocument().getLineStartOffset(item.getEditRange().getStart().getLine());
        for (LineFragment fragment : diffResult) {
            LineFragment absoluteChange = this.addOffset(fragment, item.getEditRange().getStart().getLine(), startOffsetOfLine);
            LineRange deleteRange = new LineRange(absoluteChange.getStartLine1(), absoluteChange.getEndLine1());
            List<RangeHighlighter> deletionHighlighters = new ArrayList<RangeHighlighter>();
            if (this.isOnlyDeleted(fragment, context)) {
                List<RangeHighlighter> highlighters = CosyDiffDrawUtil.createUnifiedChunkHighlighters(editor, deleteRange, null, fragment.getInnerFragments());
                deletionHighlighters.addAll(highlighters);
            } else if (fragment.getInnerFragments() != null) {
                deletionHighlighters = HighlighterDrawUtil.createDeletionWordHighlighters(editor, deleteRange, fragment.getInnerFragments());
            }
            if (deletionHighlighters.isEmpty()) continue;
            this.highlighters.addAll(deletionHighlighters);
        }
    }

    private void renderOneWordModifyForOneChange(Editor editor, List<LineFragment> diffResult, RewriteCodeAction item) {
        LineFragment fragment = diffResult.get(0);
        List innerFragments = fragment.getInnerFragments();
        if (innerFragments == null || innerFragments.size() != 1) {
            return;
        }
        int startOffsetOfLine = editor.getDocument().getLineStartOffset(item.getEditRange().getStart().getLine());
        LineFragment absoluteChange = this.addOffset(fragment, item.getEditRange().getStart().getLine(), startOffsetOfLine);
        DiffFragment innerFragment = (DiffFragment)innerFragments.get(0);
        int startOffset = editor.getDocument().getLineStartOffset(absoluteChange.getStartLine1());
        int wordStart = startOffset + innerFragment.getStartOffset1();
        int wordEnd = startOffset + innerFragment.getEndOffset1();
        List strikes = DiffDrawUtil.createInlineHighlighter((Editor)editor, (int)wordStart, (int)wordEnd, (TextDiffType)TextDiffType.DELETED);
        Color color = ColorUtil.getDiffTypeBorderColor(editor, TextDiffType.DELETED);
        for (RangeHighlighter highlighter : strikes) {
            highlighter.setCustomRenderer((CustomHighlighterRenderer)new WordHighlighterRenderer(null, color, false, null));
        }
        this.highlighters.addAll(strikes);
        Document document = EditorFactory.getInstance().createDocument((CharSequence)item.getContent());
        int lineStartOffset = document.getLineStartOffset(fragment.getStartLine2());
        String newContent = item.getContent().substring(lineStartOffset + innerFragment.getStartOffset2(), lineStartOffset + innerFragment.getEndOffset2());
        DiffFloatingPanel floatingPanel = DiffFloatingPanel.createOneWordInsertPanel(newContent, editor);
        floatingPanel.showUnderAtOffset(wordStart, 4, true);
        this.floatingPanels.add(floatingPanel);
    }

    private boolean isOnlyDeleted(LineFragment fragment, InlineDiffRenderContext context) {
        return context.getDiffChangeModel().isOnlyDeleted() || fragment.getStartLine1() != fragment.getEndLine1() && fragment.getStartLine2() == fragment.getEndLine2();
    }

    private boolean isOneWordModifyForOneChange(List<LineFragment> diffResult) {
        if (diffResult.size() != 1) {
            return false;
        }
        LineFragment fragment = diffResult.get(0);
        if (fragment.getStartLine1() == fragment.getEndLine1() || fragment.getStartLine2() == fragment.getEndLine2()) {
            return false;
        }
        List innerFragments = fragment.getInnerFragments();
        if (innerFragments == null || innerFragments.isEmpty()) {
            return false;
        }
        if (innerFragments.size() != 1) {
            return false;
        }
        DiffFragment innerFragment = (DiffFragment)innerFragments.get(0);
        return innerFragment.getStartOffset1() != innerFragment.getEndOffset1() && innerFragment.getStartOffset2() != innerFragment.getEndOffset2();
    }

    private boolean isOnlyDeletedChanges(InlineDiffRenderContext context) {
        for (LineFragment fragment : context.getDiffChangeModel().getDiffResult()) {
            if (this.isOnlyDeleted(fragment, context)) continue;
            if (fragment.getStartLine1() == fragment.getEndLine1() || fragment.getStartLine2() == fragment.getEndLine2()) {
                return false;
            }
            List innerFragments = fragment.getInnerFragments();
            if (innerFragments == null || innerFragments.isEmpty()) {
                return false;
            }
            for (DiffFragment innerFragment : innerFragments) {
                if (DiffUtil.isDeleteWord(context.getOriginalText(), context.getItem().getContent(), fragment, innerFragment) || innerFragment.getStartOffset1() != innerFragment.getEndOffset1() && innerFragment.getStartOffset2() == innerFragment.getEndOffset2()) continue;
                return false;
            }
        }
        return true;
    }

    private void renderAcceptButton(Editor editor, List<LineFragment> fragments, RewriteCodeAction item, boolean isFocused) {
        if (fragments == null || fragments.isEmpty()) {
            return;
        }
        if (this.acceptPanel != null) {
            this.acceptPanel.removePanel();
        }
        int startOffsetOfLine = editor.getDocument().getLineStartOffset(item.getEditRange().getStart().getLine());
        LineFragment fragment = this.addOffset(fragments.get(0), item.getEditRange().getStart().getLine(), startOffsetOfLine);
        this.acceptPanel = new NesAcceptPanel(editor, isFocused);
        Rectangle acceptPosition = this.getAcceptButtonPosition(editor, fragment);
        this.acceptPanel.setPosition(acceptPosition);
    }

    private Rectangle getAcceptButtonPosition(Editor editor, LineFragment fragment) {
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        int firstLine = fragment.getStartLine1();
        if (fragment.getStartLine1() == fragment.getEndLine1() && firstLine > 0) {
            --firstLine;
        }
        Point point = editor.logicalPositionToXY(new LogicalPosition(firstLine, 0));
        int buttonWidth = this.acceptPanel.getPreferredSize().width;
        int buttonHeight = this.acceptPanel.getPreferredSize().height;
        int scrollbarWidth = ((EditorImpl)editor).getScrollPane().getVerticalScrollBar().getWidth();
        point.x += visibleArea.width - buttonWidth - scrollbarWidth - 4;
        point.y = point.y - buttonHeight + 4 < visibleArea.y ? (point.y += 4 + editor.getLineHeight()) : (point.y -= buttonHeight + 4);
        if (fragment.getStartLine1() == fragment.getEndLine1()) {
            point.y += editor.getLineHeight();
        }
        return new Rectangle(point, new Dimension(buttonWidth, buttonHeight));
    }

    protected LineFragment addOffset(LineFragment fragment, int lineOffset, int offsetOfLine) {
        int startLine1 = fragment.getStartLine1() + lineOffset;
        int endLine1 = fragment.getEndLine1() + lineOffset;
        int startLine2 = fragment.getStartLine2() + lineOffset;
        int endLine2 = fragment.getEndLine2() + lineOffset;
        int startOffset1 = fragment.getStartOffset1() + offsetOfLine;
        int endOffset1 = fragment.getEndOffset1() + offsetOfLine;
        int startOffset2 = fragment.getStartOffset2() + offsetOfLine;
        int endOffset2 = fragment.getEndOffset2() + offsetOfLine;
        return new LineFragmentImpl(startLine1, endLine1, startLine2, endLine2, startOffset1, endOffset1, startOffset2, endOffset2, fragment.getInnerFragments());
    }

    @Override
    public boolean hasShowingInlineEdit() {
        for (Inlay<?> inlay : this.inlays) {
            if (!inlay.isValid()) continue;
            return true;
        }
        for (RangeHighlighter highlighter : this.highlighters) {
            if (!highlighter.isValid()) continue;
            return true;
        }
        return !this.floatingPanels.isEmpty();
    }

    @Override
    public Rectangle getVisibleRect(@NotNull Editor editor) {
        if (editor == null) {
            BaseNesRenderProvider.$$$reportNull$$$0(0);
        }
        Rectangle diffRect = null;
        for (DiffFloatingPanel diffFloatingPanel : this.floatingPanels) {
            Rectangle rect = diffFloatingPanel.getBounds();
            if (diffRect == null) {
                diffRect = rect;
                continue;
            }
            diffRect = SwingUtil.mergeRectangle(diffRect, rect);
        }
        for (RangeHighlighter rangeHighlighter : this.highlighters) {
            int endLine;
            int startLine;
            Rectangle rect;
            if (!rangeHighlighter.isValid() || rangeHighlighter.getStartOffset() < 0 || rangeHighlighter.getEndOffset() >= editor.getDocument().getTextLength() || (rect = SwingUtil.getLineLogicalRangeRect(editor, startLine = editor.getDocument().getLineNumber(rangeHighlighter.getStartOffset()), endLine = editor.getDocument().getLineNumber(rangeHighlighter.getEndOffset()))) == null) continue;
            if (diffRect == null) {
                diffRect = rect;
                continue;
            }
            diffRect = SwingUtil.mergeRectangle(diffRect, rect);
        }
        for (Inlay inlay : this.inlays) {
            Rectangle rect;
            if (!inlay.isValid() || (rect = inlay.getBounds()) == null) continue;
            if (diffRect == null) {
                diffRect = rect;
                continue;
            }
            diffRect = SwingUtil.mergeRectangle(diffRect, rect);
        }
        return diffRect;
    }

    public void dispose() {
        ApplicationManager.getApplication().runReadAction(() -> {
            for (Inlay<?> inlay : this.inlays) {
                Disposer.dispose(inlay);
            }
        });
        for (RangeHighlighter highlighter : this.highlighters) {
            highlighter.dispose();
        }
        for (DiffFloatingPanel floatingPanel : this.floatingPanels) {
            floatingPanel.dispose();
        }
        if (this.acceptPanel != null) {
            this.acceptPanel.removePanel();
            this.acceptPanel = null;
        }
        this.floatingPanels.clear();
        HintManagerImpl.getInstanceImpl().cleanup();
    }

    protected static boolean isOnlyInsert(List<LineFragment> diffResult) {
        int lastInsertLine = -1;
        for (LineFragment fragment : diffResult) {
            if (fragment.getStartLine1() != fragment.getEndLine1()) {
                return false;
            }
            if (lastInsertLine == -1) {
                lastInsertLine = fragment.getEndLine2();
                continue;
            }
            if (lastInsertLine == fragment.getStartLine2()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/alibabacloud/intellij/qoder/editor/render/provider/BaseNesRenderProvider", "getVisibleRect"));
    }
}

