/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.render.provider;

import com.alibabacloud.intellij.qoder.editor.render.HighlighterDrawUtil;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.DiffUtil;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.EditorTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lombok.Generated;

public class DiffFloatingPanel
extends JPanel
implements Disposable {
    public static final int ARROW_WIDTH = 4;
    EditorTextField editorField;
    JLabel iconLabel;
    Editor ownEditor;
    String content;
    List<LineFragment> diffResult;
    List<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
    String minIndent;
    boolean needArrow;

    public DiffFloatingPanel(String content, List<LineFragment> diffResult, Editor ownEditor) {
        this(content, diffResult, ownEditor, false);
    }

    public DiffFloatingPanel(String content, List<LineFragment> diffResult, Editor ownEditor, boolean needArrow) {
        this.setLayout(new BorderLayout());
        this.ownEditor = ownEditor;
        this.content = content;
        if (ownEditor != null) {
            this.setBackground(TextDiffType.INSERTED.getIgnoredColor(ownEditor));
        }
        this.diffResult = diffResult;
        this.needArrow = needArrow;
        this.setup();
    }

    public DiffFloatingPanel(String content, List<LineFragment> diffResult, Editor ownEditor, boolean needArrow, String minIndent) {
        this(content, diffResult, ownEditor, needArrow);
        this.minIndent = minIndent;
    }

    public static DiffFloatingPanel createOneWordInsertPanel(String content, Editor ownEditor) {
        ArrayList<LineFragment> diffResult = new ArrayList<LineFragment>();
        ArrayList<DiffFragmentImpl> innerFragments = new ArrayList<DiffFragmentImpl>();
        innerFragments.add(new DiffFragmentImpl(0, 0, 0, content.length()));
        LineFragmentImpl fragment = new LineFragmentImpl(0, 0, 0, 1, 0, 0, 0, content.length(), innerFragments);
        diffResult.add((LineFragment)fragment);
        return new DiffFloatingPanel(content, diffResult, ownEditor);
    }

    public static DiffFloatingPanel createMultiLineChangePanel(String content, List<LineFragment> diffResult, Editor ownEditor) {
        return DiffFloatingPanel.createMultiLineChangePanel(content, diffResult, ownEditor, false);
    }

    public static DiffFloatingPanel createMultiLineChangePanel(String content, List<LineFragment> diffResult, Editor ownEditor, boolean trimIndent) {
        return DiffFloatingPanel.createMultiLineChangePanel(content, diffResult, ownEditor, trimIndent, false);
    }

    public static DiffFloatingPanel createMultiLineChangePanel(String content, List<LineFragment> diffResult, Editor ownEditor, boolean trimIndent, boolean needArrow) {
        if (diffResult.isEmpty()) {
            return null;
        }
        int startLine = Integer.MAX_VALUE;
        int endLine = 0;
        for (LineFragment fragment : diffResult) {
            startLine = Math.min(startLine, fragment.getStartLine2());
            endLine = Math.max(endLine, fragment.getEndLine2());
        }
        String[] lines = content.split("\n", -1);
        StringBuilder sb = new StringBuilder();
        String minIndent = null;
        if (trimIndent) {
            for (int i = startLine; i < endLine; ++i) {
                String line = lines[i];
                if (line.trim().isEmpty()) continue;
                String indent = StringUtils.countLeadingLength(line, StringUtils.TAB_SPACE_PATTERN);
                if (minIndent != null && indent.length() >= minIndent.length()) continue;
                minIndent = indent;
            }
        }
        int[] lineOffsets = new int[endLine - startLine];
        for (int i = startLine; i < endLine; ++i) {
            String line = lines[i];
            int lineIndex = i - startLine;
            if (trimIndent && minIndent != null && !line.trim().isEmpty() && line.startsWith(minIndent)) {
                line = line.substring(minIndent.length());
                lineOffsets[lineIndex] = minIndent.length();
            } else {
                lineOffsets[lineIndex] = 0;
            }
            sb.append(line);
            sb.append("\n");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        int lineStartOffset = 0;
        for (int i = 0; i < startLine; ++i) {
            lineStartOffset += lines[i].length() + 1;
        }
        ArrayList<LineFragment> newDiffResult = new ArrayList<LineFragment>();
        int removeStartOffset = 0;
        int removeEndOffset = 0;
        for (int i = 0; i < diffResult.size(); ++i) {
            LineFragment fragment = diffResult.get(i);
            LinkedHashMap<Integer, Integer> lineOffsetMap = new LinkedHashMap<Integer, Integer>();
            int charOffset = 0;
            int lineTotalLength = 0;
            for (int j = fragment.getStartLine2(); j < fragment.getEndLine2(); ++j) {
                int fragmentStartLine = j - startLine;
                lineOffsetMap.put(lineTotalLength += lines[j].length() + 1, charOffset += lineOffsets[fragmentStartLine]);
            }
            LineFragment newFragment = DiffUtil.addOffset(fragment, -startLine, -lineStartOffset);
            if (trimIndent && charOffset > 0 && minIndent != null) {
                int startOffset2 = newFragment.getStartOffset2();
                int endOffset2 = newFragment.getEndOffset2();
                List<DiffFragmentImpl> innerFragments = new ArrayList();
                if (fragment.getInnerFragments() != null) {
                    for (DiffFragment innerFragment : fragment.getInnerFragments()) {
                        Integer innerLineStartOffset = DiffFloatingPanel.getLineOffset(lineOffsetMap, innerFragment.getStartOffset2());
                        innerLineStartOffset = innerLineStartOffset == null ? 0 : innerLineStartOffset;
                        Integer innerLineEndOffset = DiffFloatingPanel.getLineOffset(lineOffsetMap, innerFragment.getEndOffset2());
                        innerLineEndOffset = innerLineEndOffset == null ? 0 : innerLineEndOffset;
                        innerFragments.add(new DiffFragmentImpl(innerFragment.getStartOffset1(), innerFragment.getEndOffset1(), innerFragment.getStartOffset2() - innerLineStartOffset, innerFragment.getEndOffset2() - innerLineEndOffset));
                        removeStartOffset += innerLineStartOffset.intValue();
                        removeEndOffset += innerLineEndOffset.intValue();
                    }
                } else {
                    innerFragments = fragment.getInnerFragments();
                }
                newFragment = new LineFragmentImpl(newFragment.getStartLine1(), newFragment.getEndLine1(), newFragment.getStartLine2(), newFragment.getEndLine2(), newFragment.getStartOffset1(), newFragment.getEndOffset1(), startOffset2 - removeStartOffset, endOffset2 - removeEndOffset, innerFragments);
            }
            newDiffResult.add(newFragment);
        }
        return new DiffFloatingPanel(sb.toString(), newDiffResult, ownEditor, needArrow, minIndent);
    }

    private static Integer getLineOffset(Map<Integer, Integer> lineOffsetMap, int line) {
        for (Map.Entry<Integer, Integer> entry : lineOffsetMap.entrySet()) {
            if (line > entry.getKey()) continue;
            return entry.getValue();
        }
        return null;
    }

    public void showUnderAtOffset(int offset, int marginOffset, boolean withIcon) {
        VisualPosition vp = this.ownEditor.offsetToVisualPosition(offset);
        Point point = this.ownEditor.visualPositionToXY(vp);
        point.y += this.ownEditor.getLineHeight();
        this.showUnderAtPoint(point, marginOffset, withIcon);
    }

    public void showUnderAtPoint(Point point, int marginOffset, boolean withIcon) {
        this.add((Component)this.editorField, "Center");
        this.ownEditor.getContentComponent().add(this);
        if (this.editorField.getEditor() != null && this.editorField.getEditor() instanceof EditorEx) {
            ((EditorEx)this.editorField.getEditor()).setVerticalScrollbarVisible(false);
            ((EditorEx)this.editorField.getEditor()).setHorizontalScrollbarVisible(false);
        }
        this.setupInnerHighlighter();
        this.setBounds(point.x, point.y + marginOffset, this.editorField.getPreferredSize().width, this.editorField.getPreferredSize().height);
        if (withIcon) {
            this.showIconAtPoint(point, marginOffset);
        }
    }

    public void showInsideAtPosition(Point point, boolean onlyInsert) {
        this.add((Component)this.editorField, "Center");
        this.ownEditor.getContentComponent().add(this);
        if (this.editorField.getEditor() != null && this.editorField.getEditor() instanceof EditorEx) {
            ((EditorEx)this.editorField.getEditor()).setVerticalScrollbarVisible(false);
            ((EditorEx)this.editorField.getEditor()).setHorizontalScrollbarVisible(false);
        }
        this.setupInnerHighlighter();
        this.setBounds(point.x + (onlyInsert ? 0 : 4), point.y, this.editorField.getPreferredSize().width, this.editorField.getPreferredSize().height);
    }

    private void setup() {
        if (EditorFactory.getInstance() == null) {
            return;
        }
        Document newDocument = EditorFactory.getInstance().createDocument((CharSequence)this.content);
        this.editorField = EditorUtil.createTextField(this.ownEditor, newDocument);
        if (this.editorField == null || this.editorField.getEditor() == null) {
            return;
        }
        this.editorField.setBackground(ColorUtil.getEditorBackgroundColor());
        Editor innerEditor = this.editorField.getEditor();
        if (innerEditor instanceof EditorImpl) {
            Disposer.register((Disposable)this, (Disposable)((EditorImpl)innerEditor).getDisposable());
        }
        this.add((Component)this.editorField, "Center");
    }

    private void setupInnerHighlighter() {
        Editor innerEditor = this.editorField.getEditor();
        if (innerEditor == null) {
            return;
        }
        this.editorField.setBackground(EditorFragmentComponent.getBackgroundColor((Editor)this.ownEditor, (boolean)false));
        for (LineFragment fragment : this.diffResult) {
            LineRange insertRange = new LineRange(fragment.getStartLine2(), fragment.getEndLine2());
            List<RangeHighlighter> innerHighlighters = HighlighterDrawUtil.createInsertionHighlighters(innerEditor, insertRange, fragment.getInnerFragments(), TextDiffType.INSERTED, true);
            this.highlighters.addAll(innerHighlighters);
        }
    }

    public void dispose() {
        for (RangeHighlighter highlighter : this.highlighters) {
            highlighter.dispose();
        }
        if (this.editorField != null) {
            this.ownEditor.getContentComponent().remove(this);
        }
        if (this.iconLabel != null) {
            this.ownEditor.getContentComponent().remove(this.iconLabel);
        }
    }

    public void showIconAtPoint(Point point, int marginOffset) {
        this.iconLabel = new JLabel(QoderIcons.NesReplaceDiffGreyIcon);
        this.ownEditor.getContentComponent().add(this.iconLabel);
        Dimension size = this.iconLabel.getPreferredSize();
        this.iconLabel.setBounds(point.x - size.width, point.y - size.height / 2 + marginOffset / 2, size.width, size.height);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundRectangle2D.Float roundedRectangle = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 8.0f, 8.0f);
        g2.setClip(roundedRectangle);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(g2);
        g2.setClip(null);
        Color color = ColorUtil.getDiffTypeBorderColor(this.ownEditor, TextDiffType.INSERTED);
        g2.setColor(color);
        g2.draw(roundedRectangle);
        if (this.needArrow) {
            double topX = ((RectangularShape)roundedRectangle).getX();
            double topY = ((RectangularShape)roundedRectangle).getY();
            int[] xPoints = new int[]{(int)topX, (int)topX - 4, (int)topX};
            int[] yPoints = new int[]{(int)topY + 8, (int)topY + 11, (int)topY + 14};
            g2.setColor(ColorUtil.getDiffTypeBorderColor(this.ownEditor, TextDiffType.INSERTED));
            g2.fillPolygon(xPoints, yPoints, 3);
        }
        g2.dispose();
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public List<LineFragment> getDiffResult() {
        return this.diffResult;
    }

    @Generated
    public String getMinIndent() {
        return this.minIndent;
    }
}

