/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.render.provider;

import com.alibabacloud.intellij.qoder.editor.CosyInlineEditManager;
import com.alibabacloud.intellij.qoder.editor.render.provider.NesHoverPanel;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.topic.InlineEditFocusedNotifier;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jdesktop.swingx.HorizontalLayout;

public class NesAcceptPanel
extends RoundRectPanel {
    private final int GAP_BETWEEN_PANELS = 8;
    JLabel acceptLabel;
    Editor editor;
    Rectangle panelArea;
    NesHoverPanel optionPanel;
    int previousScrollbarValue = 0;
    boolean isFocused;

    public NesAcceptPanel(Editor editor, boolean isFocused) {
        super((LayoutManager)new HorizontalLayout());
        this.editor = editor;
        this.isFocused = isFocused;
        this.setCornerRadius(8);
        this.setBorderColor(ColorUtil.getDefaultButtonColor());
        Project project = editor.getProject();
        if (project != null) {
            MessageBusConnection connection = project.getMessageBus().connect();
            connection.subscribe(InlineEditFocusedNotifier.INLINE_EDIT_FOCUSED_NOTIFIER, () -> {
                this.acceptLabel.setForeground(ColorUtil.getItemSelectionForeground());
                this.setBackground(ColorUtil.getDefaultButtonColor());
            });
        }
        this.acceptLabel = new JLabel(CosyBundle.message("nes.accept.button.text", new Object[0]));
        this.acceptLabel.setIcon(isFocused ? QoderIcons.TabWhite20Icon : QoderIcons.TabGrey20Icon);
        this.acceptLabel.setHorizontalAlignment(0);
        this.acceptLabel.setVerticalAlignment(0);
        this.acceptLabel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        this.acceptLabel.setFont(this.acceptLabel.getFont().deriveFont(14.0f));
        this.acceptLabel.setOpaque(false);
        this.add(this.acceptLabel);
        if (isFocused) {
            this.acceptLabel.setForeground(ColorUtil.getItemSelectionForeground());
            this.setBackground(ColorUtil.getDefaultButtonColor());
        } else {
            this.acceptLabel.setForeground(ColorUtil.getTextForegroundColor());
            this.setBackground(ColorUtil.getButtonBackgroundColor());
        }
        this.optionPanel = new NesHoverPanel(editor);
        this.optionPanel.setVisible(false);
        this.optionPanel.setEnabled(false);
        this.setupListeners();
        this.editor.getContentComponent().add(this);
        this.editor.getContentComponent().setComponentZOrder(this, 0);
    }

    public void removePanel() {
        this.editor.getContentComponent().remove(this);
        this.optionPanel.removePanel();
    }

    private void setupListeners() {
        SwingUtil.foreachChildComponent(this, cp -> {
            cp.setCursor(Cursor.getPredefinedCursor(12));
            cp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    NesAcceptPanel.this.acceptLabel.setIcon(NesAcceptPanel.this.isFocused ? QoderIcons.CheckWhite20Icon : QoderIcons.CheckGrey20Icon);
                    NesAcceptPanel.this.optionPanel.setShortcutHint();
                    NesAcceptPanel.this.optionPanel.setVisible(true);
                    NesAcceptPanel.this.optionPanel.setEnabled(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    NesAcceptPanel.this.acceptLabel.setIcon(NesAcceptPanel.this.isFocused ? QoderIcons.TabWhite20Icon : QoderIcons.TabGrey20Icon);
                    Point relativePosition = e.getPoint();
                    Point cursorPosition = new Point(NesAcceptPanel.this.getX() + relativePosition.x, NesAcceptPanel.this.getY() + relativePosition.y);
                    if (NesAcceptPanel.this.panelArea != null && !NesAcceptPanel.this.panelArea.contains(cursorPosition)) {
                        NesAcceptPanel.this.optionPanel.setVisible(false);
                        NesAcceptPanel.this.optionPanel.setEnabled(false);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    CosyInlineEditManager.getInstance().applyInlineEdit(NesAcceptPanel.this.editor);
                }
            });
        });
        ((EditorImpl)this.editor).getScrollPane().getHorizontalScrollBar().addAdjustmentListener(e -> {
            Rectangle currentPosition = this.getBounds();
            currentPosition.x += e.getValue() - this.previousScrollbarValue;
            this.previousScrollbarValue = e.getValue();
            this.setPosition(currentPosition);
        });
        this.editor.getScrollingModel().addVisibleAreaListener(e -> {
            Rectangle visibleArea = this.editor.getScrollingModel().getVisibleArea();
            Rectangle position = this.getBounds();
            int scrollbarWidth = ((EditorImpl)this.editor).getScrollPane().getVerticalScrollBar().getWidth();
            position.x = visibleArea.x + visibleArea.width - this.getWidth() - 8 - scrollbarWidth;
            this.setPosition(position);
        });
    }

    public void setPosition(Rectangle position) {
        this.setBounds(position);
        int x = position.x + position.width - this.optionPanel.getPreferredSize().width;
        int y = position.y - this.optionPanel.getPreferredSize().height - 8;
        if (y < 0) {
            y = position.y + position.height + 8;
            this.panelArea = new Rectangle(position.x, position.y, position.width, this.optionPanel.getPreferredSize().height + position.height + 8);
        } else {
            this.panelArea = new Rectangle(x, y, this.optionPanel.getPreferredSize().width, this.optionPanel.getPreferredSize().height + position.height + 8);
        }
        this.optionPanel.setPosition(new Rectangle(x, y, this.optionPanel.getPreferredSize().width, this.optionPanel.getPreferredSize().height));
    }
}

