/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.render.provider;

import com.alibabacloud.intellij.qoder.editor.CosyInlineEditManager;
import com.alibabacloud.intellij.qoder.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.qoder.editor.render.provider.NesHoverOption;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.config.CosyConfigurable;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ActionUtil;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.KeyboardUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jdesktop.swingx.VerticalLayout;

public class NesHoverPanel
extends RoundRectPanel {
    final String DEFAULT_ACCEPT_TEXT = "tab";
    final String DEFAULT_REJECT_TEXT = "esc";
    NesHoverOption acceptButton;
    NesHoverOption rejectButton;
    NesHoverOption settingButton;
    Editor editor;

    public NesHoverPanel(Editor editor) {
        super((LayoutManager)new VerticalLayout());
        this.editor = editor;
        this.editor.getContentComponent().add(this);
        this.editor.getContentComponent().setComponentZOrder(this, 0);
        this.setBorder((Border)new JBEmptyBorder(8, 8, 8, 8));
        JLabel titleLabel = new JLabel(CosyBundle.message("nes.hover.title.text", new Object[0]));
        titleLabel.setBorder((Border)new JBEmptyBorder(0, 4, 8, 0));
        titleLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        titleLabel.setFont(titleLabel.getFont().deriveFont(14.0f));
        this.add(titleLabel);
        this.acceptButton = new NesHoverOption(QoderIcons.AcceptGrey16Icon, CosyBundle.message("nes.hover.accept.text", new Object[0]));
        this.rejectButton = new NesHoverOption(QoderIcons.ErrorGrey16Icon, CosyBundle.message("nes.hover.reject.text", new Object[0]));
        this.setShortcutHint();
        this.settingButton = new NesHoverOption(QoderIcons.SettingGrey16Icon, CosyBundle.message("nes.hover.settings.text", new Object[0]));
        this.add(this.acceptButton);
        this.add(this.rejectButton);
        this.add(this.settingButton);
        this.setupListeners();
    }

    public void setShortcutHint() {
        try {
            int rejectShortcut;
            String acceptHint = KeyboardUtil.getShortcutText(ActionUtil.getActionId("ApplyCosyInlayCompletion"));
            String rejectHint = KeyboardUtil.getShortcutText(ActionUtil.getActionId("DisposeCosyInlayCompletionAction"));
            int acceptShortcut = KeyboardUtil.getShortcutKeyCode(ActionUtil.getActionId("ApplyCosyInlayCompletion"));
            if (acceptShortcut == 9) {
                acceptHint = "tab";
            }
            if ((rejectShortcut = KeyboardUtil.getShortcutKeyCode(ActionUtil.getActionId("DisposeCosyInlayCompletionAction"))) == 27) {
                rejectHint = "esc";
            }
            this.acceptButton.setHint(acceptHint);
            this.rejectButton.setHint(rejectHint);
        }
        finally {
            return;
        }
    }

    public void setPosition(Rectangle position) {
        this.setBounds(position);
    }

    public void removePanel() {
        this.editor.getContentComponent().remove(this);
    }

    private void setupListeners() {
        this.acceptButton.addClickHandler(cp -> CosyInlineEditManager.getInstance().applyInlineEdit(this.editor));
        this.rejectButton.addClickHandler(cp -> CosyInlineEditManager.getInstance().disposeInlineEdits(this.editor, InlayDisposeEventEnum.ESC_ACTION, null));
        this.settingButton.addClickHandler(cp -> ShowSettingsUtil.getInstance().showSettingsDialog(this.editor.getProject(), CosyConfigurable.class));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                Point relativePosition = e.getPoint();
                Point cursorPosition = new Point(NesHoverPanel.this.getX() + relativePosition.x, NesHoverPanel.this.getY() + relativePosition.y);
                if (!NesHoverPanel.this.getBounds().contains(cursorPosition)) {
                    NesHoverPanel.this.setVisible(false);
                    NesHoverPanel.this.setEnabled(false);
                }
            }
        });
    }
}

