/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.request;

import com.alibabacloud.intellij.qoder.completion.CosyCompletionService;
import com.alibabacloud.intellij.qoder.editor.cache.CompletionCacheManager;
import com.alibabacloud.intellij.qoder.editor.model.CompletionTriggerConfig;
import com.alibabacloud.intellij.qoder.editor.model.InlayCompletionRequest;
import com.alibabacloud.intellij.qoder.editor.model.InlayTriggerEventEnum;
import com.alibabacloud.intellij.qoder.editor.request.InlayPreviewRequest;
import com.alibabacloud.intellij.qoder.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.CompletionItem;
import org.jetbrains.annotations.NotNull;

public class NextCompletionRequest {
    private static final Logger LOGGER = Logger.getInstance(NextCompletionRequest.class);
    protected static final Pattern XML_TAG_PATTERN = Pattern.compile("<[^>]+>");

    public static NextCompletionRequest build() {
        return new NextCompletionRequest();
    }

    public void triggerNext(@NotNull Editor editor) {
        boolean isInValidMiddle;
        if (editor == null) {
            NextCompletionRequest.$$$reportNull$$$0(0);
        }
        if (editor.isDisposed()) {
            LOGGER.warn("editor is disposed, cannot trigger next completion");
            return;
        }
        int caretOffset = EditorUtil.getCaretOffset(editor);
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(caretOffset);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        boolean isInCurlyBraces = this.isBetweenCurlyBraces(document, caretOffset);
        boolean isInXmlTags = this.isBetweenXmlTags(document, caretOffset);
        boolean bl = isInValidMiddle = isInCurlyBraces || isInXmlTags;
        if (caretOffset != lineEndOffset && !isInValidMiddle) {
            LOGGER.info("Cursor not at line end, ignoring next completion trigger");
            return;
        }
        String lineText = document.getText(new TextRange(document.getLineStartOffset(lineNumber), lineEndOffset));
        String afterCaretText = document.getText(new TextRange(caretOffset, lineEndOffset));
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)lineText)) {
            LOGGER.info("Line is empty, triggering completion at current position");
            ApplicationManager.getApplication().runReadAction(() -> this.triggerService(editor, editor.getDocument(), caretOffset));
            return;
        }
        if (!this.checkValidTrigger(lineText, afterCaretText, isInValidMiddle)) {
            LOGGER.info("Invalid trigger position, ignoring next completion trigger");
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            try {
                StringBuilder virtualDocumentText = new StringBuilder(document.getText());
                String currentLineIndent = this.getLineIndent(lineText);
                int newCaretLine = lineNumber + 1;
                virtualDocumentText.insert(caretOffset, this.getInsertCode(editor, lineText, isInCurlyBraces, isInXmlTags));
                EditorFactory editorFactory = EditorFactory.getInstance();
                Document virtualDocument = editorFactory.createDocument((CharSequence)virtualDocumentText);
                int newCaretOffset = virtualDocument.getLineEndOffset(newCaretLine);
                LOGGER.info("Triggering next completion at new position: " + newCaretOffset);
                this.triggerService(editor, virtualDocument, newCaretOffset);
            }
            catch (Exception e) {
                LOGGER.error("Error in triggering next completion", (Throwable)e);
            }
        });
    }

    private void triggerService(Editor editor, Document document, int triggerOffset) {
        try {
            InlayCompletionRequest request = InlayPreviewRequest.build().buildSyncCompletionRequest(CompletionTriggerConfig.defaultConfig(InlayTriggerEventEnum.ACCEPT_TRIGGER), editor, document, triggerOffset, CompletionTriggerModeEnum.ACCEPT);
            if (request == null) {
                return;
            }
            ThreadUtil.execute(() -> {
                TelemetryService.getInstance().triggerCompletion(CompletionTriggerModeEnum.ACCEPT, editor, request.getParams());
                List<CompletionItem> items = CosyCompletionService.getInstance().completion(editor.getProject(), request.getParams(), 10000L);
                if (items == null || items.isEmpty()) {
                    LOGGER.debug("trigger completion by accept no items, triggerOffset:" + triggerOffset);
                    return;
                }
                LOGGER.debug("add completion cache result for request " + request.getParams().getRequestId());
                CompletionItem completionItem = items.get(0);
                CompletionCacheManager.getInstance().add(request, completionItem);
            });
        }
        catch (Exception e) {
            LOGGER.warn("Error in triggering next completion", (Throwable)e);
        }
    }

    private boolean isBetweenCurlyBraces(Document document, int offset) {
        if (document == null || offset < 0 || offset >= document.getTextLength()) {
            return false;
        }
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        String lineText = document.getText(new TextRange(lineStartOffset, lineEndOffset));
        int column = offset - lineStartOffset;
        if (column <= 0 || column >= lineText.length()) {
            return false;
        }
        boolean leftBraceIndex = lineText.charAt(column - 1) == '{';
        boolean rightBraceIndex = lineText.charAt(column) == '}';
        return leftBraceIndex && rightBraceIndex;
    }

    private boolean isBetweenXmlTags(Document document, int offset) {
        if (document == null || offset < 0 || offset >= document.getTextLength()) {
            return false;
        }
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        String lineText = document.getText(new TextRange(lineStartOffset, lineEndOffset));
        int column = offset - lineStartOffset;
        if (column <= 0 || column >= lineText.length()) {
            return false;
        }
        boolean leftBraceIndex = lineText.charAt(column - 1) == '>';
        boolean rightBraceIndex = lineText.charAt(column) == '<';
        Matcher matcher = XML_TAG_PATTERN.matcher(lineText.trim());
        return leftBraceIndex && rightBraceIndex && matcher.find();
    }

    private boolean checkValidTrigger(String lineText, String afterCaretText, boolean isInValidMiddle) {
        if (lineText.trim().startsWith("return ") || lineText.trim().startsWith("return;")) {
            return false;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)afterCaretText)) {
            return true;
        }
        return isInValidMiddle;
    }

    private String getInsertCode(Editor editor, String lineText, boolean isInCurlyBraces, boolean isInXmlTags) {
        String currentLineIndent = this.getLineIndent(lineText);
        Object nextIndent = "";
        if (lineText.endsWith(";") || lineText.endsWith("}")) {
            nextIndent = currentLineIndent;
        } else if (lineText.endsWith("{") || lineText.endsWith(":") || isInXmlTags || isInCurlyBraces) {
            boolean useTab = editor.getSettings().isUseTabCharacter(editor.getProject());
            int tabSize = editor.getSettings().getTabSize(editor.getProject());
            nextIndent = currentLineIndent;
            nextIndent = useTab ? (String)nextIndent + "\t".repeat(tabSize) : (String)nextIndent + " ".repeat(tabSize);
        }
        if (!isInCurlyBraces && !isInXmlTags) {
            return "\n" + (String)nextIndent;
        }
        return "\n" + (String)nextIndent + "\n" + currentLineIndent;
    }

    private String getLineIndent(String line) {
        return StringUtils.countLeadingLength(line, StringUtils.TAB_SPACE_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/alibabacloud/intellij/qoder/editor/request/NextCompletionRequest", "triggerNext"));
    }
}

