/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.editor.request;

import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.editor.request.RuleBaseDelayStrategy;
import com.alibabacloud.intellij.qoder.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.qoder.search.enums.InlineTriggerModeEnum;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.service.model.Features;
import com.alibabacloud.intellij.qoder.service.model.TypingStat;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;

public class TypeSpeedDelayStrategy
extends RuleBaseDelayStrategy {
    private static final Logger LOGGER = Logger.getInstance(TypeSpeedDelayStrategy.class);

    @Override
    public long calculateDelay(CosySetting settings, Editor editor, String triggerMode, boolean isComment) {
        if (CompletionTriggerModeEnum.MANUAL.getName().equals(triggerMode)) {
            return super.calculateDelay(settings, editor, triggerMode, isComment);
        }
        if (InlineTriggerModeEnum.AUTO.getName().equals(triggerMode)) {
            return Features.INLINE_EDIT_AUTO_TRIGGER_DELAY.longValue();
        }
        if (InlineTriggerModeEnum.ACCEPTED.getName().equals(triggerMode)) {
            return Features.INLINE_EDIT_ACCEPT_TRIGGER_DELAY.longValue();
        }
        if (InlineTriggerModeEnum.CURSOR.getName().equals(triggerMode)) {
            return Features.INLINE_EDIT_CURSOR_TRIGGER_DELAY.longValue();
        }
        TypingStat stat = TelemetryService.getInstance().getTypeStat();
        double avgSpeed = stat.getAvgTypingSpeed();
        long minDelay = Features.COMPLETION_AUTO_MIN_DELAY.longValue();
        if (avgSpeed <= 0.0) {
            return super.calculateDelay(settings, editor, triggerMode, isComment);
        }
        if (avgSpeed < (double)minDelay) {
            if (isComment) {
                return super.calculateDelay(settings, editor, triggerMode, isComment);
            }
            return minDelay;
        }
        long extDelay = Features.COMPLETION_AUTO_TYPE_SPEED_EXT_DELAY.longValue();
        long maxDelay = Features.COMPLETION_AUTO_MAX_DELAY.longValue();
        long delay = (long)(avgSpeed + (double)extDelay);
        delay = Math.min(delay, maxDelay);
        if (isComment) {
            long defaultValue = super.calculateDelay(settings, editor, triggerMode, isComment);
            delay = Math.max(delay, defaultValue);
        }
        return delay;
    }
}

