/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.SwingUtilities;

public class WrappedFlowLayout
extends FlowLayout {
    public WrappedFlowLayout(int hGap, int vGap) {
        super(3, hGap, vGap);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension baseSize = super.preferredLayoutSize(target);
        return this.getAlignOnBaseline() ? baseSize : this.getWrappedSize(target);
    }

    public Dimension getWrappedSize(Container target) {
        Container parent = SwingUtilities.getUnwrappedParent(target);
        int maxWidth = parent.getWidth() - (parent.getInsets().left + parent.getInsets().right);
        return this.getDimension(target, maxWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getDimension(Container target, int maxWidth) {
        Insets insets = target.getInsets();
        int height = insets.top + insets.bottom;
        int width = insets.left + insets.right;
        int rowHeight = 0;
        int rowWidth = insets.left + insets.right;
        boolean isVisible = false;
        boolean start = true;
        Object object = target.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < target.getComponentCount(); ++i) {
                Component component = target.getComponent(i);
                if (!component.isVisible()) continue;
                isVisible = true;
                Dimension size = component.getPreferredSize();
                if (rowWidth + this.getHgap() + size.width > maxWidth && !start) {
                    height += this.getVgap() + rowHeight;
                    width = Math.max(width, rowWidth);
                    rowWidth = insets.left + insets.right;
                    rowHeight = 0;
                }
                rowWidth += this.getHgap() + size.width;
                rowHeight = Math.max(rowHeight, size.height);
                start = false;
            }
            height += this.getVgap() + rowHeight;
            width = Math.max(width, rowWidth);
            if (!isVisible) {
                return super.preferredLayoutSize(target);
            }
            return new Dimension(width, height);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.getAlignOnBaseline() ? super.minimumLayoutSize(target) : this.getWrappedSize(target);
    }
}

