/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.linguist.cache;

import com.alibabacloud.intellij.qoder.shared.cache.CacheManager;
import com.alibabacloud.intellij.qoder.shared.cache.TrieCacheManager;
import com.alibabacloud.intellij.qoder.util.ProjectUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class JDKClassLoading
implements Runnable {
    private static final Logger log = Logger.getInstance(JDKClassLoading.class);
    public static final String JDK_PACKAGE_PATH = "/completion/JDK11_package.txt";
    Project project;

    public JDKClassLoading(Project project) {
        this.project = project;
    }

    @Override
    public void run() {
        String[] packageList;
        log.info("Start to load JDK classes");
        String content = null;
        try {
            content = new String(ProjectUtils.class.getResourceAsStream(JDK_PACKAGE_PATH).readAllBytes());
        }
        catch (IOException e) {
            log.warn("/completion/JDK11_package.txt IO Exception. " + e.getMessage());
        }
        if (StringUtils.isEmpty((CharSequence)content)) {
            return;
        }
        for (String jdkPackage : packageList = content.split("\n")) {
            try {
                DumbService.getInstance((Project)this.project).runReadActionInSmartMode(() -> {
                    PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.project).findPackage(jdkPackage);
                    if (psiPackage == null) {
                        return;
                    }
                    PsiClass[] classes = psiPackage.getClasses();
                    CacheManager.getInheritClassCache().batchSet(classes);
                    TrieCacheManager.getProjectClassTrieCache().batchSet(Arrays.stream(classes).map(c -> c.getName()).collect(Collectors.toList()));
                });
            }
            catch (Exception e) {
                log.warn("JDK Class Loading Exception. " + e.getMessage());
            }
        }
    }
}

