/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.linguist.cache;

import com.alibabacloud.intellij.qoder.shared.cache.CacheManager;
import com.alibabacloud.intellij.qoder.shared.cache.TrieCacheManager;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public class ProjectClassLoading
implements Runnable {
    private static final Logger log = Logger.getInstance(ProjectClassLoading.class);
    public static final String PROJECT_CLASS_LOADING_KEY = "PROJECT_CLASS_LOADING_KEY";
    Project project;

    public ProjectClassLoading(Project project) {
        this.project = project;
    }

    private void loadClasses(Project project) {
        Collection virtualFiles = FileTypeIndex.getFiles((FileType)JavaFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScopes.projectProductionScope((Project)project));
        for (VirtualFile fileName : virtualFiles) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(fileName);
            if (!(psiFile instanceof PsiJavaFile)) continue;
            PsiJavaFile javaFile = (PsiJavaFile)psiFile;
            PsiClass[] classes = javaFile.getClasses();
            CacheManager.getInheritClassCache().batchSet(classes);
            TrieCacheManager.getProjectClassTrieCache().batchSet(Arrays.stream(classes).map(NavigationItem::getName).collect(Collectors.toList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        PropertiesComponent storage = PropertiesComponent.getInstance();
        if (storage.isTrueValue(PROJECT_CLASS_LOADING_KEY)) return;
        Class<ProjectClassLoading> clazz = ProjectClassLoading.class;
        synchronized (ProjectClassLoading.class) {
            if (storage.isTrueValue(PROJECT_CLASS_LOADING_KEY)) return;
            log.info("Start to load project classes");
            this.loadClasses(this.project);
            storage.setValue(PROJECT_CLASS_LOADING_KEY, true);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

