/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.linguist.provider;

import com.alibabacloud.intellij.qoder.linguist.model.ClassItem;
import com.alibabacloud.intellij.qoder.linguist.model.DefaultItem;
import com.alibabacloud.intellij.qoder.linguist.model.ItemBase;
import com.alibabacloud.intellij.qoder.linguist.provider.ProviderBase;
import com.alibabacloud.intellij.qoder.linguist.util.AvailableListUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.java.PsiLocalVariableImpl;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;

public class AfterNewProvider
implements ProviderBase {
    private static final Logger log = Logger.getInstance(AfterNewProvider.class);
    static final ElementPattern<PsiElement> AFTER_NEW = PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("new"));
    static final String ORIGIN = "AFTER_NEW";
    static final int PRIORITY = 1;

    @Override
    public boolean isApplicable(PsiElement psiElement) {
        return AFTER_NEW.accepts((Object)psiElement);
    }

    @Override
    public List<ItemBase> provide(Project project, PsiElement psiElement) {
        PsiElement resolved;
        PsiExpression psiLExpression;
        PsiAssignmentExpression psiAssignmentExpression;
        long st = System.currentTimeMillis();
        ArrayList<ItemBase> classList = new ArrayList<ItemBase>();
        PsiLocalVariableImpl psiLocalVariable = (PsiLocalVariableImpl)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiLocalVariable.class);
        if (psiLocalVariable != null && psiLocalVariable.getType() != null) {
            PsiType psiType = psiLocalVariable.getType();
            ClassItem classItem = AvailableListUtils.convertPsiTypeToClassItem(psiType, ORIGIN, 1);
            classList.add(classItem);
        }
        if ((psiAssignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiAssignmentExpression.class)) != null && (psiLExpression = psiAssignmentExpression.getLExpression()) != null && psiLExpression instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)psiLExpression).resolve()) != null && resolved instanceof PsiVariable) {
            PsiType psiType = ((PsiVariable)resolved).getType();
            ClassItem classItem = AvailableListUtils.convertPsiTypeToClassItem(psiType, ORIGIN, 1);
            classList.add(classItem);
        }
        if (classList.isEmpty()) {
            classList.add(new DefaultItem());
        }
        log.debug(String.format("AfterNewProvider consumed %d ms", System.currentTimeMillis() - st));
        return classList;
    }

    @Override
    public String getOrigin() {
        return ORIGIN;
    }

    @Override
    public int getPriority() {
        return 1;
    }
}

