/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.linguist.provider;

import com.alibabacloud.intellij.qoder.linguist.model.DefaultItem;
import com.alibabacloud.intellij.qoder.linguist.model.ItemBase;
import com.alibabacloud.intellij.qoder.linguist.provider.ProviderBase;
import com.alibabacloud.intellij.qoder.linguist.util.AvailableListUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;

public class StaticClassOrVariableDotProvider
implements ProviderBase {
    private static final Logger log = Logger.getInstance(StaticClassOrVariableDotProvider.class);
    static final PsiJavaElementPattern.Capture<PsiElement> STATIC_CLASS_OR_VARIABLE_DOT_PATTERN = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().andOr(new ElementPattern[]{PsiJavaPatterns.psiElement().withText("."), PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."})})).withSuperParent(1, PsiReferenceExpression.class)).afterLeafSkipping((ElementPattern)PsiJavaPatterns.psiElement().withText("."), (ElementPattern)PsiJavaPatterns.psiElement(PsiIdentifier.class));
    static final String ORIGIN = "STATIC_CLASS_OR_VARIABLE_DOT_PATTERN";
    static final int PRIORITY = 1;

    @Override
    public boolean isApplicable(PsiElement psiElement) {
        return STATIC_CLASS_OR_VARIABLE_DOT_PATTERN.accepts((Object)psiElement);
    }

    @Override
    public List<ItemBase> provide(Project project, PsiElement currentElement) {
        long st = System.currentTimeMillis();
        ArrayList<ItemBase> availableList = new ArrayList<ItemBase>();
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)currentElement, PsiReferenceExpression.class);
        PsiElement firstChild = psiReferenceExpression.getFirstChild();
        if (firstChild instanceof PsiReferenceExpression) {
            PsiElement resolved = ((PsiReferenceExpression)firstChild).resolve();
            if (resolved instanceof PsiVariable) {
                PsiType psiType = ((PsiVariable)resolved).getType();
                if (psiType instanceof PsiClassReferenceType) {
                    PsiClass psiClass = ((PsiClassReferenceType)psiType).resolve();
                    AvailableListUtils.addPsiClassToAvailableList(availableList, psiClass, firstChild, false, ORIGIN, 1);
                }
            } else if (resolved instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)resolved;
                AvailableListUtils.addPsiClassToAvailableList(availableList, psiClass, firstChild, true, ORIGIN, 1);
            }
        }
        if (availableList.isEmpty()) {
            availableList.add(new DefaultItem());
        }
        log.debug(String.format("StaticClassOrVariableDotProvider consumed %d ms", System.currentTimeMillis() - st));
        return availableList;
    }

    @Override
    public String getOrigin() {
        return ORIGIN;
    }

    @Override
    public int getPriority() {
        return 1;
    }
}

