/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.linguist.reference.signature;

import com.alibabacloud.intellij.qoder.linguist.reference.LazyLoader;
import com.alibabacloud.intellij.qoder.linguist.reference.signature.DefaultSignatureGenerator;
import com.alibabacloud.intellij.qoder.linguist.reference.signature.JavaSignatureGenerator;
import com.alibabacloud.intellij.qoder.linguist.reference.signature.SignatureGenerator;
import com.intellij.psi.PsiElement;
import java.util.Map;

public class SignatureUtil {
    private static final Map<String, LazyLoader<SignatureGenerator>> SIGNATURE_GENERATORS = Map.of("default", new LazyLoader<SignatureGenerator>(() -> new DefaultSignatureGenerator()), "java", new LazyLoader<SignatureGenerator>(() -> new JavaSignatureGenerator()));

    public static String generateSignature(PsiElement element) {
        String languageId = element.getLanguage().getID().toLowerCase();
        SignatureGenerator signatureGenerator = SIGNATURE_GENERATORS.getOrDefault(languageId, SIGNATURE_GENERATORS.get("default")).get();
        return signatureGenerator.generateSignature(element);
    }
}

