/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.linguist.util;

import com.alibabacloud.intellij.qoder.linguist.psi.model.resolved.CosyPsiClass;
import com.alibabacloud.intellij.qoder.linguist.psi.model.resolved.CosyPsiField;
import com.alibabacloud.intellij.qoder.linguist.psi.model.resolved.CosyPsiMethod;
import com.alibabacloud.intellij.qoder.linguist.psi.model.resolved.CosyPsiType;
import com.alibabacloud.intellij.qoder.linguist.psi.model.resolved.CosyPsiVariable;
import com.alibabacloud.intellij.qoder.linguist.psi.model.resolved.CosyResolvedBase;
import com.alibabacloud.intellij.qoder.shared.cache.CacheManager;
import com.alibabacloud.intellij.qoder.util.ProjectUtils;
import com.alibabacloud.intellij.qoder.util.PsiUtils;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.AllClassesSearchExecutor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CosyPsiUtils {
    private static final Logger log = Logger.getInstance(CosyPsiUtils.class);
    public static final int TOO_SHORT_QUERY_LIMIT = 2;
    public static final int TOO_MANY_NAME_MATCH_LIMITATION = 15;
    private static final Integer CORE_SIZE = 5;
    private static final Integer MAXIMUM_POOL_SIZE = 20;
    private static final Long KEEP_ALIVE_TIME_SECONDS = 1L;
    private static final ThreadPoolExecutor getVarExecutor = new ThreadPoolExecutor(CORE_SIZE, MAXIMUM_POOL_SIZE, KEEP_ALIVE_TIME_SECONDS, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(MAXIMUM_POOL_SIZE), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
    private static final PsiJavaElementPattern.Capture<PsiElement> HAS_DOT = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().beforeLeaf(new String[]{"."});
    static final ElementPattern<PsiElement> AFTER_NEW = PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("new"));
    private static final long ITEM_LIMITATION = 10L;

    public static CosyPsiType convertPsiType(PsiType psiType) {
        if (psiType == null) {
            return null;
        }
        CosyPsiType cosyPsiType = new CosyPsiType();
        try {
            cosyPsiType.setTypeName(psiType.getPresentableText());
            cosyPsiType.setTypeFullPath(psiType.getCanonicalText());
        }
        catch (RuntimeException e) {
            log.warn(String.format("psiType canonical text %s encountered PsiInvalidElementAccessException: %s", cosyPsiType.getTypeName(), e.getMessage()));
            cosyPsiType.setTypeName("");
            cosyPsiType.setTypeFullPath("");
        }
        return cosyPsiType;
    }

    public static CosyPsiClass convertPsiClass(PsiClass psiClass) {
        if (psiClass == null) {
            return null;
        }
        CacheManager.getInheritClassCache().set(psiClass);
        CosyPsiType cosyPsiType = new CosyPsiType();
        cosyPsiType.setTypeName(psiClass.getName());
        cosyPsiType.setTypeFullPath(psiClass.getQualifiedName());
        CosyPsiClass cosyPsiClass = new CosyPsiClass();
        cosyPsiClass.setPsiType(cosyPsiType);
        return cosyPsiClass;
    }

    public static CosyPsiMethod convertPsiMethod(PsiMethod psiMethod) {
        if (psiMethod == null) {
            return null;
        }
        CosyPsiMethod cosyPsiMethod = new CosyPsiMethod();
        cosyPsiMethod.setMethodName(psiMethod.getName());
        cosyPsiMethod.setReturnType(CosyPsiUtils.convertPsiType(psiMethod.getReturnType()));
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        CosyPsiType[] cosyParameters = Arrays.stream(parameters).map(p -> CosyPsiUtils.convertPsiType(p.getType())).collect(Collectors.toList()).toArray(new CosyPsiType[parameters.length]);
        cosyPsiMethod.setArgumentList(cosyParameters);
        return cosyPsiMethod;
    }

    public static CosyPsiField convertPsiField(PsiField psiField) {
        if (psiField == null) {
            return null;
        }
        CosyPsiField cosyPsiField = new CosyPsiField();
        cosyPsiField.setFieldName(psiField.getName());
        cosyPsiField.setPsiType(CosyPsiUtils.convertPsiType(psiField.getType()));
        return cosyPsiField;
    }

    public static CosyPsiVariable convertPsiVariable(PsiVariable psiVariable) {
        if (psiVariable == null) {
            return null;
        }
        CosyPsiVariable cosyPsiVariable = new CosyPsiVariable();
        cosyPsiVariable.setPsiType(CosyPsiUtils.convertPsiType(psiVariable.getType()));
        cosyPsiVariable.setVariableName(psiVariable.getName());
        return cosyPsiVariable;
    }

    public static List<CosyResolvedBase> guessResolvedElementWithTimeout(PsiElement psiElement) {
        Callable<List> guessTask = () -> (List)ApplicationManager.getApplication().runReadAction(() -> CosyPsiUtils.guessResolvedElement(psiElement));
        Future guessFuture = ApplicationManager.getApplication().executeOnPooledThread(guessTask);
        ArrayList<CosyResolvedBase> result = new ArrayList<CosyResolvedBase>();
        try {
            List temp = (List)guessFuture.get(70L, TimeUnit.MILLISECONDS);
            if (CollectionUtils.isNotEmpty((Collection)temp)) {
                result.addAll(temp);
            }
        }
        catch (TimeoutException timeoutException) {
            log.warn(String.format("Guess psi %s timeout", psiElement.getText()));
        }
        catch (Exception e) {
            log.warn(String.format("Guess psi %s failed", psiElement.getText()), (Throwable)e);
        }
        return result;
    }

    public static List<CosyResolvedBase> guessResolvedElement(PsiElement psiElement) {
        ArrayList<CosyResolvedBase> result = new ArrayList<CosyResolvedBase>();
        if (psiElement == null) {
            return result;
        }
        String currentText = psiElement.getText();
        if (StringUtils.isEmpty((CharSequence)currentText) || currentText.length() <= 2) {
            return result;
        }
        long st0 = System.currentTimeMillis();
        if (Character.isUpperCase(currentText.charAt(0))) {
            List<String> potentialClassesNames;
            Project project = psiElement.getProject();
            PsiFile psiFile = psiElement.getContainingFile();
            ArrayList<String> imports = new ArrayList<String>();
            if (psiFile instanceof PsiJavaFile) {
                PsiImportStatementBase[] importStatements;
                PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
                for (PsiImportStatementBase psiImportStatementBase : importStatements = psiJavaFile.getImportList().getAllImportStatements()) {
                    if (psiImportStatementBase.getImportReference() == null || !StringUtils.isNotEmpty((CharSequence)psiImportStatementBase.getImportReference().getQualifiedName())) continue;
                    imports.add(psiImportStatementBase.getImportReference().getQualifiedName());
                }
            }
            if ((potentialClassesNames = ProjectUtils.loadAllClassNames(project, psiElement.getText(), s -> s.startsWith(psiElement.getText()))).size() >= 15) {
                log.debug(String.format("Guessing potential name result has %d results, which achieves upper bound limitation %d", potentialClassesNames.size(), 15));
                return result;
            }
            ArrayList<CosyPsiClass> potentialClasses = new ArrayList<CosyPsiClass>();
            AllClassesSearchExecutor.processClassesByNames((Project)project, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project), potentialClassesNames, s -> {
                if (s != null && s.getQualifiedName() != null && s.getName() != null) {
                    CacheManager.getInheritClassCache().set(s);
                    potentialClasses.add(CosyPsiUtils.convertPsiClass(s));
                }
                return true;
            });
            CosyPsiClass bestGuess = CosyPsiUtils.extractBestGuess(potentialClasses, imports);
            if (bestGuess != null) {
                result.add(bestGuess);
            }
            long st1 = System.currentTimeMillis();
            log.debug(String.format("Guess parse class extract best guess for %s consumed %d ms", currentText, st1 - st0));
        } else if (Character.isLowerCase(currentText.charAt(0))) {
            PsiVariable[] vars = CosyPsiUtils.getVariablesWithTimeout(psiElement, true, 30L);
            List<CosyPsiVariable> variables = Arrays.stream(vars).filter(v -> v.getName().startsWith(psiElement.getText())).map(v -> CosyPsiUtils.convertPsiVariable(v)).collect(Collectors.toList());
            CosyPsiVariable bestGuess = CosyPsiUtils.extractBestGuess(variables);
            if (bestGuess != null) {
                result.add(bestGuess);
            }
            long st1 = System.currentTimeMillis();
            log.debug(String.format("Guess parse var extract best guess consumed %d ms", st1 - st0));
        }
        return result;
    }

    public static CosyPsiClass extractBestGuess(List<CosyPsiClass> potentialClasses, List<String> imports) {
        ArrayList<CosyPsiClass> importMatchItems = new ArrayList<CosyPsiClass>();
        for (CosyPsiClass cosyPsiClass : potentialClasses) {
            CosyPsiType type = cosyPsiClass.getPsiType();
            String fullPath = type.getTypeFullPath();
            if (fullPath == null) continue;
            for (String importItem : imports) {
                if (!fullPath.equals(importItem) && !fullPath.startsWith(importItem)) continue;
                importMatchItems.add(cosyPsiClass);
            }
        }
        if (importMatchItems.isEmpty()) {
            importMatchItems.addAll(potentialClasses);
        }
        importMatchItems.sort(new Comparator<CosyPsiClass>(){

            @Override
            public int compare(CosyPsiClass o1, CosyPsiClass o2) {
                return o1.getPsiType().getTypeName().length() - o2.getPsiType().getTypeName().length();
            }
        });
        if (importMatchItems.size() > 0) {
            return (CosyPsiClass)importMatchItems.get(0);
        }
        return null;
    }

    public static CosyPsiVariable extractBestGuess(List<CosyPsiVariable> potentialVariables) {
        potentialVariables.sort(new Comparator<CosyPsiVariable>(){

            @Override
            public int compare(CosyPsiVariable o1, CosyPsiVariable o2) {
                return o1.getVariableName().length() - o2.getVariableName().length();
            }
        });
        if (potentialVariables.size() > 0) {
            return potentialVariables.get(0);
        }
        return null;
    }

    public static PsiVariable[] getVariablesWithTimeout(final PsiElement psiElement, final boolean hasPrefix, long timeout) {
        Callable<PsiVariable[]> getVarTask = new Callable<PsiVariable[]>(){

            @Override
            public PsiVariable[] call() throws Exception {
                return (PsiVariable[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiVariable[]>(){

                    public PsiVariable[] compute() {
                        String prefix = hasPrefix ? psiElement.getText() : "";
                        PsiVariable[] currentVars = MacroUtil.getVariablesVisibleAt((PsiElement)psiElement.getContext(), (String)prefix);
                        return currentVars;
                    }
                });
            }
        };
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Future getVarFuture = ApplicationManager.getApplication().executeOnPooledThread((Callable)getVarTask);
        PsiVariable[] vars = new PsiVariable[]{};
        try {
            vars = (PsiVariable[])getVarFuture.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            log.warn(String.format("Get var %s timeout", psiElement.getText()));
        }
        catch (Exception e) {
            log.warn(String.format("Get var %s failed", psiElement.getText()), (Throwable)e);
        }
        return vars;
    }

    public static void findMethodsFieldsFromPsiTypeWhenDot(CosyPsiType cosyPsiType, PsiClass psiClass, PsiElement psiElement, boolean isStatic) {
        if (cosyPsiType == null || psiClass == null) {
            return;
        }
        if (HAS_DOT.accepts((Object)psiElement)) {
            PsiElement nextMeaningfulElement = PsiUtils.skipEmptyAndJavaTokenForward(psiElement);
            String prefix = nextMeaningfulElement == null ? "" : nextMeaningfulElement.getText().toLowerCase();
            PsiClass contextClass = PsiUtils.getContainingClass(psiElement);
            Predicate<PsiModifierListOwner> predicator = PsiUtils.generateVisibilityPredicator(psiClass, contextClass);
            PsiMethod[] psiMethods = PsiUtils.getMethodsFromPsiClass(psiClass, isStatic, prefix, predicator);
            cosyPsiType.setMethods(Arrays.stream(psiMethods).map(m -> CosyPsiUtils.convertPsiMethod(m)).limit(10L).collect(Collectors.toList()).toArray(new CosyPsiMethod[0]));
            PsiField[] psiFields = PsiUtils.getFieldsFromPsiClass(psiClass, isStatic, prefix, predicator);
            cosyPsiType.setFields(Arrays.stream(psiFields).map(f -> CosyPsiUtils.convertPsiField(f)).limit(10L).collect(Collectors.toList()).toArray(new CosyPsiField[0]));
        }
    }

    public static void findConstructorForPsiTypeWhenNew(CosyPsiType cosyPsiType, PsiClass psiClass, PsiElement psiElement) {
        if (AFTER_NEW.accepts((Object)psiElement)) {
            PsiMethod[] constructors = psiClass.getConstructors();
            CosyPsiMethod[] originalMethods = cosyPsiType.getMethods();
            ArrayList<CosyPsiMethod> methods = new ArrayList<CosyPsiMethod>();
            if (originalMethods != null) {
                methods.addAll(Arrays.asList(originalMethods));
            }
            List constructorMethods = Arrays.stream(constructors).map(m -> CosyPsiUtils.convertPsiMethod(m)).collect(Collectors.toList());
            methods.addAll(constructorMethods);
            if (CollectionUtils.isNotEmpty(methods)) {
                cosyPsiType.setMethods(methods.toArray(new CosyPsiMethod[methods.size()]));
            }
        }
    }
}

