/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.listener;

import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.completion.template.TemplateSettingLoader;
import com.alibabacloud.intellij.qoder.completion.trigger.TriggerCheckContext;
import com.alibabacloud.intellij.qoder.completion.trigger.TriggerExecutor;
import com.alibabacloud.intellij.qoder.completion.trigger.TriggerExecutorFactory;
import com.alibabacloud.intellij.qoder.constants.TongyiCommands;
import com.alibabacloud.intellij.qoder.editor.CosyInlayManager;
import com.alibabacloud.intellij.qoder.editor.CosyInlineEditManager;
import com.alibabacloud.intellij.qoder.editor.cache.InlineEditCache;
import com.alibabacloud.intellij.qoder.editor.inline.InlineEditUtil;
import com.alibabacloud.intellij.qoder.editor.model.CompletionTriggerConfig;
import com.alibabacloud.intellij.qoder.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.qoder.editor.model.InlayTriggerEventEnum;
import com.alibabacloud.intellij.qoder.editor.model.InlineEditRequest;
import com.alibabacloud.intellij.qoder.editor.model.InlineEditSession;
import com.alibabacloud.intellij.qoder.listener.inline.TypingChangeWatcher;
import com.alibabacloud.intellij.qoder.listener.model.CommandEditorState;
import com.alibabacloud.intellij.qoder.search.enums.InlineTriggerModeEnum;
import com.alibabacloud.intellij.qoder.service.model.Features;
import com.alibabacloud.intellij.qoder.util.CompletionUtil;
import com.alibabacloud.intellij.qoder.util.DocumentUtils;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.PsiUtils;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CosyCommandListener
implements CommandListener {
    private static final Logger LOG = Logger.getInstance(CosyCommandListener.class);
    private static final List<String> skipCommands = Arrays.asList("Undo", "Backspace", "Paste", "Redo", "Copy", "\u64a4\u6d88\u7c98\u8d34", "\u9000\u683c", "\u7c98\u8d34", "\u91cd\u505a\u7c98\u8d34", "\u590d\u5236");
    private static final Set<String> ALLOW_COMMANDS = Set.of("Typing", "\u8f93\u5165");
    private static final Set<String> ALLOW_INLINE_EDIT_COMMANDS = Set.of("Typing", "\u8f93\u5165", "Backspace", "Paste", "\u9000\u683c", "\u7c98\u8d34", "\u91cd\u505a\u7c98\u8d34", "VimEditorBackSpace", "VimDeleteMotionAction", "VimDeleteCharacterRightAction", "VimDeleteCharacterLeftAction", "VimPutTextAfterCursorAction", "VimPutTextBeforeCursorAction", "VimDeleteVisualAction");
    private static final List<String> ignoreCommands = Arrays.asList("Apply Tongyi Inline Suggestion", "Async Render Tongyi Suggestion", "Chat Insert Code");
    private final Project project;
    private final AtomicInteger activeCommands;
    private final AtomicBoolean startedWithEditor;
    private final AtomicReference<UndoTransparentActionState> undoTransparentActionStamp;

    public CosyCommandListener(@NotNull Project project) {
        if (project == null) {
            CosyCommandListener.$$$reportNull$$$0(0);
        }
        this.activeCommands = new AtomicInteger();
        this.startedWithEditor = new AtomicBoolean(false);
        this.undoTransparentActionStamp = new AtomicReference();
        this.project = project;
    }

    public void commandStarted(@NotNull CommandEvent event) {
        if (event == null) {
            CosyCommandListener.$$$reportNull$$$0(1);
        }
        if (this.activeCommands.getAndIncrement() > 0) {
            LOG.info("Skipping nested commandStarted. Event: " + event);
            return;
        }
        Editor editor = EditorUtil.getSelectedEditorSafely(this.project);
        if (editor != null) {
            this.startedWithEditor.set(true);
            CosyCacheKeys.COMMAND_STATE_KEY.set((UserDataHolder)editor, (Object)CommandEditorState.createCommandState(editor));
        } else {
            this.startedWithEditor.set(false);
        }
    }

    public void commandFinished(@NotNull CommandEvent event) {
        TemplateManager templateManager;
        if (event == null) {
            CosyCommandListener.$$$reportNull$$$0(2);
        }
        if (this.activeCommands.decrementAndGet() > 0) {
            LOG.info("Skipping nested commandFinished. Event: " + event);
            return;
        }
        if (!this.startedWithEditor.get() || event.getCommandName() == null) {
            return;
        }
        Editor editor = EditorUtil.getSelectedEditorSafely(this.project);
        if (editor == null) {
            LOG.debug("invalid editor from project:" + this.project);
            return;
        }
        Document document = event.getDocument();
        if (document == null) {
            document = editor.getDocument();
        }
        if (!DocumentUtils.isValidEditorDocument(document)) {
            LOG.debug("invalid document:" + document.getClass().getName());
            return;
        }
        CosyInlayManager editorManager = CosyInlayManager.getInstance();
        if (!editorManager.isAvailable(editor) || editor.getCaretModel().getCaretCount() > 1 || !EditorUtil.isAvailableLanguage(editor)) {
            return;
        }
        if (!EditorUtil.isActiveProjectEditor(editor)) {
            return;
        }
        CommandEditorState commandStartState = (CommandEditorState)CosyCacheKeys.COMMAND_STATE_KEY.get((UserDataHolder)editor);
        if (commandStartState != null) {
            CommandEditorState commandEndState = CommandEditorState.createCommandState(editor);
            TypingChangeWatcher.recordTextChange(editor, event, commandStartState, commandEndState);
        }
        if ((templateManager = TemplateManager.getInstance((Project)this.project)).getActiveTemplate(editor) != null) {
            LOG.debug("Skipping template completion. Event: " + event.getCommandName());
            InlineEditUtil.disposeAllInline(editor, InlayDisposeEventEnum.LIVE_TEMPLATE, event.getCommandName());
            editorManager.cancelCompletion(editor);
            return;
        }
        String commandName = event.getCommandName().toLowerCase(Locale.ROOT);
        if (ignoreCommands.contains(commandName) || commandName.contains("tongyi") || TongyiCommands.ALL_TONGYI_COMMANDS.contains(commandName)) {
            if (CosyInlineEditManager.getInstance().hasInlineEdits(editor) && !"Apply Tongyi Inline Edit".equals(event.getCommandName())) {
                CosyInlineEditManager.getInstance().disposeInlineEdits(editor, InlayDisposeEventEnum.CHANGE_COMMAND, commandName);
            }
            return;
        }
        CommandEditorState commandEndState = CommandEditorState.createCommandState(editor);
        boolean inlineTriggered = this.triggerInlineEdit(editor, commandStartState, commandEndState, event);
        if (!inlineTriggered) {
            this.triggerCompletion(editor, commandStartState, commandEndState, event);
        }
        if (commandStartState != null) {
            int newOffset;
            int previousOffset = commandStartState.getOffset();
            if (previousOffset < (newOffset = commandEndState.getOffset()) && newOffset - previousOffset < 3 && newOffset < document.getTextLength()) {
                String addedText = document.getText(new TextRange(previousOffset, newOffset));
                document.putUserData(CosyCacheKeys.KEY_LAST_CHANGE_TEXT, (Object)new Pair((Object)addedText, (Object)System.currentTimeMillis()));
            } else {
                editor.getDocument().putUserData(CosyCacheKeys.KEY_LAST_CHANGE_TEXT, null);
            }
        }
    }

    private boolean triggerCompletion(Editor editor, CommandEditorState commandStartState, CommandEditorState commandEndState, CommandEvent event) {
        CosyInlayManager editorManager = CosyInlayManager.getInstance();
        if (event.getCommandName() != null && this.isSkipCommand(event.getCommandName())) {
            LOG.debug("Skipping invalid command. Event: " + event.getCommandName());
            editor.getDocument().putUserData(CosyCacheKeys.KEY_LAST_CHANGE_TEXT, null);
            InlineEditUtil.disposeAllInline(editor, InlayDisposeEventEnum.CHANGE_COMMAND, event.getCommandName());
            editorManager.cancelCompletion(editor);
            return false;
        }
        if (commandStartState != null) {
            if (StringUtils.isNotBlank((CharSequence)commandStartState.getSelectionText())) {
                return false;
            }
            TypingChangeWatcher.recordType(editor, event, commandStartState, commandEndState);
            if (!"".equals(event.getCommandName()) && LOG.isDebugEnabled()) {
                LOG.debug("document command: " + event.getCommandName());
            }
            boolean needTrggier = false;
            if (this.isValidCommand(editor, event.getCommandName()) && CompletionUtil.isTriggerWhenLookup(editor)) {
                needTrggier = true;
            }
            if (needTrggier && this.isDocumentModified(editor, commandStartState, commandEndState, event.getCommandName()) && !this.isCompletionTemplate(editor)) {
                editorManager.editorChanged(CompletionTriggerConfig.defaultConfig(InlayTriggerEventEnum.TYPING), editor);
                return true;
            }
            if (CosyCommandListener.isCaretPositionChange(commandStartState, commandEndState)) {
                CompletionUtil.triggerCursorPreCompletion(editor);
                InlineEditUtil.disposeAllInline(editor, InlayDisposeEventEnum.CHANGE_CARET, event.getCommandName());
            }
        }
        return false;
    }

    private boolean isValidCommand(Editor editor, String commandName) {
        if (ALLOW_COMMANDS.contains(commandName)) {
            return true;
        }
        return "".equals(commandName) && LookupManager.getActiveLookup((Editor)editor) != null;
    }

    private boolean isSkipCommand(String commandName) {
        boolean skip = skipCommands.stream().anyMatch(commandName::contains);
        if (!skip && commandName.toLowerCase(Locale.ROOT).contains("vim")) {
            skip = true;
        }
        return skip;
    }

    public void undoTransparentActionStarted() {
        Editor editor = EditorUtil.getSelectedEditorSafely(this.project);
        this.undoTransparentActionStamp.set(editor != null ? CosyCommandListener.createUndoTransparentState(editor) : null);
    }

    public void undoTransparentActionFinished() {
    }

    private static long getDocumentStamp(@NotNull Document document) {
        if (document == null) {
            CosyCommandListener.$$$reportNull$$$0(3);
        }
        if (document instanceof DocumentEx) {
            return ((DocumentEx)document).getModificationSequence();
        }
        return document.getModificationStamp();
    }

    @NotNull
    private static UndoTransparentActionState createUndoTransparentState(@NotNull Editor editor) {
        if (editor == null) {
            CosyCommandListener.$$$reportNull$$$0(4);
        }
        return new UndoTransparentActionState(editor, CosyCommandListener.getDocumentStamp(editor.getDocument()));
    }

    private boolean isDocumentModified(@NotNull Editor editor, @NotNull CommandEditorState first, @NotNull CommandEditorState second, String commandName) {
        if (editor == null) {
            CosyCommandListener.$$$reportNull$$$0(5);
        }
        if (first == null) {
            CosyCommandListener.$$$reportNull$$$0(6);
        }
        if (second == null) {
            CosyCommandListener.$$$reportNull$$$0(7);
        }
        return this.isDocumentModifiedNewest(editor, first, second, commandName);
    }

    private boolean isDocumentModifiedNewest(@NotNull Editor editor, @NotNull CommandEditorState first, @NotNull CommandEditorState second, String commandName) {
        if (editor == null) {
            CosyCommandListener.$$$reportNull$$$0(8);
        }
        if (first == null) {
            CosyCommandListener.$$$reportNull$$$0(9);
        }
        if (second == null) {
            CosyCommandListener.$$$reportNull$$$0(10);
        }
        if (first.getModificationStamp() == second.getModificationStamp()) {
            return false;
        }
        if (!editor.getEditorKind().equals((Object)EditorKind.MAIN_EDITOR) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return false;
        }
        try {
            LOG.debug("Checking completion trigger");
            TriggerExecutor executor = TriggerExecutorFactory.getCompletionExecutor();
            return executor.check(new TriggerCheckContext(editor, first.getOffset(), second.getOffset(), null, commandName), true);
        }
        catch (Exception e) {
            LOG.error("fail to check document modified.", (Throwable)e);
            return false;
        }
    }

    private boolean triggerInlineEdit(Editor editor, CommandEditorState first, CommandEditorState second, CommandEvent event) {
        if (!InlineEditUtil.isEnableNES()) {
            return false;
        }
        if (first != null && second != null) {
            if (this.isPassInlineEditTriggerWhenTyping(editor, first, second, event)) {
                CosyInlineEditManager.getInstance().inlineEdit(editor, InlineTriggerModeEnum.TYPING);
                return true;
            }
            if (CosyCommandListener.isCaretPositionChange(first, second)) {
                return this.tryTriggerNesWhenCursorChange(editor, first, second, event.getCommandName());
            }
        }
        return false;
    }

    private boolean isPassInlineEditTriggerWhenTyping(Editor editor, CommandEditorState first, CommandEditorState second, CommandEvent event) {
        if (first.getModificationStamp() == second.getModificationStamp()) {
            return false;
        }
        if (!editor.getEditorKind().equals((Object)EditorKind.MAIN_EDITOR) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return false;
        }
        String commandName = event.getCommandName();
        if (!ALLOW_INLINE_EDIT_COMMANDS.contains(commandName)) {
            return false;
        }
        PsiElement element = PsiUtils.getCaratElement(editor);
        if (PsiUtils.isCommentElement(element, editor)) {
            return false;
        }
        try {
            LOG.debug("Checking inline edit trigger");
            TriggerExecutor executor = TriggerExecutorFactory.getInlineEditExecutor();
            return executor.check(new TriggerCheckContext(editor, first.getOffset(), second.getOffset(), null, commandName), false);
        }
        catch (Exception e) {
            LOG.error("Failed to check inline edit trigger", (Throwable)e);
            return false;
        }
    }

    private boolean tryTriggerNesWhenCursorChange(@NotNull Editor editor, @NotNull CommandEditorState first, @NotNull CommandEditorState second, String commandName) {
        int afterLineNum;
        InlineEditRequest request;
        if (editor == null) {
            CosyCommandListener.$$$reportNull$$$0(11);
        }
        if (first == null) {
            CosyCommandListener.$$$reportNull$$$0(12);
        }
        if (second == null) {
            CosyCommandListener.$$$reportNull$$$0(13);
        }
        if (!"".equals(commandName)) {
            InlineEditUtil.disposeAllInline(editor, InlayDisposeEventEnum.CHANGE_CARET, commandName);
            return false;
        }
        InlineEditSession session = (InlineEditSession)CosyCacheKeys.KEY_INLINE_EDIT_SESSION.get((UserDataHolder)this.project);
        if (session != null && (request = session.getCurrentRequest()) != null && request.hasShowingInlineEdit()) {
            if (!request.isChangeActivated()) {
                InlineEditUtil.disposeAllInline(editor, InlayDisposeEventEnum.CHANGE_CARET);
                return false;
            }
            request.setRenderActive(true);
            return true;
        }
        int beforeLineNum = first.getOffset() < editor.getDocument().getTextLength() ? editor.getDocument().getLineNumber(first.getOffset()) : -1;
        int n = afterLineNum = second.getOffset() < editor.getDocument().getTextLength() ? editor.getDocument().getLineNumber(second.getOffset()) : -1;
        if (beforeLineNum == afterLineNum) {
            LOG.debug(String.format("Caret line not change, skip trigger inline edit, beforeLineNum: %s, afterLineNum: %s", beforeLineNum, afterLineNum));
            return false;
        }
        if (InlineEditCache.checkNesLineRepeatTrigger(editor)) {
            return false;
        }
        if (InlineEditCache.checkNesLineContentChangeTrigger(editor)) {
            return false;
        }
        PsiElement element = PsiUtils.getCaratElement(editor);
        if (element != null) {
            LOG.debug("caret element class:" + element.getClass() + " parent:" + element.getParent().getClass());
        }
        if (PsiUtils.isCommentElement(element, editor)) {
            return false;
        }
        String lineText = DocumentUtils.getLineByOffset(editor, second.getOffset());
        if (StringUtils.isBlank((CharSequence)(lineText = StringUtils.strip((String)lineText, (String)" \t\r\n}{/#*<>")))) {
            return false;
        }
        try {
            if (Features.INLINE_EDIT_CURSOR_TRIGGER_ONLY_WHEN_ERROR.booleanValue().booleanValue()) {
                boolean validLintError = false;
                List<HighlightInfo> errorLint = EditorUtil.getDiagnostics(editor);
                for (HighlightInfo info : errorLint) {
                    int startLine = editor.getDocument().getLineNumber(info.getStartOffset());
                    int endLine = editor.getDocument().getLineNumber(info.getEndOffset());
                    if (startLine < afterLineNum || endLine > afterLineNum) continue;
                    validLintError = true;
                    break;
                }
                if (!validLintError) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get diagnostics", (Throwable)e);
        }
        CosyInlineEditManager.getInstance().inlineEdit(editor, InlineTriggerModeEnum.CURSOR);
        return true;
    }

    private boolean isCompletionTemplate(@NotNull Editor editor) {
        String currentContent;
        if (editor == null) {
            CosyCommandListener.$$$reportNull$$$0(14);
        }
        if (StringUtils.isNotBlank((CharSequence)(currentContent = DocumentUtils.getCurrentLine(editor))) && TemplateSettingLoader.getInstance().getCurrentTemplateKeys(editor).contains(currentContent.trim())) {
            LOG.debug(String.format("Current content %s matches with live template, skip", currentContent));
            return true;
        }
        return false;
    }

    private static boolean isCaretPositionChange(@NotNull CommandEditorState first, @NotNull CommandEditorState second) {
        if (first == null) {
            CosyCommandListener.$$$reportNull$$$0(15);
        }
        if (second == null) {
            CosyCommandListener.$$$reportNull$$$0(16);
        }
        return !first.getVisualPosition().equals((Object)second.getVisualPosition());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/qoder/listener/CosyCommandListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "commandStarted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "commandFinished";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocumentStamp";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createUndoTransparentState";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocumentModified";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocumentModifiedNewest";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "tryTriggerNesWhenCursorChange";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompletionTemplate";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isCaretPositionChange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class UndoTransparentActionState {
        @NotNull
        private final Editor editor;
        private final long modificationStamp;

        public UndoTransparentActionState(@NotNull Editor editor, long modificationStamp) {
            if (editor == null) {
                UndoTransparentActionState.$$$reportNull$$$0(0);
            }
            this.editor = editor;
            this.modificationStamp = modificationStamp;
        }

        @NotNull
        @Generated
        public Editor getEditor() {
            Editor editor = this.editor;
            if (editor == null) {
                UndoTransparentActionState.$$$reportNull$$$0(1);
            }
            return editor;
        }

        @Generated
        public long getModificationStamp() {
            return this.modificationStamp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UndoTransparentActionState)) {
                return false;
            }
            UndoTransparentActionState other = (UndoTransparentActionState)o;
            Editor this$editor = this.getEditor();
            Editor other$editor = other.getEditor();
            if (this$editor == null ? other$editor != null : !this$editor.equals(other$editor)) {
                return false;
            }
            return this.getModificationStamp() == other.getModificationStamp();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Editor $editor = this.getEditor();
            result = result * 59 + ($editor == null ? 43 : $editor.hashCode());
            long $modificationStamp = this.getModificationStamp();
            result = result * 59 + (int)($modificationStamp >>> 32 ^ $modificationStamp);
            return result;
        }

        @Generated
        public String toString() {
            return "CosyCommandListener.UndoTransparentActionState(editor=" + this.getEditor() + ", modificationStamp=" + this.getModificationStamp() + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/alibabacloud/intellij/qoder/listener/CosyCommandListener$UndoTransparentActionState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/alibabacloud/intellij/qoder/listener/CosyCommandListener$UndoTransparentActionState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

