/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.listener;

import com.alibabacloud.intellij.qoder.ui.search.model.ActiveFileInfo;
import com.alibabacloud.intellij.qoder.ui.search.topic.EditorActiveFileNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.EditorSelectedCodeNotifier;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

public class CosyCurrentFileSelectionListener
implements SelectionListener,
Disposable {
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private static final int DELAY = 300;
    public static Key<Boolean> KEY_TEMP_FILE_SHOULD_NOT_QUOTE = Key.create((String)"KEY_TEMP_FILE_SHOULD_NOT_QUOTE");

    public void selectionChanged(@NotNull SelectionEvent e) {
        if (e == null) {
            CosyCurrentFileSelectionListener.$$$reportNull$$$0(0);
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> ApplicationManager.getApplication().invokeLater(() -> this.processSelection(e)), 300);
    }

    private void processSelection(@NotNull SelectionEvent e) {
        if (e == null) {
            CosyCurrentFileSelectionListener.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            Editor editor = e.getEditor();
            Project project = editor.getProject();
            if (editor.isDisposed() || project == null) {
                return;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (null != virtualFile && null != virtualFile.getUserData(KEY_TEMP_FILE_SHOULD_NOT_QUOTE) && Boolean.TRUE.equals(virtualFile.getUserData(KEY_TEMP_FILE_SHOULD_NOT_QUOTE))) {
                return;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            ActiveFileInfo fileInfo = ActiveFileInfo.getFromEditor(editor);
            if (!FileUtil.isValidProjectFile(project, FileDocumentManager.getInstance().getFile(editor.getDocument())).booleanValue()) {
                ((EditorActiveFileNotifier)project.getMessageBus().syncPublisher(EditorActiveFileNotifier.EDITOR_ACTIVE_FILE_NOTIFICATION)).notifyActiveFile(null);
                return;
            }
            if (!selectionModel.hasSelection()) {
                ((EditorActiveFileNotifier)project.getMessageBus().syncPublisher(EditorActiveFileNotifier.EDITOR_ACTIVE_FILE_NOTIFICATION)).notifyActiveFile(fileInfo);
                return;
            }
            if (selectionModel.getSelectedText() != null) {
                ((EditorSelectedCodeNotifier)project.getMessageBus().syncPublisher(EditorSelectedCodeNotifier.EDITOR_SELECTED_CODE_NOTIFICATION)).notifySelectedCode(fileInfo);
            } else {
                ((EditorActiveFileNotifier)project.getMessageBus().syncPublisher(EditorActiveFileNotifier.EDITOR_ACTIVE_FILE_NOTIFICATION)).notifyActiveFile(fileInfo);
            }
        });
    }

    public void dispose() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/alibabacloud/intellij/qoder/listener/CosyCurrentFileSelectionListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

