/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.listener;

import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.LanguageWebSocketService;
import com.alibabacloud.intellij.qoder.editor.CosyInlayManager;
import com.alibabacloud.intellij.qoder.editor.inline.InlineEditUtil;
import com.alibabacloud.intellij.qoder.editor.model.CompletionTriggerConfig;
import com.alibabacloud.intellij.qoder.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.qoder.editor.model.InlayTriggerEventEnum;
import com.alibabacloud.intellij.qoder.search.asyn.Debouncer;
import com.alibabacloud.intellij.qoder.search.enums.CompletionTriggerModeEnum;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.PsiUtils;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;

public class CosyDocumentListener
implements BulkAwareDocumentListener {
    private static Logger LOGGER = Logger.getInstance(CosyDocumentListener.class);
    private static final int AUTO_SAVE_DELAY_SEC = 5;
    private static final Set<String> ALLOW_INLINE_EDIT_FORCE_COMMANDS = Set.of("Backspace", "\u9000\u683c");
    private final Debouncer autoSaveDebouncer;
    @NotNull
    private final Editor editor;

    public CosyDocumentListener(@NotNull Editor editor) {
        if (editor == null) {
            CosyDocumentListener.$$$reportNull$$$0(0);
        }
        this.autoSaveDebouncer = new Debouncer();
        this.editor = editor;
    }

    public void documentChangedNonBulk(@NotNull DocumentEvent event) {
        Project project;
        if (event == null) {
            CosyDocumentListener.$$$reportNull$$$0(1);
        }
        if ((project = this.editor.getProject()) == null || project.isDisposed()) {
            return;
        }
        if (!EditorUtil.isSelectedEditor(this.editor)) {
            return;
        }
        if (!CosyInlayManager.getInstance().isAvailable(this.editor)) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if (!EditorUtil.isAvailableLanguage(this.editor)) {
            return;
        }
        this.autoSaveIndex(event, this.editor);
        if (commandProcessor.getCurrentCommandName() != null) {
            return;
        }
        int changeOffset = event.getOffset() + event.getNewLength();
        if (this.editor.getCaretModel().getOffset() == changeOffset) {
            return;
        }
        int offset = event.getOffset() + event.getNewLength();
        if (event.getNewLength() > 0) {
            if (this.isIgnoreChange(event, this.editor, offset)) {
                InlineEditUtil.disposeAllInline(this.editor, InlayDisposeEventEnum.DOCUMENT_CHANGE);
            } else {
                CosyInlayManager.getInstance().editorChanged(CompletionTriggerConfig.defaultConfig(InlayTriggerEventEnum.DOCUMENT_CHANGE), this.editor, changeOffset, CompletionTriggerModeEnum.AUTO);
            }
        }
    }

    private boolean isIgnoreChange(DocumentEvent event, Editor editor, int offset) {
        Document document = event.getDocument();
        if (event.getNewLength() < 1) {
            return true;
        }
        if (!editor.getEditorKind().equals((Object)EditorKind.MAIN_EDITOR) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor) || document.getRangeGuard(offset, offset) != null) {
            document.fireReadOnlyModificationAttempt();
            return true;
        }
        return false;
    }

    private void autoSaveIndex(DocumentEvent event, Editor editor) {
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        if ("".equals(commandProcessor.getCurrentCommandName())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)event.getOldFragment()) && StringUtils.isBlank((CharSequence)event.getNewFragment())) {
            return;
        }
        Project project = editor.getProject();
        Document document = event.getDocument();
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = fileDocumentManager.getFile(document);
        if (virtualFile == null) {
            return;
        }
        if (FileUtil.isIgnoreIndexFile(project, virtualFile)) {
            return;
        }
        this.autoSaveDebouncer.debounce(() -> {
            if (!Cosy.INSTANCE.checkCosy(project, false)) {
                return;
            }
            if (!fileDocumentManager.isDocumentUnsaved(document)) {
                LOGGER.debug("Document is not modified, skip auto save", new Object[]{virtualFile.getName()});
                return;
            }
            if (PsiUtils.hasErrors(project, document)) {
                LOGGER.debug("File has errors, skip indexing", new Object[]{virtualFile.getName()});
                return;
            }
            ThreadUtil.executeIndex(() -> {
                LOGGER.debug("Change file:" + virtualFile.getPresentableUrl());
                DidSaveTextDocumentParams params = new DidSaveTextDocumentParams();
                TextDocumentIdentifier textDocument = new TextDocumentIdentifier(virtualFile.getPresentableUrl());
                params.setTextDocument(textDocument);
                params.setText(document.getText());
                LanguageWebSocketService service = Cosy.INSTANCE.getLanguageService(project);
                if (service != null) {
                    service.getServer().getTextDocumentService().didSave(params);
                }
            });
        }, 5L, TimeUnit.SECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/qoder/listener/CosyDocumentListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "documentChangedNonBulk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

