/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.listener;

import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.editor.inline.InlineEditUtil;
import com.alibabacloud.intellij.qoder.editor.model.InlayDisposeEventEnum;
import com.alibabacloud.intellij.qoder.listener.CosyCurrentFileSelectionListener;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.ui.search.model.ActiveFileInfo;
import com.alibabacloud.intellij.qoder.ui.search.topic.EditorActiveFileNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.EditorSelectedCodeNotifier;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.diff.editor.DiffFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.jetbrains.annotations.NotNull;

public class CosyEditorManagerListener
implements FileEditorManagerListener {
    private static Logger logger = Logger.getInstance(CosyEditorManagerListener.class);
    Project project;

    public CosyEditorManagerListener(Project project) {
        this.project = project;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            CosyEditorManagerListener.$$$reportNull$$$0(0);
        }
        if (event.getNewFile() != null) {
            if (null != event.getNewFile().getUserData(CosyCurrentFileSelectionListener.KEY_TEMP_FILE_SHOULD_NOT_QUOTE) && Boolean.TRUE.equals(event.getNewFile().getUserData(CosyCurrentFileSelectionListener.KEY_TEMP_FILE_SHOULD_NOT_QUOTE))) {
                return;
            }
            logger.debug("file selection change: " + event.getNewFile().getPath());
            this.updateIndex(event);
            this.triggerContextCurrentFileTagUpdate(event.getManager().getSelectedTextEditor(), event.getNewFile());
        } else {
            this.triggerContextCurrentFileTagUpdate(null, null);
        }
        VirtualFile oldFile = event.getOldFile();
        if (oldFile == null || !oldFile.isValid()) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(oldFile);
        if (psiFile == null || !psiFile.isValid()) {
            return;
        }
        FileEditor oldEditor = event.getOldEditor();
        if (oldEditor instanceof TextEditor) {
            Editor editor = ((TextEditor)oldEditor).getEditor();
            InlineEditUtil.disposeAllInline(editor, InlayDisposeEventEnum.FILE_ACTIVE_CHANGE_ACTION);
        }
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            CosyEditorManagerListener.$$$reportNull$$$0(1);
        }
        if (file == null) {
            CosyEditorManagerListener.$$$reportNull$$$0(2);
        }
        Project project = source.getProject();
        TelemetryService.getInstance().clearTypeCommandRecord();
        if (Cosy.INSTANCE.checkCosy(project, false)) {
            ThreadUtil.executeIndex(() -> {
                logger.debug("file open " + file.getPath());
                this.openFile(file);
            });
        }
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            CosyEditorManagerListener.$$$reportNull$$$0(3);
        }
        if (file == null) {
            CosyEditorManagerListener.$$$reportNull$$$0(4);
        }
        if (FileUtil.isIgnoreIndexFile(this.project, file)) {
            logger.debug("ignore close index file:" + file.getPath());
            return;
        }
        logger.debug("file close " + file.getPath());
        Project project = source.getProject();
        if (Cosy.INSTANCE.checkCosy(project, false)) {
            ThreadUtil.executeIndex(() -> {
                TextDocumentIdentifier item = new TextDocumentIdentifier();
                item.setUri(file.getPresentableUrl());
                DidCloseTextDocumentParams params = new DidCloseTextDocumentParams(item);
                Cosy.INSTANCE.getLanguageService(project).getServer().getTextDocumentService().didClose(params);
            });
        }
    }

    private void updateIndex(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            CosyEditorManagerListener.$$$reportNull$$$0(5);
        }
        Project project = event.getManager().getProject();
        VirtualFile newFile = event.getNewFile();
        if (Cosy.INSTANCE.checkCosy(project)) {
            ThreadUtil.executeIndex(() -> this.openFile(newFile));
        }
    }

    private void triggerContextCurrentFileTagUpdate(Editor editor, VirtualFile file) {
        if (editor != null && file != null && FileUtil.isValidProjectFile(editor.getProject(), file).booleanValue()) {
            ActiveFileInfo activeFileInfo = ActiveFileInfo.getFromEditor(editor);
            if (activeFileInfo.getStatLine() != null) {
                ((EditorSelectedCodeNotifier)this.project.getMessageBus().syncPublisher(EditorSelectedCodeNotifier.EDITOR_SELECTED_CODE_NOTIFICATION)).notifySelectedCode(activeFileInfo);
            } else {
                ((EditorActiveFileNotifier)this.project.getMessageBus().syncPublisher(EditorActiveFileNotifier.EDITOR_ACTIVE_FILE_NOTIFICATION)).notifyActiveFile(activeFileInfo);
            }
        } else if (file != null && file.getFileType() instanceof DiffFileType) {
            logger.info("triggerContextCurrentFileTagUpdate ignore diff file");
        } else {
            ((EditorActiveFileNotifier)this.project.getMessageBus().syncPublisher(EditorActiveFileNotifier.EDITOR_ACTIVE_FILE_NOTIFICATION)).notifyActiveFile(null);
        }
    }

    private void openFile(VirtualFile file) {
        if (FileUtil.isIgnoreIndexFile(this.project, file)) {
            logger.debug("ignore open index file:" + file.getPath());
            return;
        }
        TextDocumentItem item = new TextDocumentItem();
        item.setUri(file.getPresentableUrl());
        item.setLanguageId(file.getExtension());
        try {
            item.setText(IOUtils.toString((InputStream)file.getInputStream(), (String)"UTF-8"));
            DidOpenTextDocumentParams params = new DidOpenTextDocumentParams(item);
            Cosy.INSTANCE.getLanguageService(this.project).getServer().getTextDocumentService().didOpen(params);
        }
        catch (Exception e) {
            logger.warn("fail to read file " + file.getPath());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/qoder/listener/CosyEditorManagerListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpened";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fileClosed";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

