/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.listener;

import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.util.DatabaseUtil;
import com.alibabacloud.intellij.qoder.util.ProjectUtils;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public class DatabaseChangeListener {
    private static final Logger log = Logger.getInstance(DatabaseChangeListener.class);
    private Project project;

    public DatabaseChangeListener(Project project) {
        this.project = project;
    }

    public void onChanged(Object dataSource) {
        ThreadUtil.execute(() -> {
            if (!Cosy.INSTANCE.checkAndWaitCosyState(null, this.project, TimeUnit.SECONDS.toMillis(10L))) {
                log.warn("database change listener is not available when cosy is invalid");
                return;
            }
            try {
                List<DatabaseUtil.DBTable> tables = DatabaseUtil.getDataSourceTables(dataSource);
                if (tables != null && !tables.isEmpty()) {
                    for (DatabaseUtil.DBTable table : tables) {
                        String tableName = table.getName();
                        if (table.isSystemTable() || table.isTemporary()) {
                            log.debug("skip system table:" + tableName);
                            continue;
                        }
                        log.info("change table:" + tableName + " cate:" + table.getCatalogName() + " schema:" + table.getSchemaName());
                        String ddl = DatabaseUtil.generateDDL(dataSource, table);
                        this.sendSql(tableName, ddl);
                    }
                } else {
                    log.warn("cannot found changed database tables");
                }
            }
            catch (Throwable e) {
                log.warn("database change listener error", e);
            }
        });
    }

    private void sendSql(String tableName, String sql) {
        ThreadUtil.executeIndex(() -> {
            log.debug("save sql change:" + sql);
            File file = new File(ProjectUtils.getProjectBaseDir(this.project), tableName + ".sql");
            DidSaveTextDocumentParams params = new DidSaveTextDocumentParams();
            TextDocumentIdentifier textDocument = new TextDocumentIdentifier(file.getAbsolutePath());
            params.setTextDocument(textDocument);
            params.setText(sql);
            Cosy.INSTANCE.getLanguageService(this.project).getServer().getTextDocumentService().didSave(params);
        });
    }
}

