/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.listener;

import com.alibabacloud.intellij.qoder.core.lsp.model.params.WillChangeTextDocumentParams;
import com.alibabacloud.intellij.qoder.service.FileChangeService;
import com.alibabacloud.intellij.qoder.util.DocumentUtils;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class FileChangeWatchListener
implements BulkAwareDocumentListener,
Disposable {
    private static final Logger LOGGER = Logger.getInstance(FileChangeWatchListener.class);

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Document document;
        Editor editor;
        if (event == null) {
            FileChangeWatchListener.$$$reportNull$$$0(0);
        }
        if ((editor = EditorUtil.getActiveEditor(document = event.getDocument())) == null || editor.getProject() == null) {
            return;
        }
        int lineNumber = document.getLineNumber(event.getOffset());
        LOGGER.debug("beforeDocumentChange getOldFragment:" + event.getOldFragment() + " getNewFragment:" + event.getNewFragment() + " getOffset:" + event.getOffset() + "lineNumber:" + lineNumber);
        String filePath = Optional.ofNullable(FileDocumentManager.getInstance().getFile(document)).map(VirtualFile::getPath).orElse("");
        int outOfRangeLine = 3;
        String oldFragStr = event.getOldFragment().toString();
        String newFragStr = event.getNewFragment().toString();
        long deleteLines = StringUtils.countMatches((CharSequence)oldFragStr, (CharSequence)"\n");
        long insertLines = StringUtils.countMatches((CharSequence)newFragStr, (CharSequence)"\n");
        int fromLine = Math.max(0, lineNumber - outOfRangeLine);
        int lineStartOffset = document.getLineStartOffset(fromLine);
        String selectedText = DocumentUtils.getDocumentLines(document, fromLine, (int)((long)lineNumber + deleteLines + (long)outOfRangeLine));
        int originEndLine = lineNumber + (int)insertLines;
        int endLine = lineNumber + (int)insertLines + outOfRangeLine;
        WillChangeTextDocumentParams params = new WillChangeTextDocumentParams();
        params.setFilePath(filePath);
        params.setOriginalFragment(selectedText);
        params.setOriginalStartLine(fromLine);
        params.setOriginalEndLine(endLine);
        params.setOriginalStartOffset(lineStartOffset);
        params.setOriginalEndOffset(lineStartOffset + selectedText.length());
        params.setEvents(Collections.singletonList(WillChangeTextDocumentParams.FileChangeEvent.builder().oldFragment(oldFragStr).newFragment(newFragStr).startLine(lineNumber).endLine(originEndLine).startOffset(event.getOffset()).endOffset(event.getOffset() + newFragStr.length()).build()));
        FileChangeService fileChangeService = (FileChangeService)editor.getProject().getService(FileChangeService.class);
        if (fileChangeService != null) {
            fileChangeService.addFileChangeEvent(params);
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/alibabacloud/intellij/qoder/listener/FileChangeWatchListener", "beforeDocumentChange"));
    }
}

