/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.listener.model;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.TextRange;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class CommandEditorState {
    private final long modificationStamp;
    private final VisualPosition visualPosition;
    private final String lineSuffix;
    private final String linePrefix;
    private final String selectionText;
    private final int offset;

    public CommandEditorState(long modificationStamp, VisualPosition visualPosition, String linePrefix, String lineSuffix, String selectionText, int offset) {
        this.modificationStamp = modificationStamp;
        this.visualPosition = visualPosition;
        this.linePrefix = linePrefix;
        this.lineSuffix = lineSuffix;
        this.selectionText = selectionText;
        this.offset = offset;
    }

    public String getCaretPrevChar() {
        if (this.linePrefix != null && !this.linePrefix.isEmpty()) {
            return this.linePrefix.substring(this.linePrefix.length() - 1);
        }
        return null;
    }

    public String getCaretNextChar() {
        if (this.lineSuffix != null && !this.lineSuffix.isEmpty()) {
            return this.lineSuffix.substring(0, 1);
        }
        return null;
    }

    @NotNull
    public static CommandEditorState createCommandState(@NotNull Editor editor) {
        if (editor == null) {
            CommandEditorState.$$$reportNull$$$0(0);
        }
        int offset = editor.getCaretModel().getOffset();
        int line = editor.getDocument().getLineNumber(offset);
        int lineStartOffset = editor.getDocument().getLineStartOffset(line);
        int lineEndOffset = editor.getDocument().getLineEndOffset(line);
        String linePrefix = editor.getDocument().getText(new TextRange(lineStartOffset, offset));
        String lineSuffix = editor.getDocument().getText(new TextRange(offset, lineEndOffset));
        return new CommandEditorState(CommandEditorState.getDocumentStamp(editor.getDocument()), editor.getCaretModel().getVisualPosition(), linePrefix, lineSuffix, editor.getSelectionModel().getSelectedText(), editor.getCaretModel().getOffset());
    }

    private static long getDocumentStamp(@NotNull Document document) {
        if (document == null) {
            CommandEditorState.$$$reportNull$$$0(1);
        }
        if (document instanceof DocumentEx) {
            return ((DocumentEx)document).getModificationSequence();
        }
        return document.getModificationStamp();
    }

    @Generated
    public long getModificationStamp() {
        return this.modificationStamp;
    }

    @Generated
    public VisualPosition getVisualPosition() {
        return this.visualPosition;
    }

    @Generated
    public String getLineSuffix() {
        return this.lineSuffix;
    }

    @Generated
    public String getLinePrefix() {
        return this.linePrefix;
    }

    @Generated
    public String getSelectionText() {
        return this.selectionText;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandEditorState)) {
            return false;
        }
        CommandEditorState other = (CommandEditorState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getModificationStamp() != other.getModificationStamp()) {
            return false;
        }
        VisualPosition this$visualPosition = this.getVisualPosition();
        VisualPosition other$visualPosition = other.getVisualPosition();
        if (this$visualPosition == null ? other$visualPosition != null : !this$visualPosition.equals(other$visualPosition)) {
            return false;
        }
        String this$lineSuffix = this.getLineSuffix();
        String other$lineSuffix = other.getLineSuffix();
        if (this$lineSuffix == null ? other$lineSuffix != null : !this$lineSuffix.equals(other$lineSuffix)) {
            return false;
        }
        String this$linePrefix = this.getLinePrefix();
        String other$linePrefix = other.getLinePrefix();
        if (this$linePrefix == null ? other$linePrefix != null : !this$linePrefix.equals(other$linePrefix)) {
            return false;
        }
        String this$selectionText = this.getSelectionText();
        String other$selectionText = other.getSelectionText();
        if (this$selectionText == null ? other$selectionText != null : !this$selectionText.equals(other$selectionText)) {
            return false;
        }
        return this.getOffset() == other.getOffset();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommandEditorState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $modificationStamp = this.getModificationStamp();
        result = result * 59 + (int)($modificationStamp >>> 32 ^ $modificationStamp);
        VisualPosition $visualPosition = this.getVisualPosition();
        result = result * 59 + ($visualPosition == null ? 43 : $visualPosition.hashCode());
        String $lineSuffix = this.getLineSuffix();
        result = result * 59 + ($lineSuffix == null ? 43 : $lineSuffix.hashCode());
        String $linePrefix = this.getLinePrefix();
        result = result * 59 + ($linePrefix == null ? 43 : $linePrefix.hashCode());
        String $selectionText = this.getSelectionText();
        result = result * 59 + ($selectionText == null ? 43 : $selectionText.hashCode());
        result = result * 59 + this.getOffset();
        return result;
    }

    @Generated
    public String toString() {
        return "CommandEditorState(modificationStamp=" + this.getModificationStamp() + ", visualPosition=" + this.getVisualPosition() + ", lineSuffix=" + this.getLineSuffix() + ", linePrefix=" + this.getLinePrefix() + ", selectionText=" + this.getSelectionText() + ", offset=" + this.getOffset() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/alibabacloud/intellij/qoder/listener/model/CommandEditorState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createCommandState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocumentStamp";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

