/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.search.parser;

import com.alibabacloud.intellij.qoder.search.parser.HtmlBlock;
import com.alibabacloud.intellij.qoder.search.parser.HtmlParseContext;
import com.alibabacloud.intellij.qoder.search.parser.HtmlParser;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class UniversalHtmlParser
implements HtmlParser {
    private static final Logger logger = Logger.getInstance(UniversalHtmlParser.class);
    private static final String IMAGE_MAX_WIDTH = "300";
    protected static final Pattern CODE_MATCHER = Pattern.compile("<pre(.*?)><code>(.*?)</code></pre>", 32);

    @Override
    public List<HtmlBlock> parseHtml(HtmlParseContext context, String html) {
        ArrayList<HtmlBlock> result = new ArrayList<HtmlBlock>();
        StringBuilder sb = new StringBuilder();
        Matcher m = CODE_MATCHER.matcher(html);
        while (m.find()) {
            String content = m.group(2);
            HtmlBlock codeBlock = new HtmlBlock(content, "code");
            m.appendReplacement(sb, "");
            HtmlBlock textBlock = new HtmlBlock(sb.toString(), "content");
            result.add(textBlock);
            result.add(codeBlock);
            sb.setLength(0);
        }
        m.appendTail(sb);
        HtmlBlock textBlock = new HtmlBlock(sb.toString(), "content");
        result.add(textBlock);
        result = result.stream().filter(v -> !v.getContent().trim().equals("")).map(v -> this.postBlock(context, (HtmlBlock)v)).collect(Collectors.toList());
        return result;
    }

    private HtmlBlock postBlock(HtmlParseContext context, HtmlBlock block) {
        if ("code".equals(block.getType())) {
            return this.postCodeBlock(context, block);
        }
        if ("content".equals(block.getType())) {
            return this.postTextBlock(context, block);
        }
        return block;
    }

    private HtmlBlock postCodeBlock(HtmlParseContext context, HtmlBlock block) {
        String html = StringEscapeUtils.unescapeHtml4((String)block.getContent());
        block.setContent(html);
        return block;
    }

    private HtmlBlock postTextBlock(HtmlParseContext context, HtmlBlock block) {
        try {
            Document doc = Jsoup.parse((String)block.getContent());
            this.postImageTag(doc);
            this.postCodeTag(context, doc);
            String html = doc.body().html();
            block.setContent(html);
        }
        catch (Exception e) {
            logger.error("fail to parse html. Cause " + e.getMessage(), (Throwable)e);
        }
        return block;
    }

    private void postImageTag(Document doc) {
        try {
            Elements elements = doc.select("img");
            for (Element element : elements) {
                String width = element.attr("width");
                if (StringUtils.isBlank((CharSequence)width)) {
                    element.attr("width", IMAGE_MAX_WIDTH);
                }
                element.before("<br/>");
                element.after("<br/>");
            }
        }
        catch (Exception e) {
            logger.error("fail to process image tag. Cause " + e.getMessage(), (Throwable)e);
        }
    }

    private void postCodeTag(HtmlParseContext context, Document doc) {
        try {
            Elements elements = doc.select("code");
            for (Element element : elements) {
                if (context.getSchemeColor() == null) {
                    element.attr("style", "background-color: #2B2B2B;");
                    continue;
                }
                element.attr("style", "background-color: #e3e6e8;");
            }
        }
        catch (Exception e) {
            logger.error("fail to process code tag. Cause " + e.getMessage(), (Throwable)e);
        }
    }
}

