/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.search.psistrategy;

import com.alibabacloud.intellij.qoder.search.psistrategy.PsiStrategy;
import com.alibabacloud.intellij.qoder.search.psistrategy.impl.PsiClassStrategy;
import com.alibabacloud.intellij.qoder.search.psistrategy.impl.PsiMethodStrategy;
import com.alibabacloud.intellij.qoder.search.psistrategy.impl.PsiVariableStrategy;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import java.util.HashMap;
import java.util.Map;

public class PsiStrategyFactory {
    private static PsiStrategyFactory psiStrategyFactory = new PsiStrategyFactory();
    private static Map<String, PsiStrategy> psiStrategyMap = new HashMap<String, PsiStrategy>();

    private PsiStrategyFactory() {
    }

    public static PsiStrategyFactory getInstance() {
        return psiStrategyFactory;
    }

    public PsiStrategy getFactoryByClass(PsiElement psiElement) {
        if (psiElement instanceof PsiVariable) {
            return psiStrategyMap.get(PsiVariable.class.getName());
        }
        if (psiElement instanceof PsiClass) {
            return psiStrategyMap.get(PsiClass.class.getName());
        }
        if (psiElement instanceof PsiMethod) {
            return psiStrategyMap.get(PsiMethod.class.getName());
        }
        return null;
    }

    static {
        psiStrategyMap.put(PsiVariable.class.getName(), new PsiVariableStrategy());
        psiStrategyMap.put(PsiClass.class.getName(), new PsiClassStrategy());
        psiStrategyMap.put(PsiMethod.class.getName(), new PsiMethodStrategy());
    }
}

