/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.search.util;

import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.search.ui.WrapTabbedPaneUI;
import com.alibabacloud.intellij.qoder.ui.search.CosyLoadingPanel;
import com.alibabacloud.intellij.qoder.ui.search.PromptCell;
import com.alibabacloud.intellij.qoder.ui.search.QoderToolWindowPanel;
import com.alibabacloud.intellij.qoder.ui.search.SearchMainPanel;
import com.alibabacloud.intellij.qoder.ui.search.SearchResultPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.CodeTextPane;
import com.alibabacloud.intellij.qoder.ui.search.component.RefreshColorComponent;
import com.alibabacloud.intellij.qoder.ui.search.component.SystemMessageCard;
import com.alibabacloud.intellij.qoder.ui.search.component.inputfield.SearchBar;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.MarkdownStreamPanel;
import com.alibabacloud.intellij.qoder.ui.search.form.CosyEmptyForm;
import com.alibabacloud.intellij.qoder.util.ProjectUtils;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TabbedPaneUI;

public class BackgroundAdaptUtil {
    private static final Logger log = Logger.getInstance(BackgroundAdaptUtil.class);

    public static void monitorPanelBackgroundColor(final JComponent panel) {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                Color color = null;
                if (scheme != null) {
                    color = scheme.getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
                }
                Color finalColor = color;
                SwingUtil.foreachChildComponent(panel, cp -> {
                    if (cp instanceof RefreshColorComponent) {
                        ((RefreshColorComponent)((Object)cp)).refreshColor(scheme, finalColor);
                    }
                });
            }
        });
    }

    public static void monitorMarkdownPaneColor(final JComponent panel) {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                Color color = null;
                if (scheme != null) {
                    color = scheme.getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
                }
                Color finalColor = color;
                SwingUtil.foreachChildComponent(panel, cp -> {
                    if (cp instanceof CodeTextPane || cp instanceof MarkdownStreamPanel || cp instanceof SystemMessageCard) {
                        ((RefreshColorComponent)((Object)cp)).refreshColor(scheme, finalColor);
                    }
                });
            }
        });
    }

    public static void monitorBackgroundColor(final SearchMainPanel searchMainPanel) {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                Color color = null;
                if (scheme != null) {
                    color = scheme.getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
                }
                if (color == null) {
                    BackgroundAdaptUtil.darkIconUpdate(searchMainPanel);
                } else {
                    BackgroundAdaptUtil.lightIconUpdate(searchMainPanel);
                }
                SearchBar searchField = searchMainPanel.getSearchField();
                searchField.forceUpdateThemeColor(scheme);
                searchMainPanel.setCosyLoadingPanel(new CosyLoadingPanel());
                searchMainPanel.setPromptCell(new PromptCell(searchMainPanel.getProject()));
                SearchResultPanel searchResultPanel = searchMainPanel.getSearchResultPanel();
                searchResultPanel.getBasePanel().setBackground(searchMainPanel.getContent().getBackground());
                SwingUtilities.updateComponentTreeUI(searchResultPanel.getBasePanel());
                searchResultPanel.getContentTabPane().setUI((TabbedPaneUI)((Object)new WrapTabbedPaneUI()));
                searchMainPanel.getChooserBuilder().getChooserComponent().setBackground(searchMainPanel.getContent().getBackground());
                searchMainPanel.getChooserBuilder().getChooserComponent().updateUI();
                searchMainPanel.setCodeEmptyComponent(new CosyEmptyForm(searchMainPanel.getProject()).getComponent());
                searchMainPanel.setQaEmptyComponent(new CosyEmptyForm(searchMainPanel.getProject()).getComponent());
            }
        });
    }

    public static void monitorUserInfoPanelBackgroundColor() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(LafManagerListener.TOPIC, lafManager -> {
            Project project = ProjectUtils.getActiveProject();
            if (project == null) {
                return;
            }
            if (Cosy.INSTANCE.getLanguageService(project) != null) {
                Cosy.INSTANCE.getLanguageService(project).updateProfile(QoderToolWindowPanel.getGetProfileUrlParams(null, false));
            }
        });
    }

    public static void darkIconUpdate(SearchMainPanel searchMainPanel) {
        SearchBar searchBar = searchMainPanel.getSearchField();
        searchBar.setIcon(CommonIcons.lightSearchIcon, CommonIcons.lightCloseFillIcon);
    }

    public static void lightIconUpdate(SearchMainPanel searchMainPanel) {
        SearchBar searchBar = searchMainPanel.getSearchField();
        searchBar.setIcon(CommonIcons.searchIcon, CommonIcons.closeFillIcon);
    }
}

