/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.search.util;

import com.alibabacloud.intellij.qoder.core.lsp.model.model.ApiCompletionSuggest;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.CodeDocContentDetail;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.CodeDocOverviewDetail;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.CodeSnippetDetail;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.NlpCompletionSuggest;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.RecommendResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.Recommendation;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.SnippetApi;
import com.alibabacloud.intellij.qoder.search.enums.SearchValueTypeEnum;
import com.alibabacloud.intellij.qoder.search.result.SearchCodeResult;
import com.alibabacloud.intellij.qoder.search.result.SearchValue;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CosyServiceUtil {
    private static Logger logger = Logger.getInstance(CosyServiceUtil.class);

    public static List<SearchCodeResult> parseSearchCode(RecommendResult recommendResult, Set<SearchValue> searchValueList) {
        ArrayList<SearchCodeResult> searchCodeResults = new ArrayList<SearchCodeResult>();
        if (recommendResult == null || CollectionUtils.isEmpty(recommendResult.getRecommendations())) {
            return Collections.emptyList();
        }
        ArrayList<String> highlightWords = new ArrayList<String>();
        if (searchValueList != null) {
            for (SearchValue searchValue : searchValueList) {
                highlightWords.add(searchValue.getNiceName());
            }
        }
        List<Recommendation> recommendations = recommendResult.getRecommendations();
        for (Recommendation recommendation : recommendations) {
            Object fileUrl;
            String repoName;
            CodeSnippetDetail codeSnippetDetail = recommendation.getItem().getCodeSnippetDetail();
            String url = codeSnippetDetail.getUrl().replace("\\", "/");
            String docTitle = codeSnippetDetail.getDocTitle().replace("\\", "/");
            String snippetCode = codeSnippetDetail.getSnippet();
            String license = codeSnippetDetail.getLicense();
            int likeCount = codeSnippetDetail.getLikes();
            String source = codeSnippetDetail.getSource();
            List<SnippetApi> apiList = codeSnippetDetail.getApiList();
            if ("StackOverflow".equalsIgnoreCase(source)) {
                repoName = codeSnippetDetail.getDocTitle();
                fileUrl = url;
            } else {
                repoName = url.replace("https://github.com/", "").replace(".git", "");
                fileUrl = url.replace(".git", "") + "/blob/master" + docTitle.substring(docTitle.indexOf("/"));
            }
            SearchCodeResult searchCodeResult = new SearchCodeResult((String)fileUrl, repoName, snippetCode, license, likeCount, source, highlightWords);
            if (CollectionUtils.isNotEmpty(apiList)) {
                searchCodeResult.setApiList(apiList);
            }
            searchCodeResults.add(searchCodeResult);
        }
        return searchCodeResults;
    }

    public static List<CodeDocOverviewDetail> parseQAList(String query, RecommendResult recommendResult, Set<SearchValue> searchValueList) {
        if (recommendResult == null || CollectionUtils.isEmpty(recommendResult.getRecommendations())) {
            return Collections.emptyList();
        }
        ArrayList<String> highlightWords = new ArrayList<String>();
        if (searchValueList != null) {
            for (SearchValue searchValue : searchValueList) {
                highlightWords.add(searchValue.getNiceName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            String regularQuery = query.replaceAll("[\\s\\?\\,]+", " ").toLowerCase(Locale.ROOT);
            highlightWords.addAll(Arrays.asList(regularQuery.split(" ")));
        }
        ArrayList<CodeDocOverviewDetail> codeDocOverviewDetailList = new ArrayList<CodeDocOverviewDetail>();
        List<Recommendation> recommendations = recommendResult.getRecommendations();
        for (Recommendation recommendation : recommendations) {
            CodeDocOverviewDetail codeDocOverviewDetail = recommendation.getItem().getCodeDocOverviewDetail();
            codeDocOverviewDetail.setHighlightWords(highlightWords);
            codeDocOverviewDetailList.add(codeDocOverviewDetail);
        }
        return codeDocOverviewDetailList;
    }

    public static List<CodeDocContentDetail> parseQAContent(RecommendResult recommendResult) {
        if (recommendResult == null || CollectionUtils.isEmpty(recommendResult.getRecommendations())) {
            return Collections.emptyList();
        }
        ArrayList<CodeDocContentDetail> codeDocOverviewDetailList = new ArrayList<CodeDocContentDetail>();
        if (recommendResult.getRecommendations() != null) {
            List<Recommendation> recommendations = recommendResult.getRecommendations();
            for (Recommendation recommendation : recommendations) {
                codeDocOverviewDetailList.add(recommendation.getItem().getCodeDocContentDetail());
            }
        }
        return codeDocOverviewDetailList;
    }

    public static List<SearchValue> parseSuggestResult(RecommendResult recommendResult, String searchText) {
        ArrayList<SearchValue> searchCodeResults = new ArrayList<SearchValue>();
        SearchValue defaultSearchValue = new SearchValue(null, searchText, SearchValueTypeEnum.NLP.getType());
        searchCodeResults.add(defaultSearchValue);
        if (recommendResult == null || CollectionUtils.isEmpty(recommendResult.getRecommendations())) {
            return searchCodeResults;
        }
        List<Recommendation> recommendations = recommendResult.getRecommendations();
        for (Recommendation recommendation : recommendations) {
            SearchValue searchValue = new SearchValue();
            ApiCompletionSuggest apiCompletionSuggest = recommendation.getItem().getApiCompletionSuggest();
            NlpCompletionSuggest nlpCompletionSuggest = recommendation.getItem().getNlpCompletionSuggest();
            if (apiCompletionSuggest != null && StringUtils.isNotBlank((CharSequence)apiCompletionSuggest.getTokenName())) {
                searchValue.setType(apiCompletionSuggest.getTokenType());
                searchValue.setNiceName(apiCompletionSuggest.getTokenName());
                searchValue.setPack(apiCompletionSuggest.getFullPath());
            } else if (nlpCompletionSuggest != null && StringUtils.isNotBlank((CharSequence)nlpCompletionSuggest.getTitle())) {
                searchValue.setNiceName(nlpCompletionSuggest.getTitle());
                searchValue.setType(SearchValueTypeEnum.NLP.getType());
            } else {
                logger.debug("Parse suggest result failed, no codeCompletionSuggest or queryCompletionSuggest found");
                continue;
            }
            if (searchValue.equals(defaultSearchValue)) continue;
            searchCodeResults.add(searchValue);
        }
        return searchCodeResults;
    }
}

