/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.search.util;

import com.alibabacloud.intellij.qoder.util.DownloadUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

public class WelcomePanelUtil {
    private static final Logger log = Logger.getInstance(WelcomePanelUtil.class);

    public static String fetchWelcomeText() {
        String welcomeText = "";
        String resourceFilePath = "/search/default-light-cosy-search-default-panel-text.html";
        File localFile = null;
        try {
            localFile = DownloadUtils.LIGHT_SEARCH_PANEL_WELCOME_TEXT_LOCAL.toFile();
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
            if (color == null) {
                localFile = DownloadUtils.DARK_SEARCH_PANEL_WELCOME_TEXT_LOCAL.toFile();
                resourceFilePath = "/search/default-dark-cosy-search-default-panel-text.html";
            }
        }
        catch (Exception e) {
            log.error(String.format("Fetch welcome text get file error: e", e.getMessage()));
        }
        try {
            welcomeText = localFile != null && localFile.exists() ? FileUtils.readFileToString((File)localFile, (Charset)StandardCharsets.UTF_8) : new String(WelcomePanelUtil.class.getResourceAsStream(resourceFilePath).readAllBytes());
        }
        catch (IOException e) {
            log.warn("Cannot read welcome text from local file");
        }
        return welcomeText;
    }
}

