/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.service;

import com.alibabacloud.intellij.qoder.common.BuildFeature;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatModeItem;
import com.alibabacloud.intellij.qoder.service.model.Features;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatMode;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ModeService {
    private static final ChatModeItem MODE_CHAT = new ChatModeItem(ChatMode.CHAT.getMode());
    private static final ChatModeItem MODE_AGENT = new ChatModeItem(ChatMode.AGENT.getMode());
    private static final List<ChatModeItem> MODES = Arrays.asList(MODE_CHAT, MODE_AGENT);
    private static final ModeService instance = new ModeService();

    private ModeService() {
    }

    public List<ChatModeItem> getModeList() {
        return MODES;
    }

    @NotNull
    public ChatModeItem getSelectionModeItem(Project project) {
        String mode;
        ChatModeItem selectModel = null;
        CosySetting cosySetting = CosyPersistentSetting.getInstance().getState();
        if (cosySetting != null && null != project && StringUtils.isNotEmpty((CharSequence)(mode = cosySetting.getChatModeSelected().get(project.getPresentableUrl()))) && !mode.equals(ChatMode.EDIT.getMode())) {
            selectModel = new ChatModeItem(mode);
        }
        ChatModeItem chatModeItem = selectModel == null ? new ChatModeItem(Features.COMMON_CHAT_DEFAULT_MODE.stringValue()) : selectModel;
        if (chatModeItem == null) {
            ModeService.$$$reportNull$$$0(0);
        }
        return chatModeItem;
    }

    public String getModeForTelemetry(Project project) {
        return CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false) ? "null" : this.getSelectionModeItem(project).getMode();
    }

    @Generated
    public static ModeService getInstance() {
        return instance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/alibabacloud/intellij/qoder/service/ModeService", "getSelectionModeItem"));
    }
}

