/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.service.handler;

import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.ui.search.component.markdown.CodeMarkdownHighlightComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

public class ChatAskApplyDiffHandler {
    private static final Logger logger = Logger.getInstance(ChatAskApplyDiffHandler.class);
    private static final int CACHE_ASK_APPLIED_DIFF_RENDERER_LIMIT = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChatAskApplyDiffHandler(Project project, String applyFilePath, CodeMarkdownHighlightComponent codeMarkdownHighlightComponent) {
        if (project == null || StringUtils.isEmpty((CharSequence)applyFilePath) || codeMarkdownHighlightComponent == null) {
            return;
        }
        try {
            Key<LinkedHashMap<String, CodeMarkdownHighlightComponent>> key = CosyCacheKeys.KEY_LAST_ASK_APPLY_COMPONENT;
            synchronized (key) {
                CodeMarkdownHighlightComponent toRemove;
                LinkedHashMap fileDiffRenderers = (LinkedHashMap)CosyCacheKeys.KEY_LAST_ASK_APPLY_COMPONENT.get((UserDataHolder)project, new LinkedHashMap());
                if (fileDiffRenderers.get(applyFilePath) != null) {
                    CodeMarkdownHighlightComponent exist = (CodeMarkdownHighlightComponent)fileDiffRenderers.get(applyFilePath);
                    if (exist != null) {
                        if (exist.equals(codeMarkdownHighlightComponent)) {
                            fileDiffRenderers.remove(applyFilePath);
                        } else {
                            CodeMarkdownHighlightComponent toRemove2 = (CodeMarkdownHighlightComponent)fileDiffRenderers.remove(applyFilePath);
                            if (toRemove2 != null) {
                                toRemove2.stopApplyOrDisposeDiffRenderer();
                            }
                        }
                    } else {
                        fileDiffRenderers.remove(applyFilePath);
                    }
                } else if (fileDiffRenderers.size() >= 5 && (toRemove = (CodeMarkdownHighlightComponent)fileDiffRenderers.remove(fileDiffRenderers.keySet().iterator().next())) != null) {
                    toRemove.stopApplyOrDisposeDiffRenderer();
                }
                fileDiffRenderers.put(applyFilePath, codeMarkdownHighlightComponent);
                CosyCacheKeys.KEY_LAST_ASK_APPLY_COMPONENT.set((UserDataHolder)project, (Object)fileDiffRenderers);
            }
        }
        catch (Exception e) {
            logger.warn("ChatAskApplyDiffHandler error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeAll(Project project) {
        if (project == null) {
            return;
        }
        Key<LinkedHashMap<String, CodeMarkdownHighlightComponent>> key = CosyCacheKeys.KEY_LAST_ASK_APPLY_COMPONENT;
        synchronized (key) {
            LinkedHashMap fileDiffHandlers = (LinkedHashMap)CosyCacheKeys.KEY_LAST_ASK_APPLY_COMPONENT.get((UserDataHolder)project, new LinkedHashMap());
            if (fileDiffHandlers.isEmpty()) {
                return;
            }
            fileDiffHandlers.values().forEach(item -> {
                if (item != null) {
                    item.stopApplyOrDisposeDiffRenderer();
                }
            });
            CosyCacheKeys.KEY_LAST_ASK_APPLY_COMPONENT.set((UserDataHolder)project, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFilePathFromCache(Project project, String applyFilePath) {
        if (project == null || StringUtils.isEmpty((CharSequence)applyFilePath)) {
            return;
        }
        Key<LinkedHashMap<String, CodeMarkdownHighlightComponent>> key = CosyCacheKeys.KEY_LAST_ASK_APPLY_COMPONENT;
        synchronized (key) {
            LinkedHashMap fileDiffHandlers = (LinkedHashMap)CosyCacheKeys.KEY_LAST_ASK_APPLY_COMPONENT.get((UserDataHolder)project, new LinkedHashMap());
            if (fileDiffHandlers.isEmpty()) {
                return;
            }
            fileDiffHandlers.remove(applyFilePath);
        }
    }
}

