/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.service.handler;

import com.alibabacloud.intellij.qoder.service.handler.MergeFileHandler;
import com.alibabacloud.intellij.qoder.util.Md5Util;
import com.alibabacloud.intellij.qoder.util.PsiUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;

public class JavaMergeFileHandler
extends MergeFileHandler {
    /*
     * WARNING - void declaration
     */
    @Override
    public String merge(Project project, PsiFile oldFile, PsiFile newFile) {
        PsiJavaFile oldPsiJavaFile = null;
        PsiJavaFile newPsiJavaFile = null;
        if (oldFile instanceof PsiJavaFile && newFile instanceof PsiJavaFile) {
            oldPsiJavaFile = (PsiJavaFile)oldFile;
            newPsiJavaFile = (PsiJavaFile)newFile;
        }
        if (null == oldPsiJavaFile) {
            return null;
        }
        PsiElement[] oldPsiElements = oldPsiJavaFile.getChildren();
        ArrayList<String> importList = new ArrayList<String>();
        ArrayList<String> fieldList = new ArrayList<String>();
        ArrayList<String> methodContentMD5s = new ArrayList<String>();
        for (PsiElement oldPsiElement : oldPsiElements) {
            int n;
            PsiImportStatement[] importStatements;
            if (oldPsiElement instanceof PsiImportList) {
                void var18_25;
                PsiImportList psiImportList = (PsiImportList)oldPsiElement;
                PsiImportStatement[] psiImportStatementArray = importStatements = psiImportList.getImportStatements();
                n = psiImportStatementArray.length;
                boolean i = false;
                while (var18_25 < n) {
                    PsiImportStatement importStatement = psiImportStatementArray[var18_25];
                    importList.add(importStatement.getQualifiedName());
                    ++var18_25;
                }
                continue;
            }
            if (oldPsiElement instanceof PsiField) {
                PsiField psiField = (PsiField)oldPsiElement;
                fieldList.add(String.format("%s-%s", psiField.getType().getPresentableText(), psiField.getName()));
                continue;
            }
            if (!(oldPsiElement instanceof PsiClass)) continue;
            PsiClass psiClass = (PsiClass)oldPsiElement;
            importStatements = psiClass.getChildren();
            int n2 = importStatements.length;
            for (n = 0; n < n2; ++n) {
                PsiImportStatement psiImportStatement = importStatements[n];
                if (!(psiImportStatement instanceof PsiMethod)) continue;
                PsiMethod psiMethod = (PsiMethod)psiImportStatement;
                methodContentMD5s.add(Md5Util.encode(psiMethod.getText().trim().getBytes()));
            }
        }
        ArrayList<PsiImportStatement> importListToAdd = new ArrayList<PsiImportStatement>();
        ArrayList<PsiField> fieldListToAdd = new ArrayList<PsiField>();
        ArrayList<PsiMethod> methodsToAdd = new ArrayList<PsiMethod>();
        PsiElement[] newPsiElements = newPsiJavaFile.getChildren();
        PsiClass classToAdd = null;
        for (PsiImportStatement psiImportStatement : newPsiElements) {
            PsiClass newPsiClass;
            int n;
            PsiImportStatement[] importStatements;
            if (psiImportStatement instanceof PsiImportList) {
                PsiImportList psiImportList = (PsiImportList)psiImportStatement;
                PsiImportStatement[] psiImportStatementArray = importStatements = psiImportList.getImportStatements();
                n = psiImportStatementArray.length;
                for (int i = 0; i < n; ++i) {
                    PsiImportStatement importStatement = psiImportStatementArray[i];
                    if (importList.contains(importStatement.getQualifiedName())) continue;
                    importListToAdd.add(importStatement);
                }
                continue;
            }
            if (!(psiImportStatement instanceof PsiClass)) continue;
            classToAdd = newPsiClass = (PsiClass)psiImportStatement;
            importStatements = newPsiClass.getChildren();
            int n2 = importStatements.length;
            for (n = 0; n < n2; ++n) {
                PsiField psiField;
                PsiImportStatement classChild = importStatements[n];
                if (classChild instanceof PsiMethod) {
                    PsiMethod psiMethod = (PsiMethod)classChild;
                    if (methodContentMD5s.contains(Md5Util.encode(psiMethod.getText().trim().getBytes()))) continue;
                    methodsToAdd.add(psiMethod);
                    continue;
                }
                if (!(classChild instanceof PsiField) || fieldList.contains(String.format("%s-%s", (psiField = (PsiField)classChild).getType().getPresentableText(), psiField.getName()))) continue;
                fieldListToAdd.add(psiField);
            }
        }
        if (oldPsiElements.length == 0) {
            return newFile.getText();
        }
        PsiElement lastImportStatement = oldPsiElements[0];
        PsiElement lastFieldStatement = null;
        PsiElement lastMethodStatement = null;
        for (PsiElement oldPsiElement : oldPsiElements) {
            if (oldPsiElement instanceof PsiPackageStatement) {
                lastImportStatement = oldPsiElement;
            }
            if (oldPsiElement instanceof PsiImportList) {
                PsiImportList psiImportList = (PsiImportList)oldPsiElement;
                PsiImportStatement[] importStatements = psiImportList.getImportStatements();
                if (importStatements.length <= 0) continue;
                lastImportStatement = importStatements[importStatements.length - 1];
                continue;
            }
            if (!(oldPsiElement instanceof PsiClass)) continue;
            PsiClass psiClass = (PsiClass)oldPsiElement;
            for (PsiElement classChild : psiClass.getChildren()) {
                if (classChild instanceof PsiMethod) {
                    PsiMethod psiMethod = (PsiMethod)classChild;
                    if (lastFieldStatement == null) {
                        lastFieldStatement = PsiUtils.findPrevAtOffset((PsiFile)oldPsiJavaFile, psiMethod.getTextRange().getStartOffset(), PsiWhiteSpace.class);
                    }
                    lastMethodStatement = psiMethod;
                    continue;
                }
                if (!(classChild instanceof PsiField)) continue;
                PsiField psiField = (PsiField)classChild;
                lastFieldStatement = psiField;
                if (lastMethodStatement != null) continue;
                lastMethodStatement = PsiUtils.findNextAtOffset((PsiFile)oldPsiJavaFile, psiField.getTextRange().getEndOffset(), PsiWhiteSpace.class);
            }
        }
        for (PsiImportStatement psiImportStatement : importListToAdd) {
            if (oldPsiJavaFile.getImportList() != null) {
                oldPsiJavaFile.getImportList().add((PsiElement)psiImportStatement);
                continue;
            }
            lastImportStatement = lastImportStatement.add((PsiElement)psiImportStatement);
        }
        PsiClass[] psiClassArray = oldPsiJavaFile.getClasses();
        PsiClass theClass = null;
        if (psiClassArray.length > 0) {
            theClass = psiClassArray[0];
        }
        if (theClass == null) {
            if (classToAdd == null) {
                return oldFile.getText() + "\n" + newFile.getText();
            }
            PsiElement[] children = oldPsiJavaFile.getChildren();
            if (children.length == 0) {
                oldPsiJavaFile.add((PsiElement)classToAdd);
            } else {
                children[children.length - 1].add((PsiElement)classToAdd);
            }
        }
        if (lastMethodStatement != null) {
            for (PsiMethod psiMethod : methodsToAdd) {
                if (theClass != null) {
                    try {
                        theClass.add((PsiElement)psiMethod);
                    }
                    catch (IndexNotReadyException e) {
                        lastMethodStatement = lastMethodStatement.add((PsiElement)psiMethod);
                    }
                    continue;
                }
                lastMethodStatement = lastMethodStatement.add((PsiElement)psiMethod);
            }
        }
        if (lastFieldStatement != null) {
            for (PsiField psiField : fieldListToAdd) {
                if (theClass != null) {
                    try {
                        theClass.add((PsiElement)psiField);
                    }
                    catch (IndexNotReadyException e) {
                        lastFieldStatement = lastFieldStatement.add((PsiElement)psiField);
                    }
                    continue;
                }
                lastFieldStatement = lastFieldStatement.add((PsiElement)psiField);
            }
        }
        return CodeStyleManager.getInstance((Project)project).reformat((PsiElement)oldPsiJavaFile).getText();
    }
}

