/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.service.impl;

import com.alibabacloud.intellij.qoder.common.CosySetting;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ChangeUserSettingParams;
import com.alibabacloud.intellij.qoder.search.asyn.TrackThreadService;
import com.alibabacloud.intellij.qoder.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.qoder.service.ConfigService;
import com.alibabacloud.intellij.qoder.ui.config.CosyPersistentSetting;
import com.alibabacloud.intellij.qoder.ui.search.track.ReportStatistic;
import com.alibabacloud.intellij.qoder.ui.statusbar.CosyStatusBarWidget;
import com.alibabacloud.intellij.qoder.util.ApplicationUtil;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.openapi.project.Project;

public class ConfigServiceImpl
implements ConfigService {
    TrackThreadService trackThreadService = new TrackThreadService();

    @Override
    public void configCloudCompletionSwitch(Project project, boolean enable) {
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null) {
            ChangeUserSettingParams params = setting.getParameter();
            if (enable) {
                params.getCloud().setEnable(enable);
            }
            params.getCloud().getAutoTrigger().setEnable(enable);
            CosyStatusBarWidget.updateStatusBar(null, project);
            if (Cosy.INSTANCE.checkCosy(project)) {
                Cosy.INSTANCE.updateConfig(params);
            }
        }
    }

    @Override
    public void configLocalCompletionSwitch(Project project, boolean enable) {
        CosySetting setting = CosyPersistentSetting.getInstance().getState();
        if (setting != null) {
            if (enable) {
                setting.setManualOpenLocalModel(true);
            }
            ChangeUserSettingParams params = setting.getParameter();
            CosyStatusBarWidget.updateStatusBar(null, project);
            if (Cosy.INSTANCE.checkCosy(project)) {
                Cosy.INSTANCE.updateConfig(params);
                ThreadUtil.execute(() -> {
                    ReportStatistic reportStatistic = new ReportStatistic(0L, TrackEventTypeEnum.CODE_COMPLETION_SWITCH.getName(), "", 0, 0, 0, enable ? "enabled" : "disabled");
                    this.trackThreadService.execute(project, reportStatistic);
                    if (!enable) {
                        ThreadUtil.sleep(1000L);
                        ApplicationUtil.killCosyProcess();
                        ThreadUtil.sleep(1000L);
                        Cosy.INSTANCE.checkCosy(project);
                    }
                });
            }
        }
    }
}

