/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.service.impl;

import com.alibabacloud.intellij.qoder.chat.model.BadFeedbackParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatAskParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatCodeChangeApplyParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatLikeParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatReplyRequestParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatStopParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatSystemEventParam;
import com.alibabacloud.intellij.qoder.chat.model.StopSessionParam;
import com.alibabacloud.intellij.qoder.chat.model.result.ChatAskResult;
import com.alibabacloud.intellij.qoder.chat.model.result.ChatLikeResult;
import com.alibabacloud.intellij.qoder.chat.model.result.ChatReplyListResult;
import com.alibabacloud.intellij.qoder.chat.model.result.ChatSystemEventResult;
import com.alibabacloud.intellij.qoder.constants.CosyKey;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.FeedbackResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.RecommendResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.SearchParams;
import com.alibabacloud.intellij.qoder.search.result.SearchValue;
import com.alibabacloud.intellij.qoder.search.util.StringCheckUtil;
import com.alibabacloud.intellij.qoder.service.CosyService;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.enums.MethodEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.istack.NotNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CosyServiceImpl
implements CosyService {
    private static Logger logger = Logger.getInstance(CosyServiceImpl.class);

    @Override
    public RecommendResult searchCode(@NotNull Project project, String query, Set<SearchValue> searchValueList, int page, String actionType, String lastRequestId, List<String> sources) {
        SearchParams searchParams;
        if (!Cosy.INSTANCE.checkCosy(project)) {
            RecommendResult result = new RecommendResult();
            result.setRequestId("DEFAULT");
            result.setErrMsg(I18NConstant.NO_COSY_ERROR);
            return result;
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            searchParams = new SearchParams(MethodEnum.NLP_SEARCH, page, 10);
            searchParams.setQuery(query);
        } else {
            searchParams = new SearchParams(MethodEnum.SEARCH, page, 10);
        }
        ArrayList<String> keywords = new ArrayList<String>();
        for (SearchValue searchValue : searchValueList) {
            keywords.add(searchValue.getPack());
        }
        searchParams.setKeywords(keywords);
        searchParams.setSources(sources);
        searchParams.setActionType(actionType);
        if (lastRequestId != null) {
            searchParams.setLastRequestId(lastRequestId);
        }
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            logger.warn("Cosy language service not available.");
            return null;
        }
        return Cosy.INSTANCE.getLanguageService(project).search(searchParams, 10000L);
    }

    @Override
    public RecommendResult searchQA(@NotNull Project project, String query, Set<SearchValue> searchValueList, int page, String actionType, String lastRequestId, List<String> sources) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            RecommendResult result = new RecommendResult();
            result.setRequestId("DEFAULT");
            result.setErrMsg(I18NConstant.NO_COSY_ERROR);
            return result;
        }
        SearchParams searchParams = new SearchParams(MethodEnum.CODE_DOC_SEARCH, page, 10);
        ArrayList<String> keywords = new ArrayList<String>();
        for (SearchValue searchValue : searchValueList) {
            keywords.add(searchValue.getPack());
        }
        searchParams.setKeywords(keywords);
        searchParams.setSources(sources);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            searchParams.setQuery(query);
        }
        searchParams.setActionType(actionType);
        if (lastRequestId != null) {
            searchParams.setLastRequestId(lastRequestId);
        }
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            return null;
        }
        return Cosy.INSTANCE.getLanguageService(project).search(searchParams, 10000L);
    }

    @Override
    public RecommendResult searchQAContent(Project project, String docId, String searchAction) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        SearchParams searchParams = new SearchParams(MethodEnum.CODE_DOC_SEARCH);
        searchParams.setActionType(searchAction);
        searchParams.setDocId(docId);
        searchParams.setPageSize(100);
        if (Cosy.INSTANCE.getLanguageService(project) == null) {
            return null;
        }
        return Cosy.INSTANCE.getLanguageService(project).search(searchParams, 10000L);
    }

    @Override
    public RecommendResult suggestCode(@NotNull Project project, String keyword) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        SearchParams searchParams = keyword.contains(" ") || StringCheckUtil.containChinese(keyword) ? new SearchParams(MethodEnum.SUGGESTION, 10) : new SearchParams(MethodEnum.SUGGESTION, 30);
        searchParams.setQuery(keyword);
        RecommendResult recommendResult = Cosy.INSTANCE.getLanguageService(project).search(searchParams, 10000L);
        return recommendResult;
    }

    @Override
    public ChatAskResult chatAsk(@NotNull Project project, ChatAskParam chatAskParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        if (ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT) == null) {
            ApplicationManager.getApplication().putUserData(CosyKey.REQUEST_TO_PROJECT, new ConcurrentHashMap());
        }
        if (ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST) == null) {
            ApplicationManager.getApplication().putUserData(CosyKey.REQUEST_TO_ANSWER_LIST, new ConcurrentHashMap());
        }
        if (ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING) == null) {
            ApplicationManager.getApplication().putUserData(CosyKey.REQUEST_ANSWERING, new ConcurrentHashMap());
        }
        if (ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_SESSION_TYPE) == null) {
            ApplicationManager.getApplication().putUserData(CosyKey.REQUEST_TO_SESSION_TYPE, new ConcurrentHashMap());
        }
        Set<String> requestIdSet = CosyKey.PROJECT_TO_REQUEST.get(project.getName());
        HashSet<String> newRequestIdSet = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(requestIdSet)) {
            for (String requestId : requestIdSet) {
                String sessionType = (String)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_SESSION_TYPE)).get(requestId);
                if (SessionTypeEnum.DEVELOPER.getType().equals(sessionType) || SessionTypeEnum.ASSISTANT.getType().equals(sessionType) || SessionTypeEnum.INLINE.getType().equals(sessionType)) {
                    newRequestIdSet.add(requestId);
                    continue;
                }
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(requestId);
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(requestId);
            }
            CosyKey.PROJECT_TO_REQUEST.put(project.getName(), newRequestIdSet);
        }
        Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).put(chatAskParam.getRequestId(), project);
        CosyKey.PROJECT_TO_REQUEST.computeIfAbsent(project.getName(), k -> new HashSet());
        CosyKey.PROJECT_TO_REQUEST.get(project.getName()).add(chatAskParam.getRequestId());
        Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_SESSION_TYPE)).put(chatAskParam.getRequestId(), chatAskParam.getSessionType());
        return Cosy.INSTANCE.getLanguageService(project).chatAsk(chatAskParam, 10000L);
    }

    @Override
    public ChatReplyListResult chatReplyList(Project project, ChatReplyRequestParam chatReplyRequestParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        ChatReplyListResult chatReplyListResult = Cosy.INSTANCE.getLanguageService(project).chatReplyRequest(chatReplyRequestParam, 10000L);
        if (chatReplyListResult != null) {
            logger.debug("Get chat reply list. count=" + (chatReplyListResult.getDisplayTasks() == null ? 0 : chatReplyListResult.getDisplayTasks().size()) + ", requestId=" + chatReplyListResult.getRequestId());
        }
        return chatReplyListResult;
    }

    @Override
    public ChatLikeResult chatLike(Project project, ChatLikeParam chatLikeParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        return Cosy.INSTANCE.getLanguageService(project).chatLike(chatLikeParam, 10000L);
    }

    @Override
    public void chatStop(Project project, ChatStopParam chatStopParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return;
        }
        Cosy.INSTANCE.getLanguageService(project).chatStop(chatStopParam);
    }

    @Override
    public ChatSystemEventResult chatSystemEvent(Project project, ChatSystemEventParam chatSystemEventParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        return Cosy.INSTANCE.getLanguageService(project).chatSystemEvent(chatSystemEventParam, 10000L);
    }

    @Override
    public FeedbackResult submitFeedback(Project project, BadFeedbackParam badFeedbackParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        if (badFeedbackParam == null || project == null) {
            return null;
        }
        return Cosy.INSTANCE.getLanguageService(project).submitFeedback(badFeedbackParam, 10000L);
    }

    @Override
    public void stopSession(Project project, StopSessionParam chatStopParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return;
        }
        Cosy.INSTANCE.getLanguageService(project).stopSession(chatStopParam);
    }

    @Override
    public List<String> listCurrentSession(Project project) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return new ArrayList<String>();
        }
        return Cosy.INSTANCE.getLanguageService(project).listCurrentSession(3000L);
    }

    @Override
    public boolean isHistorySession(Project project, String sessionId) {
        List<String> sessionIds = this.listCurrentSession(project);
        return CollectionUtils.isEmpty(sessionIds) || !sessionIds.contains(sessionId);
    }

    @Override
    public void chatCodeChangeApply(Project project, ChatCodeChangeApplyParam chatCodeChangeApplyParam) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return;
        }
        Cosy.INSTANCE.getLanguageService(project).chatCodeChangeApply(chatCodeChangeApplyParam, 10000L);
    }
}

