/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ListSnapshotsResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ListWorkingSpaceFileResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.OperateCommonResult;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.SnapshotInfo;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.WorkingSpaceFileInfo;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ListSnapshotsBySessionParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ListWorkingSpaceFileBySnapshotParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.SnapshotOperateParams;
import com.alibabacloud.intellij.qoder.service.SnapshotService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SnapshotServiceImpl
implements SnapshotService {
    private static Logger logger = Logger.getInstance(SnapshotServiceImpl.class);

    @Override
    public List<SnapshotInfo> listSnapshotsBySession(Project project, String sessionId) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return new ArrayList<SnapshotInfo>();
        }
        if (StringUtils.isBlank((String)sessionId) || project == null) {
            return new ArrayList<SnapshotInfo>();
        }
        ListSnapshotsBySessionParams params = new ListSnapshotsBySessionParams();
        params.setSessionId(sessionId);
        logger.debug("list snapshot by session params:" + JSON.toJSONString((Object)params));
        ListSnapshotsResult result = Cosy.INSTANCE.getLanguageService(project).listSnapshotsBySession(params, 10000L);
        if (result == null || StringUtils.isNotBlank((String)result.getErrorCode())) {
            logger.warn("list snapshot by session params:" + JSON.toJSONString((Object)params) + ",result=" + (String)(result == null ? "\u4e3a\u7a7a" : result.getErrorCode() + "," + result.getErrorMessage()));
            return new ArrayList<SnapshotInfo>();
        }
        return result.getSnapshots();
    }

    @Override
    public Boolean operate(Project project, SnapshotOperateParams params) {
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return false;
        }
        if (params == null || project == null) {
            return false;
        }
        logger.debug("operate params:" + JSON.toJSONString((Object)params));
        OperateCommonResult result = Cosy.INSTANCE.getLanguageService(project).operateSnapshot(params, 10000L);
        if (result == null || StringUtils.isNotBlank((String)result.getErrorCode())) {
            logger.warn("operate params:" + JSON.toJSONString((Object)params) + ",result=" + (String)(result == null ? "\u4e3a\u7a7a" : result.getErrorCode() + "," + result.getErrorMessage()));
            return false;
        }
        return true;
    }

    @Override
    public List<WorkingSpaceFileInfo> listWorkingSpaceFilesBySnapshot(Project project, String snapshotId) {
        return this.listWorkingSpaceFiles(project, ListWorkingSpaceFileBySnapshotParams.builder().snapshotId(snapshotId).build());
    }

    @Override
    public List<WorkingSpaceFileInfo> listWorkingSpaceFiles(Project project, ListWorkingSpaceFileBySnapshotParams params) {
        boolean invalidSessionRequestId;
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        if (null == params) {
            return null;
        }
        boolean invalidSnapshotId = StringUtils.isBlank((String)params.getSnapshotId());
        boolean bl = invalidSessionRequestId = StringUtils.isBlank((String)params.getRequestId()) || StringUtils.isBlank((String)params.getSessionId());
        if (invalidSnapshotId && invalidSessionRequestId) {
            return null;
        }
        ListWorkingSpaceFileResult result = Cosy.INSTANCE.getLanguageService(project).listWorkingSpaceFilesBySnapshot(params, 10000L);
        if (result == null || StringUtils.isNotBlank((String)result.getErrorCode())) {
            logger.warn("list working space files params:" + JSON.toJSONString((Object)params) + ",result=" + (String)(result == null ? "\u4e3a\u7a7a" : result.getErrorCode() + "," + result.getErrorMessage()));
            return null;
        }
        return result.getWorkingSpaceFiles();
    }
}

