/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.shared.cache.impl;

import com.alibabacloud.intellij.qoder.linguist.psi.model.CosyPsiElement;
import com.alibabacloud.intellij.qoder.shared.cache.CacheBase;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jsoup.internal.StringUtil;

public class CosyPsiTreeCache
implements CacheBase {
    private static final Logger log = Logger.getInstance(CosyPsiTreeCache.class);
    private Cache<String, CosyPsiElement> cosyPsiTreeCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).maximumSize(30L).build();
    private String cacheKey = "";
    private static final int CACHE_MINUTE_LIMIT = 1;

    @Override
    public Optional get(Object name) {
        if (name == null) {
            return Optional.empty();
        }
        CosyPsiElement cosyPsiElement = (CosyPsiElement)this.cosyPsiTreeCache.getIfPresent((Object)((String)name));
        if (cosyPsiElement == null) {
            return Optional.empty();
        }
        return Optional.of(cosyPsiElement);
    }

    @Override
    public void set(Object item) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String cacheKey, CosyPsiElement cosyPsiElement) {
        if (StringUtil.isBlank((String)cacheKey) || cosyPsiElement == null) {
            return;
        }
        Class<CosyPsiTreeCache> clazz = CosyPsiTreeCache.class;
        synchronized (CosyPsiTreeCache.class) {
            this.cosyPsiTreeCache.put((Object)cacheKey, (Object)cosyPsiElement);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    @Override
    public int getSize() {
        return this.cosyPsiTreeCache.asMap().size();
    }

    @Override
    public void clear() {
        this.cosyPsiTreeCache.cleanUp();
    }
}

