/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.shared.cache.impl;

import com.alibabacloud.intellij.qoder.shared.cache.CacheBase;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class SearchDefaultPanelTextCache
implements CacheBase {
    private static final Logger log = Logger.getInstance(SearchDefaultPanelTextCache.class);
    private Cache<Object, String> cached = Caffeine.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).maximumSize(5000L).build();
    private static final int CACHE_HOUR_LIMIT = 24;
    public static final String KEY = "DEFAULT_PANEL_TEXT";

    @Override
    public Optional get(Object prefix) {
        if (prefix == null) {
            return Optional.empty();
        }
        String text = (String)this.cached.getIfPresent(prefix);
        if (text == null) {
            return Optional.empty();
        }
        return Optional.of(text);
    }

    @Override
    public void set(Object item) {
        if (item == null) {
            return;
        }
        this.cached.put((Object)KEY, (Object)item.toString());
    }

    @Override
    public int getSize() {
        return this.cached.asMap().size();
    }

    @Override
    public void clear() {
        this.cached.cleanUp();
    }
}

