/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.shared.cache.impl;

import com.alibabacloud.intellij.qoder.shared.cache.CacheBase;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiType;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class VariableClassCache
implements CacheBase {
    private static final Logger log = Logger.getInstance(VariableClassCache.class);
    public static final int MAX_CANDIDATE_LOG = 10;
    private Cache<String, Map<String, PsiType>> variableMap = Caffeine.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).maximumSize(5000L).build();
    private static final Map<String, String> md5Map = new ConcurrentHashMap<String, String>();
    private static final Set<String> filePathMd5Set = new HashSet<String>();
    private String currentFilePath = "";
    private static final int CACHE_HOUR_LIMIT = 12;

    @Override
    public Optional get(Object name) {
        if (name == null) {
            return Optional.empty();
        }
        Map variableClassMap = (Map)this.variableMap.getIfPresent((Object)((String)name));
        if (variableClassMap == null || variableClassMap.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(variableClassMap);
    }

    @Override
    public void set(Object item) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String fileFullPath, String variableName, PsiType psiType) {
        if (fileFullPath == null || variableName == null || psiType == null) {
            return;
        }
        Class<VariableClassCache> clazz = VariableClassCache.class;
        synchronized (VariableClassCache.class) {
            ConcurrentHashMap<String, PsiType> variableClassMap = (ConcurrentHashMap<String, PsiType>)this.variableMap.getIfPresent((Object)fileFullPath);
            if (variableClassMap == null) {
                variableClassMap = new ConcurrentHashMap<String, PsiType>();
                this.variableMap.put((Object)fileFullPath, variableClassMap);
            }
            variableClassMap.put(variableName, psiType);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String fileFullPath, Map<String, PsiType> variableClassMap) {
        if (fileFullPath == null || variableClassMap == null) {
            return;
        }
        Class<VariableClassCache> clazz = VariableClassCache.class;
        synchronized (VariableClassCache.class) {
            this.variableMap.put((Object)fileFullPath, variableClassMap);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMd5Exist(String md5) {
        Set<String> set = filePathMd5Set;
        synchronized (set) {
            return md5 != null && filePathMd5Set.contains(md5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMd5(String filePath, String md5) {
        if (filePath == null || md5 == null) {
            return;
        }
        Set<String> set = filePathMd5Set;
        synchronized (set) {
            if (md5Map.containsKey(filePath)) {
                String oldMd5 = md5Map.get(filePath);
                filePathMd5Set.remove(oldMd5);
            }
            filePathMd5Set.add(md5);
            md5Map.put(filePath, md5);
        }
    }

    public void setCurrentFilePath(String filePath) {
        this.currentFilePath = filePath;
    }

    public String getCurrentFilePath() {
        return this.currentFilePath;
    }

    @Override
    public int getSize() {
        return this.variableMap.asMap().size();
    }

    @Override
    public void clear() {
        this.variableMap.cleanUp();
    }
}

