/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.tool.handler;

import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolInvokeRequest;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolInvokeResponse;
import com.alibabacloud.intellij.qoder.tool.handler.ToolHandler;
import com.alibabacloud.intellij.qoder.util.TerminalUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;

public class GetTerminalOutputToolHandler
extends ToolHandler {
    private static final Logger log = Logger.getInstance(GetTerminalOutputToolHandler.class);

    @Override
    public ToolInvokeResponse handle(Project project, ToolInvokeRequest request) {
        try {
            long startTime = System.currentTimeMillis();
            String terminalId = this.getStringParamValue(request, "terminalId");
            ShellTerminalWidget shellTerminalWidget = TerminalUtils.getWidget(terminalId);
            if (shellTerminalWidget == null) {
                return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "terminal not found");
            }
            String text = TerminalUtils.getText(shellTerminalWidget);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("terminalId", terminalId);
            result.put("content", text);
            return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), result, startTime, System.currentTimeMillis() - startTime);
        }
        catch (Exception e) {
            log.warn("handle error", (Throwable)e);
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), e.getMessage());
        }
    }
}

