/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.tool.handler;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolInvokeRequest;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolInvokeResponse;
import com.alibabacloud.intellij.qoder.tool.handler.ToolHandler;
import com.alibabacloud.intellij.qoder.util.TerminalUtils;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

public class RunTerminalToolHandler
extends ToolHandler {
    private static final Logger log = Logger.getInstance(RunTerminalToolHandler.class);
    private static final String TERMINAL_NAME = CosyConfig.isQoderEnabled() ? "QoderTerminal" : "LingmaTerminal";
    static final int BACKGROUND_RETURN_TIME = 10000;
    private String lastOutput = "";

    @Override
    public ToolInvokeResponse handle(Project project, ToolInvokeRequest request) {
        Map<String, Object> params = request.getParameters();
        if (params == null) {
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "params is null");
        }
        if (params.get("command") == null) {
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "command is null");
        }
        String command = (String)params.get("command");
        if (StringUtils.isBlank((CharSequence)command)) {
            return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "command is blank");
        }
        this.runTerminal(project, request.getToolCallId(), (String)params.get("command"));
        int i = 0;
        boolean background = this.getBooleanParamValue(request, "isBackground");
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 240000L) {
            ++i;
            ThreadUtil.sleep(300L);
            if (TerminalUtils.getWidgetHashCode(request.getToolCallId()) == null) {
                log.debug("ToolInvokeProcessor terminal not started,i=" + i);
                continue;
            }
            if ("ERROR".equals(TerminalUtils.getWidgetHashCode(request.getToolCallId()))) {
                log.warn("ToolInvokeProcessor terminal start error,i=" + i);
                return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "terminal start error");
            }
            String terminalId = TerminalUtils.getWidgetHashCode(request.getToolCallId());
            ShellTerminalWidget widget = TerminalUtils.getWidget(terminalId);
            if (background) {
                if (System.currentTimeMillis() - startTime <= 10000L) continue;
                Map<String, Object> result = this.getTerminalText(terminalId, widget);
                return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), result, startTime, System.currentTimeMillis() - startTime);
            }
            if (widget.getTtyConnector() == null) {
                log.debug("ToolInvokeProcessor ttyConnector is null,i=" + i);
                continue;
            }
            ProcessTtyConnector processTtyConnector = ShellTerminalWidget.getProcessTtyConnector((TtyConnector)widget.getTtyConnector());
            if (processTtyConnector == null) {
                log.debug("ToolInvokeProcessor processTtyConnector is null,i=" + i);
                continue;
            }
            if (TerminalUtil.hasRunningCommands((ProcessTtyConnector)processTtyConnector)) {
                log.debug("ToolInvokeProcessor terminal has Running commands,i=" + i);
                continue;
            }
            Map<String, Object> result = this.getTerminalText(terminalId, widget);
            if (MapUtils.isEmpty(result)) continue;
            if (StringUtils.isBlank((CharSequence)this.lastOutput)) {
                this.lastOutput = (String)result.get("content");
                continue;
            }
            if (!this.lastOutput.equals(result.get("content"))) {
                this.lastOutput = (String)result.get("content");
                log.debug("ToolInvokeProcessor terminal text is not same, i=" + i);
                continue;
            }
            log.debug("ToolInvokeProcessor terminal result=" + JSONObject.toJSONString(result) + " & i=" + i);
            return ToolInvokeResponse.success(request.getToolCallId(), request.getName(), result, startTime, System.currentTimeMillis() - startTime);
        }
        return ToolInvokeResponse.failed(request.getToolCallId(), request.getName(), "toolInvoke timeout");
    }

    public Map<String, Object> getTerminalText(String terminalId, ShellTerminalWidget widget) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            String text = TerminalUtils.getText(widget);
            if (StringUtils.isBlank((CharSequence)text)) {
                return;
            }
            result.put("terminalId", terminalId);
            result.put("content", text);
        });
        return result;
    }

    private void runTerminal(Project project, String toolCallId, String command) {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
                if (toolWindow == null) {
                    TerminalUtils.addToolCallIdWidgetHashCodeMap(toolCallId, "ERROR");
                    return;
                }
                String workingDirectory = project.getBasePath();
                Pair<Content, ShellTerminalWidget> pair = RunTerminalToolHandler.getSuitableProcess(toolWindow, workingDirectory);
                if (pair != null) {
                    log.debug("runTerminal exist suitable process");
                    toolWindow.activate(null);
                    toolWindow.getContentManager().setSelectedContent((Content)pair.getFirst());
                    ((ShellTerminalWidget)pair.getSecond()).executeCommand("clear;");
                    ThreadUtil.sleep(100L);
                    ((ShellTerminalWidget)pair.getSecond()).executeCommand(command);
                    TerminalUtils.addToolCallIdWidgetHashCodeMap(toolCallId, "" + ((ShellTerminalWidget)pair.getSecond()).hashCode());
                    TerminalUtils.addWidget((ShellTerminalWidget)pair.getSecond());
                    return;
                }
                TerminalView terminalView = TerminalView.getInstance((Project)project);
                ShellTerminalWidget shellTerminalWidget = terminalView.createLocalShellWidget(workingDirectory, TERMINAL_NAME);
                TtyConnector ttyConnector = shellTerminalWidget.getTtyConnector();
                if (ttyConnector != null) {
                    log.debug("ToolInvokeProcessor runTerminal ttyConnector not null,before");
                }
                shellTerminalWidget.executeCommand(command);
                ttyConnector = shellTerminalWidget.getTtyConnector();
                if (ttyConnector != null) {
                    log.debug("ToolInvokeProcessor runTerminal ttyConnector not null after");
                }
                shellTerminalWidget.hasRunningCommands();
                TerminalUtils.addToolCallIdWidgetHashCodeMap(toolCallId, "" + shellTerminalWidget.hashCode());
                TerminalUtils.addWidget(shellTerminalWidget);
            }
            catch (Exception e) {
                log.warn("ToolInvokeProcessor runTerminal errorMessage=" + e.getMessage());
                log.warn(ExceptionUtils.getStackTrace((Throwable)e));
                TerminalUtils.addToolCallIdWidgetHashCodeMap(toolCallId, "ERROR");
            }
        });
    }

    public static Pair<Content, ShellTerminalWidget> getSuitableProcess(ToolWindow toolWindow, String workingDirectory) {
        Content[] contents;
        ContentManager contentManager = toolWindow.getContentManager();
        for (Content content : contents = contentManager.getContents()) {
            String name = content.getDisplayName();
            if (!name.startsWith(TERMINAL_NAME)) continue;
            JBTerminalWidget jbTerminalWidget = TerminalView.getWidgetByContent((Content)content);
            if (!(jbTerminalWidget instanceof ShellTerminalWidget)) {
                log.debug("ToolInvokeProcessor getSuitableProcess jbTerminalWidget is not ShellTerminalWidget");
                continue;
            }
            ShellTerminalWidget shellTerminalWidget = (ShellTerminalWidget)jbTerminalWidget;
            if (!shellTerminalWidget.getTypedShellCommand().isEmpty()) {
                log.debug("ToolInvokeProcessor getSuitableProcess getTypedShellCommand is not empty");
                continue;
            }
            ProcessTtyConnector processTtyConnector = ShellTerminalWidget.getProcessTtyConnector((TtyConnector)jbTerminalWidget.getTtyConnector());
            if (processTtyConnector == null) {
                log.debug("ToolInvokeProcessor getSuitableProcess processTtyConnector is null");
                continue;
            }
            if (TerminalUtil.hasRunningCommands((ProcessTtyConnector)processTtyConnector)) {
                log.debug("ToolInvokeProcessor getSuitableProcess has running command");
                continue;
            }
            String currentWorkingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory((JBTerminalWidget)jbTerminalWidget, (String)"");
            if (!FileUtil.pathsEqual((String)workingDirectory, (String)currentWorkingDirectory)) {
                log.debug("ToolInvokeProcessor getSuitableProcess working directory not same");
                continue;
            }
            return new Pair((Object)content, (Object)shellTerminalWidget);
        }
        return null;
    }
}

