/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.action;

import com.alibabacloud.intellij.qoder.common.CosyCacheKeys;
import com.alibabacloud.intellij.qoder.completion.action.QoderAction;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.icons.CommonIcons;
import com.alibabacloud.intellij.qoder.ui.notifications.GrantAuthorNotification;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.Constants;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.SearchToolWindowFactory;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.ActiveFileInfo;
import com.alibabacloud.intellij.qoder.ui.search.topic.AddToChatNotifier;
import com.alibabacloud.intellij.qoder.util.LoginUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.Consumer;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AddToChatAction
extends AnAction
implements DumbAware,
UpdateInBackground,
QoderAction {
    private static final Logger log = Logger.getInstance(AddToChatAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AddToChatAction.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        Project project = e.getProject();
        if (editor == null) {
            log.warn("editor is null");
            return;
        }
        if (project == null) {
            log.warn("project is null");
            return;
        }
        AuthStatus authStatus = LoginUtil.getAuthStatusCacheFirst(project);
        Integer status = authStatus.getStatus();
        if (status == null || status.intValue() != AuthStateEnum.LOGIN.getValue()) {
            GrantAuthorNotification.notifyNeedLoginDirectly(project);
            return;
        }
        ActiveFileInfo meta = ActiveFileInfo.getFromEditor(editor);
        if (StringUtils.isEmpty((CharSequence)meta.getSelectedCode())) {
            NotificationFactory.showWarnNotification(project, I18NConstant.CHAT_NOTIFY_SELECT_CODE);
            return;
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(Constants.PLUGIN_NAME);
        if (toolWindow == null) {
            CosyCacheKeys.NEED_INIT_WELCOME_WINDOW.set((UserDataHolder)project, (Object)true);
            ToolWindowManager.getInstance((Project)project).registerToolWindow(RegisterToolWindowTask.closable((String)Constants.PLUGIN_NAME, (Icon)CommonIcons.AI, (ToolWindowAnchor)ToolWindowAnchor.RIGHT));
            toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(Constants.PLUGIN_NAME);
        }
        ToolWindow finalToolWindow = toolWindow;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (finalToolWindow != null) {
                if (finalToolWindow.getContentManager().findContent(I18NConstant.MAIN_CONTENT_NAME) == null) {
                    SearchToolWindowFactory.createSearchMainPanelAndGenerateContentForm(project, finalToolWindow, (Consumer<Project>)((Consumer)project1 -> ((AddToChatNotifier)project1.getMessageBus().syncPublisher(AddToChatNotifier.ADD_TO_CHAT_NOTIFICATION)).addToChat(meta)));
                } else {
                    SearchToolWindowFactory.showToolWindow(project);
                    ((AddToChatNotifier)project.getMessageBus().syncPublisher(AddToChatNotifier.ADD_TO_CHAT_NOTIFICATION)).addToChat(meta);
                }
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddToChatAction.$$$reportNull$$$0(1);
        }
        String text = CosyBundle.message("action.AddToChat.text", new Object[0]);
        e.getPresentation().setText(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/alibabacloud/intellij/qoder/ui/action/AddToChatAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

