/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.action;

import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ReCheckNetworkAction
extends AnAction {
    private static Logger log = Logger.getInstance(ReCheckNetworkAction.class);

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            ReCheckNetworkAction.$$$reportNull$$$0(0);
        }
        Project project = anActionEvent.getProject();
        ThreadUtil.execute(() -> {
            if (Cosy.INSTANCE.checkAndWaitCosyState(null, project)) {
                try {
                    AuthStatus authStatus = Cosy.INSTANCE.getLanguageService(project).authStatus(10000L);
                    if (AuthStateEnum.NETWORK_ERROR.getValue() == authStatus.getStatus().intValue()) {
                        String message = CosyBundle.message("message.chat.answer.quick.network.error", new Object[0]);
                        NotificationFactory.showWarnNotification(project, message);
                        return;
                    }
                    SwingUtilities.invokeAndWait(() -> ((AuthLoginNotifier)project.getMessageBus().syncPublisher(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION)).notifyLoginAuth(authStatus));
                }
                catch (Exception e) {
                    log.warn("fail to get auth status. " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anActionEvent", "com/alibabacloud/intellij/qoder/ui/action/ReCheckNetworkAction", "actionPerformed"));
    }
}

