/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.chat;

import com.alibabacloud.intellij.qoder.chat.enums.TriggerPlaceEnum;
import com.alibabacloud.intellij.qoder.chat.model.ChatAskInput;
import com.alibabacloud.intellij.qoder.chat.processor.ActionTriggerHelper;
import com.alibabacloud.intellij.qoder.common.BuildFeature;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.ui.chat.BaseChatAgentPanel;
import com.alibabacloud.intellij.qoder.ui.search.QoderToolWindowPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.TabLabel;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.qoder.ui.search.topic.AiAssistantGenerateStepCallbackNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AiAssistantGenerateStreamStopNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AiAssistantStreamPauseNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AnyGenerateNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.ChatDeleteNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.GenerateStreamPushNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.WorkspaceFileModifiedNotifier;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.RecentQueryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class AIAssistantPanel
extends BaseChatAgentPanel {
    private static final Logger log = Logger.getInstance(AIAssistantPanel.class);

    public AIAssistantPanel(Project project) {
        super(project);
    }

    @Override
    protected String getChatMainVerticalScrollbarKey() {
        return "AI_COMPOSER_MAIN_VERTICAL_SCROLLBAR_KEY";
    }

    @Override
    protected void registerMessageListener() {
        super.registerMessageListener();
        this.messageBusConnection.subscribe(GenerateStreamPushNotifier.GENERATE_STREAM_PUSH_NOTIFICATION, this::pushGenerate);
        this.messageBusConnection.subscribe(AiAssistantGenerateStreamStopNotifier.AI_ASSISTANT_GENERATE_STREAM_STOP_NOTIFICATION, this::stopGenerate);
        this.messageBusConnection.subscribe(AiAssistantStreamPauseNotifier.AI_ASSISTANT_STREAM_PAUSE_NOTIFICATION, this::pauseGenerate);
        this.messageBusConnection.subscribe(AiAssistantGenerateStepCallbackNotifier.AI_ASSISTANT_GENERATE_PROCESS_STEP_CALLBACK_NOTIFICATION, this::processStepCallback);
        this.messageBusConnection.subscribe(WorkspaceFileModifiedNotifier.WORKSPACE_FILE_MODIFIED_NOTIFICATION, this::updateSendButtonByFileStatus);
        this.messageBusConnection.subscribe(ChatDeleteNotifier.CHAT_DELETE_NOTIFICATION, this::deleteChat);
        if (!CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            this.messageBusConnection.subscribe(AnyGenerateNotifier.ANY_GENERATE_NOTIFICATION, this::anyGenerate);
        }
    }

    @Override
    public void switchPanel(QoderToolWindowPanel toolWindowPanel) {
        super.switchPanel(toolWindowPanel);
        ((TabLabel)toolWindowPanel.getAiAssistantTabBtn()).setExternBorder(JBUI.Borders.customLine((Color)ColorUtil.getTabbedUnderlineColor(), (int)0, (int)0, (int)2, (int)0));
    }

    @Override
    public SessionTypeEnum getSessionTypeEnum() {
        return SessionTypeEnum.ASSISTANT;
    }

    @Override
    public String getSessionTab() {
        return "AiAssistantAgent";
    }

    @Override
    public String getWelcomeMessage() {
        return CosyBundle.messageVpc("message.assistant.quick.ask", new Object[0]);
    }

    @Override
    protected void setupTextArea() {
        this.inputPanel.setTextAreaPlaceholder();
        this.inputPanel.addEnterKeyListener(this::processEnterKey);
    }

    @Override
    protected void triggerAskWithActionId(String text, String actionId, List<ChatAskTag> tags, ChatAskInput chatAskInput) {
        if (StringUtils.isEmpty((CharSequence)actionId)) {
            this.initInput.setChatAskInput(chatAskInput);
            this.triggerAiAssistantAsk(this.initInput, text);
        } else {
            String finalActionId = actionId;
            RecentQueryUtil.addRecentComplexQuery(this.project, chatAskInput);
            SwingUtilities.invokeLater(() -> ActionTriggerHelper.triggerSelectionAction(this.project, finalActionId, TriggerPlaceEnum.ASK_INPUT_PANEL.getName(), chatAskInput));
        }
    }

    private void triggerAiAssistantAsk(GenerateInput input, String text) {
        this.triggerAgentAsk(input, text);
    }

    @Override
    public String getNewChatText() {
        return CosyBundle.message("main.toolbar.btn.new.chat", new Object[0]);
    }

    @Override
    protected void showWorkingSpacePanel() {
        if (this.needShowWorkingSpacePanel()) {
            this.workingSpacePanel.clear();
            this.workingSpacePanel.setVisible(true);
        }
    }

    @Override
    protected void postGenerate() {
        this.checkIfNeedShowWorkingSpacePanel();
    }
}

