/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.chat;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.qoder.chat.enums.FilterStatusEnum;
import com.alibabacloud.intellij.qoder.chat.factory.ChatContextDtoBuilderFactory;
import com.alibabacloud.intellij.qoder.chat.model.AskAnswer;
import com.alibabacloud.intellij.qoder.chat.model.ChatAskInput;
import com.alibabacloud.intellij.qoder.chat.model.ChatAskParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatContext;
import com.alibabacloud.intellij.qoder.chat.model.ChatHistory;
import com.alibabacloud.intellij.qoder.chat.model.ChatReplyRequestParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatStopParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatSystemEventParam;
import com.alibabacloud.intellij.qoder.chat.model.StopSessionParam;
import com.alibabacloud.intellij.qoder.chat.model.result.ChatAskResult;
import com.alibabacloud.intellij.qoder.chat.model.task.DisplayTask;
import com.alibabacloud.intellij.qoder.chat.model.task.PluginPayloadConfig;
import com.alibabacloud.intellij.qoder.chat.model.task.dto.TerminalRelatedDto;
import com.alibabacloud.intellij.qoder.common.BuildFeature;
import com.alibabacloud.intellij.qoder.common.CosyConfig;
import com.alibabacloud.intellij.qoder.constants.ActionConstants;
import com.alibabacloud.intellij.qoder.constants.CosyKey;
import com.alibabacloud.intellij.qoder.constants.InputConstants;
import com.alibabacloud.intellij.qoder.constants.QoderUrls;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStateEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthWhitelistStatusEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatModelItem;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatRecord;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatSession;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.ChatStep;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.IntentionTypeEnum;
import com.alibabacloud.intellij.qoder.core.lsp.model.params.ChatQueueParams;
import com.alibabacloud.intellij.qoder.core.lsp.model.tool.ToolCallSyncResult;
import com.alibabacloud.intellij.qoder.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.qoder.search.result.SearchContext;
import com.alibabacloud.intellij.qoder.search.util.BackgroundAdaptUtil;
import com.alibabacloud.intellij.qoder.service.CosyService;
import com.alibabacloud.intellij.qoder.service.ModeService;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.service.UserAuthService;
import com.alibabacloud.intellij.qoder.service.impl.CosyServiceImpl;
import com.alibabacloud.intellij.qoder.ui.chat.ChatMessageQueuePanel;
import com.alibabacloud.intellij.qoder.ui.notifications.GrantAuthorNotification;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.Constants;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.QoderToolWindowPanel;
import com.alibabacloud.intellij.qoder.ui.search.SearchToolWindowFactory;
import com.alibabacloud.intellij.qoder.ui.search.SwingManager;
import com.alibabacloud.intellij.qoder.ui.search.color.CosyColor;
import com.alibabacloud.intellij.qoder.ui.search.component.ChatViewPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.SystemMessageCard;
import com.alibabacloud.intellij.qoder.ui.search.component.WelcomeBgPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.WorkingSpacePanel;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.ChatReferenceParser;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatStageParseKey;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatStepStatusEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatSystemEventEnum;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.ChatQuestionForm;
import com.alibabacloud.intellij.qoder.ui.search.generate.GenerateAnswerPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.NewFileAction;
import com.alibabacloud.intellij.qoder.ui.search.generate.ShowDiffAction;
import com.alibabacloud.intellij.qoder.ui.search.generate.SuggestPromptPopupPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatContextTagsPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatReferenceChunk;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatReferenceItem;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatReferenceTeamDocsHistory;
import com.alibabacloud.intellij.qoder.ui.search.model.CodeWithExt;
import com.alibabacloud.intellij.qoder.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.qoder.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.TaskChatAskTag;
import com.alibabacloud.intellij.qoder.ui.search.model.tool.task.TaskItem;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthStateChangeNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.ChatModelChangeNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.ChatQueuedNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.ChatThinkingStreamPushNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.LanguageChangedNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QoderCodeDiffNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QoderCodeNewFileNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QoderOpenToolWindowNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.QoderTabChangeNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.SimpleChatThinkingStreamStopNotifier;
import com.alibabacloud.intellij.qoder.util.AuthStatusUtil;
import com.alibabacloud.intellij.qoder.util.ChatAskTagUtil;
import com.alibabacloud.intellij.qoder.util.ChatSessionUtil;
import com.alibabacloud.intellij.qoder.util.ChatTaskUtil;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.ErrorMessageHandler;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.LanguageUtil;
import com.alibabacloud.intellij.qoder.util.LoginUtil;
import com.alibabacloud.intellij.qoder.util.NumberUtil;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.alibabacloud.intellij.qoder.util.ThemeUtil;
import com.alibabacloud.intellij.qoder.util.ThreadUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;

public abstract class BaseChatPanel {
    private static final Logger log = Logger.getInstance(BaseChatPanel.class);
    protected static final int COSY_AGENT_CHAT_TIMEOUT = 30;
    protected static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    protected JPanel basePanel;
    protected JBScrollPane scrollPane;
    protected JPanel flowPanel;
    protected Project project;
    protected GenerateAnswerPanel answerPanel;
    protected MessageBusConnection messageBusConnection;
    protected AtomicBoolean manualScroll;
    protected GenerateInput initInput;
    public CosyService cosyService;
    protected AskInputPanel inputPanel;
    protected ChatQuestionForm chatQuestionForm;
    public CodeWithExt questionCodeWithExt;
    protected String sessionType;
    protected ChatViewPanel chatViewPanel;
    protected WorkingSpacePanel workingSpacePanel;
    protected List<String> applyingFileIds = new ArrayList<String>();
    protected AtomicBoolean isAnswering;

    public BaseChatPanel(Project project) {
        this.project = project;
        this.sessionType = this.getSessionTypeEnum().getType();
        this.initInput = ChatTaskUtil.getInitInput(project, this.getSessionTab());
        this.cosyService = new CosyServiceImpl();
        this.manualScroll = new AtomicBoolean(false);
        this.isAnswering = new AtomicBoolean(false);
        this.initBasePanel();
        this.configScrollAndFlowPanel();
        this.configInputPanel();
        this.constructPanel();
        this.setupTextArea();
        this.configFlowPanelUI();
        this.scrollPane.addMouseWheelListener(e -> {
            if (this.inputPanel != null) {
                this.inputPanel.invalidate();
                this.inputPanel.repaint();
            }
            if (this.scrollPane.getVerticalScrollBar().isVisible()) {
                this.manualScroll.getAndSet(!SwingUtil.isScrollBarAtBottom((JScrollPane)this.scrollPane));
            }
        });
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        SwingManager.INSTANCE.registerComponent(project, this.getChatMainVerticalScrollbarKey(), (Component)this.scrollPane);
        this.registerMessageListener();
        SwingUtil.foreachChildComponentV2(this.basePanel, cp -> {
            if (cp instanceof AskInputPanel || cp instanceof ChatContextTagsPanel || cp instanceof WorkingSpacePanel) {
                return false;
            }
            if (cp instanceof JPanel && !(cp instanceof RoundRectPanel)) {
                cp.setBackground(ColorUtil.getToolWindowBackgroundColor());
            }
            return true;
        });
        BackgroundAdaptUtil.monitorMarkdownPaneColor(this.flowPanel);
    }

    protected void initBasePanel() {
        this.basePanel = new JPanel(new BorderLayout());
        this.basePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    protected void configScrollAndFlowPanel() {
        this.flowPanel = new WelcomeBgPanel();
        this.scrollPane = new JBScrollPane((Component)this.flowPanel, 20, 31);
    }

    protected void configInputPanel() {
        this.inputPanel = new AskInputPanel(this.project, this, this.getSessionTab());
    }

    protected void constructPanel() {
        this.chatViewPanel = new ChatViewPanel(this.project, this);
        this.workingSpacePanel = this.chatViewPanel.getWorkingSpacePanel();
        JPanel containerPanel = new JPanel(new BorderLayout());
        containerPanel.add((Component)this.chatViewPanel, "North");
        containerPanel.add((Component)this.inputPanel, "South");
        this.basePanel.add((Component)containerPanel, "South");
        this.basePanel.add((Component)this.scrollPane, "Center");
        this.workingSpacePanel.setVisible(false);
        this.chatViewPanel.getTodoViewPanel().setVisible(false);
        this.chatViewPanel.getMessageQueuePanel().setVisible(false);
    }

    protected void configFlowPanelUI() {
        this.flowPanel.setLayout((LayoutManager)new VerticalFlowLayout(2, 0, 8, true, false));
        this.flowPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        this.flowPanel.setBackground((Color)CosyColor.CHAT_QUESTION_BG_COLOR);
    }

    protected abstract String getChatMainVerticalScrollbarKey();

    protected abstract void setupTextArea();

    public void switchPanel(QoderToolWindowPanel toolWindowPanel) {
        this.inputPanel.setTextFocus();
    }

    protected void registerMessageListener() {
        this.messageBusConnection = this.project.getMessageBus().connect();
        this.messageBusConnection.subscribe(ChatThinkingStreamPushNotifier.CHAT_THINKING_PUSH_NOTIFICATION, this::pushThinking);
        this.messageBusConnection.subscribe(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION, this::notifyLoginAuth);
        this.messageBusConnection.subscribe(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION, this::notifyLogoutAuth);
        this.messageBusConnection.subscribe(AuthStateChangeNotifier.AUTH_CHANGE_NOTIFICATION, this::notifyChangeAuth);
        this.messageBusConnection.subscribe(QoderOpenToolWindowNotifier.LINGMA_OPEN_TOOL_WINDOW_NOTIFIER_TOPIC, this::handleOpenToolWindow);
        this.messageBusConnection.subscribe(LanguageChangedNotifier.LANGUAGE_CHANGED_NOTIFIER, this::updateUiTexts);
        this.messageBusConnection.subscribe(QoderCodeNewFileNotifier.LINGMA_CODE_NEW_FILE, this::newFile);
        this.messageBusConnection.subscribe(QoderCodeDiffNotifier.LINGMA_CODE_DIFF, this::showDiff);
        this.messageBusConnection.subscribe(ChatQueuedNotifier.CHAT_QUEUED_NOTIFIER, this::showQueuedInfo);
        this.messageBusConnection.subscribe(ChatModelChangeNotifier.CHAT_MODEL_CHANGE_NOTIFICATION, this::changeModel);
    }

    private void changeModel(ChatModelItem chatModelItem, String usage) {
        if ("AnswerPanel".equals(usage)) {
            this.sendStopChatRequest(this.answerPanel.getRequestId(), false);
            DisplayTask displayTask = this.getRetryTaskForError();
            this.initInput.setChatTask(displayTask.getChatTask());
            this.prepareAndAsynchronousChat(this.initInput, displayTask.getPrompt(), displayTask.getDisplayTextLocale(), UUID.randomUUID().toString());
        }
    }

    private void showQueuedInfo(ChatQueueParams chatQueueParams) {
        if (this.answerPanel == null) {
            log.warn("Answer panel is not ready when showQueuedInfo");
            return;
        }
        this.answerPanel.clearAll();
        if (null != chatQueueParams) {
            Map userData = (Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING);
            if (null == userData || null == userData.get(chatQueueParams.getRequestId())) {
                log.warn("ignore non-answering queued message");
                return;
            }
            this.answerPanel.showQueuedInfo(chatQueueParams);
        }
        this.answerPanel.updateGenerateState(CosyBundle.message("chat.answer.btn.generating", new Object[0]));
    }

    protected void pushGenerate(String requestId, String sessionId, String value, Boolean overwrite, Boolean refresh, String intentionType, String sessionType) {
        if (this.answerPanel == null) {
            log.warn("Answer panel is not ready when pushGenerate");
            return;
        }
        this.answerPanel.setIntentionType(intentionType);
        if (this.answerPanel.getRequestId() == null || this.answerPanel.getSessionId() == null) {
            this.answerPanel.setRequestId(requestId);
            this.answerPanel.setSessionId(sessionId);
        }
        if (this.chatQuestionForm != null && this.chatQuestionForm.getSessionId() == null) {
            this.chatQuestionForm.setSessionId(sessionId);
        }
        if (!this.answerPanel.getRequestId().equals(requestId)) {
            return;
        }
        this.answerPanel.updateGenerateState(CosyBundle.message("chat.answer.btn.generating", new Object[0]));
        this.answerPanel.doneThinking();
        if (overwrite.booleanValue()) {
            this.answerPanel.clearAll();
            this.answerPanel.hideGenerateStatePanel();
        } else if (BooleanUtils.isTrue((Boolean)refresh)) {
            this.answerPanel.clearText();
        }
        this.answerPanel.appendText(value, false);
        this.postGenerate();
        this.moveScrollToBottom(false);
        this.answerPanel.getComponent().invalidate();
        this.answerPanel.getComponent().repaint();
        if (BooleanUtils.isTrue((Boolean)overwrite) || BooleanUtils.isTrue((Boolean)refresh)) {
            this.answerPanel.endGenerate();
        }
    }

    protected void postGenerate() {
    }

    public void moveScrollToBottom(boolean forceScroll) {
        if (Boolean.TRUE.equals(forceScroll) || !this.manualScroll.get()) {
            this.flowPanel.validate();
            this.scrollPane.validate();
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
        }
    }

    protected void pushThinking(String requestId, String sessionId, String wholeText, boolean done) {
        if (this.answerPanel == null) {
            return;
        }
        if (this.answerPanel.getRequestId() == null || this.answerPanel.getSessionId() == null) {
            this.answerPanel.setRequestId(requestId);
            this.answerPanel.setSessionId(sessionId);
        }
        if (this.chatQuestionForm != null && this.chatQuestionForm.getSessionId() == null) {
            this.chatQuestionForm.setSessionId(sessionId);
        }
        if (!this.answerPanel.getRequestId().equals(requestId)) {
            return;
        }
        this.answerPanel.updateGenerateState(CosyBundle.message("chat.answer.btn.generating", new Object[0]));
        this.answerPanel.updateThinkingPanel(wholeText, done, false, null);
        this.moveScrollToBottom(false);
        this.answerPanel.getComponent().invalidate();
        this.answerPanel.getComponent().repaint();
    }

    public void stopGenerate(String requestId, String sessionId, Integer statusCode, String reason, Map<String, Object> extra) {
        ChatMessageQueuePanel.ChatMessageItem message;
        if (this.answerPanel == null) {
            return;
        }
        if (this.answerPanel.getRequestId() != null && !this.answerPanel.getRequestId().equals(requestId)) {
            return;
        }
        if (this.initInput.getChatContext().getSessionId() != null && !this.initInput.getChatContext().getSessionId().equals(sessionId)) {
            return;
        }
        String intentType = null == extra ? "" : StringUtils.objectToString(extra.get("intentType"));
        boolean isAgent = IntentionTypeEnum.COMMON_AGENT.getValue().equals(intentType);
        String answerText = this.answerPanel.getAnswerText();
        List<String> currentSteps = this.answerPanel.getCurrentSteps();
        if (statusCode != null && statusCode == 200) {
            if (!Cosy.INSTANCE.checkCosy(this.project, true)) {
                return;
            }
            this.recordAnswerToHistory(answerText);
        } else {
            if (!currentSteps.isEmpty()) {
                this.answerPanel.appendChatStagePanelBottomBorder();
            }
            log.warn("Abnormal finish chat, code=" + (Serializable)(statusCode == null ? "null" : statusCode) + ", reason=" + reason);
            if (statusCode != null && statusCode == 429) {
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                boolean overwrite = !isAgent;
                String message2 = overwrite || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? I18NConstant.CHAT_TOO_MANY_REQUESTS : "\n" + I18NConstant.CHAT_TOO_MANY_REQUESTS;
                this.pushGenerate(requestId, sessionId, message2, overwrite, false, intentType, null);
            } else if (statusCode != null && statusCode == 31404) {
                boolean overwrite = !isAgent;
                String message3 = overwrite || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? I18NConstant.DIRECTORY_NOT_EXISTED_ERROR : "\n" + I18NConstant.DIRECTORY_NOT_EXISTED_ERROR;
                this.pushGenerate(requestId, sessionId, message3, overwrite, false, intentType, null);
            } else if (statusCode != null && statusCode == 403) {
                String text = "";
                try {
                    JSONObject reasonJson = JSON.parseObject((String)reason);
                    if (null != reasonJson) {
                        Integer code = reasonJson.getInteger("code");
                        JSONObject message4 = reasonJson.getJSONObject("message");
                        if (null != code) {
                            String pricingUrl = null;
                            Boolean isHighestTier = null;
                            if (null != message4) {
                                pricingUrl = message4.getString("pricingUrl");
                                isHighestTier = message4.getBoolean("isHighestTier");
                            }
                            if (code == 112) {
                                text = Boolean.TRUE.equals(isHighestTier) ? CosyBundle.message("quota.daily.limit.text.highest", pricingUrl) : CosyBundle.message("quota.daily.limit.text", pricingUrl);
                            } else if (code == 113) {
                                text = Boolean.TRUE.equals(isHighestTier) ? CosyBundle.message("quota.basic.daily.limit.text.highest", pricingUrl) : CosyBundle.message("quota.basic.daily.limit.text.plain", pricingUrl);
                            } else if (code == 114) {
                                text = CosyBundle.message("quota.same.person.text", QoderUrls.TROUBLESHOOTING_ACCOUNT_MANAGEMENT.getRealUrl());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.warn("Failed to parse reason to json object: " + reason, (Throwable)e);
                }
                Object message5 = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? text : "\n" + text;
                this.pushGenerate(requestId, sessionId, (String)message5, false, false, intentType, null);
            } else if (statusCode != null && statusCode == 406) {
                boolean overwrite = !isAgent;
                String message6 = overwrite || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? CosyBundle.message("net.filter.text", new Object[0]) : "\n" + CosyBundle.message("net.filter.text", new Object[0]);
                this.pushGenerate(requestId, sessionId, message6, overwrite, false, intentType, null);
            } else if (statusCode != null && statusCode == 408) {
                this.pushGenerate(requestId, sessionId, "", false, false, intentType, null);
            } else if (statusCode != null && statusCode == 409) {
                boolean overwrite = !isAgent;
                String message7 = overwrite || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? I18NConstant.CHAT_ERROR_RETRY_NO_HISTORY : "\n" + I18NConstant.CHAT_ERROR_RETRY_NO_HISTORY;
                this.pushGenerate(requestId, sessionId, message7, overwrite, false, intentType, null);
            } else if (statusCode != null && statusCode == 40505) {
                boolean overwrite = !isAgent;
                String message8 = overwrite || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? I18NConstant.FUNCTION_CALL_UNSUPPORTED_ERROR : "\n" + I18NConstant.FUNCTION_CALL_UNSUPPORTED_ERROR;
                this.pushGenerate(requestId, sessionId, message8, overwrite, false, intentType, null);
            } else if (statusCode != null && statusCode == 500) {
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                boolean overwrite = !isAgent;
                String message9 = overwrite || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? I18NConstant.CHAT_INTERNAL_ERROR : "\n" + I18NConstant.CHAT_INTERNAL_ERROR;
                this.pushGenerate(requestId, sessionId, message9, overwrite, false, null, null);
            } else if (statusCode != null && statusCode == 601) {
                this.pushGenerate(requestId, sessionId, I18NConstant.CHAT_BLOCKED_BY_FILTER, false, false, intentType, null);
            } else if (statusCode != null && statusCode.equals(Integer.valueOf("602"))) {
                boolean overwrite = !isAgent;
                String text = CosyBundle.message("chat.command.not.found", new Object[0]);
                String message10 = overwrite || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? text : "\n" + text;
                this.pushGenerate(requestId, sessionId, message10, overwrite, false, intentType, null);
            } else if (statusCode != null && statusCode.equals(Integer.valueOf("604"))) {
                boolean overwrite;
                boolean bl = overwrite = !isAgent;
                if (extra != null && extra.containsKey("testAgentMethodRemainQuota")) {
                    String text = String.format(CosyBundle.message("test.agent.method.quota.insufficient.with.remained", new Object[0]), NumberUtil.objectToInteger(extra.get("testAgentMethodRemainQuota")));
                    String message11 = overwrite || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? text : "\n" + text;
                    this.pushGenerate(requestId, sessionId, message11, overwrite, false, intentType, null);
                } else {
                    String text = CosyBundle.message("test.agent.method.quota.insufficient.without.remained", new Object[0]);
                    String message12 = overwrite || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? text : "\n" + text;
                    this.pushGenerate(requestId, sessionId, message12, overwrite, false, intentType, null);
                }
            } else if (statusCode != null && statusCode.equals(Integer.valueOf("605"))) {
                boolean overwrite = !isAgent;
                String text = CosyBundle.message("test.agent.process.exception", new Object[0]);
                String message13 = overwrite || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? text : "\n" + text;
                this.pushGenerate(requestId, sessionId, message13, overwrite, false, intentType, null);
            } else if (statusCode != null && statusCode == 90000) {
                boolean overwrite = !isAgent;
                String text = CosyBundle.message("chat.model.vision.not.support", new Object[0]);
                String message14 = overwrite || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? text : "\n" + text;
                this.pushGenerate(requestId, sessionId, message14, overwrite, false, intentType, null);
            } else if (statusCode != null && statusCode == 10605) {
                String message15 = CosyBundle.message("chat.queued.text.canceled", new Object[0]);
                this.pushGenerate(requestId, sessionId, message15, true, false, intentType, null);
            } else {
                boolean overwrite = !isAgent;
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                String text = ErrorMessageHandler.convertErrorMessage(this.project, requestId, reason, null);
                String message16 = overwrite || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? text : "\n" + text;
                this.pushGenerate(requestId, sessionId, message16, overwrite, false, intentType, null);
            }
        }
        this.answerPanel.hideBottomPanel();
        this.answerPanel.stopAllSteps();
        this.answerPanel.endGenerate();
        this.enableSendButton();
        ((SimpleChatThinkingStreamStopNotifier)this.project.getMessageBus().syncPublisher(SimpleChatThinkingStreamStopNotifier.SIMPLE_CHAT_THINKING_STOP_NOTIFICATION)).stop();
        this.inputPanel.setTextAreaPlaceholder();
        this.summaryTodoViewPanel();
        this.isAnswering.set(false);
        if (this.chatViewPanel.getMessageQueuePanel().hasMessage() && null != (message = this.chatViewPanel.getMessageQueuePanel().pollMessage())) {
            this.triggerAskWithActionId(message.getText(), message.getActionId(), message.getTags(), message.getChatAskInput());
        }
    }

    private ChatReplyRequestParam getChatReplyRequestParam(String requestId, String sessionId) {
        return ChatReplyRequestParam.builder().requestId(requestId).sessionId(sessionId).build();
    }

    private void recordAnswerToHistory(String answer) {
        List<AskAnswer> askAnswerList = this.initInput.getChatHistory().getAskAnswerList();
        if (askAnswerList.isEmpty()) {
            log.warn("askAnswerList size is 0");
            return;
        }
        askAnswerList.get(askAnswerList.size() - 1).setAnswer(answer);
    }

    protected void showRetryQuickAsk() {
        ArrayList<DisplayTask> displayTasks = new ArrayList<DisplayTask>();
        displayTasks.add(this.getRetryTaskForError());
        this.answerPanel.showQuickPanel(this.initInput, displayTasks);
    }

    private DisplayTask getRetryTaskForError() {
        return DisplayTask.builder().chatTask(ChatTaskEnum.RETRY_TASK.getName()).displayText(I18NConstant.CHAT_ERROR_RETRY_TIPS).displayEnText(I18NConstant.CHAT_ERROR_RETRY_TIPS).prompt("<COSY::RETRY>").build();
    }

    protected void enableSendButton() {
        this.inputPanel.enableSendButton();
        this.applyingFileIds.clear();
        ChatInputTextArea textArea = this.inputPanel.getTextArea();
        if (!(null == textArea || textArea.isEnabled() && textArea.isEditable())) {
            this.inputPanel.enableInputPanel();
        }
    }

    protected void pauseGenerate(String requestId, String sessionId) {
        this.enableSendButton();
        if (this.answerPanel == null) {
            return;
        }
        if (this.answerPanel.getRequestId() != null && !this.answerPanel.getRequestId().equals(requestId)) {
            return;
        }
        this.answerPanel.hideGenerateStatePanel();
        if (!Cosy.INSTANCE.checkCosy(this.project, true)) {
            this.answerPanel.hideBottomPanel();
            this.moveScrollToBottom(false);
        }
    }

    protected void processStepCallback(String requestId, String sessionId, ChatStep chatStep) {
        if (this.answerPanel == null) {
            log.warn("Answer panel is not ready when processStepCallback");
            return;
        }
        if (this.answerPanel.getRequestId() == null || this.answerPanel.getSessionId() == null) {
            this.answerPanel.setRequestId(requestId);
            this.answerPanel.setSessionId(sessionId);
        }
        if (this.chatQuestionForm != null) {
            if (this.chatQuestionForm.getSessionId() == null) {
                this.chatQuestionForm.setSessionId(sessionId);
            }
            if (this.chatQuestionForm.getRequestId() == null) {
                this.chatQuestionForm.setRequestId(requestId);
            }
        }
        if (!this.answerPanel.getRequestId().equals(requestId)) {
            return;
        }
        this.answerPanel.addOrUpdateStep(chatStep, false);
        this.moveScrollToBottom(false);
    }

    protected void notifyLoginAuth(AuthStatus status) {
        if (this.needShowSystemMessage()) {
            this.showWelcomeInfoPanel();
        }
        if (status != null && status.isAllow()) {
            this.enableInputPanel();
            this.inputPanel.checkSendButtonState();
        }
        this.inputPanel.getChatInputSuggester().getSuggestPromptPopupPanel().initSuggestPromptChooser();
    }

    protected void notifyLogoutAuth(AuthStatus status) {
        this.inputPanel.clearAll();
        this.showWelcomeInfoPanel();
        if (!status.isAllow()) {
            this.disableInputPanel();
        }
    }

    private void notifyChangeAuth(AuthStatus status) {
        if (status.isAllow()) {
            this.enableInputPanel();
            this.enableSendButton();
            this.inputPanel.checkSendButtonState();
        } else {
            GrantAuthorNotification.notifyNeedLogin(this.project, true);
        }
        if (this.needShowSystemMessage()) {
            this.showWelcomeInfoPanel();
        }
    }

    private boolean needShowSystemMessage() {
        boolean showedMsg = false;
        for (Component component : this.flowPanel.getComponents()) {
            if (!(component instanceof SystemMessageCard)) continue;
            showedMsg = true;
            break;
        }
        return showedMsg;
    }

    protected void disableInputPanel() {
        if (this.inputPanel == null) {
            return;
        }
        this.inputPanel.disableInputPanel();
    }

    protected void enableInputPanel() {
        this.inputPanel.enableInputPanel();
    }

    public abstract SessionTypeEnum getSessionTypeEnum();

    public abstract String getSessionTab();

    public abstract String getWelcomeMessage();

    protected void showWelcomeInfoPanel() {
        this.showWelcomeInfoPanel(false);
    }

    protected void showWelcomeInfoPanel(boolean startup) {
        String message;
        this.flowPanel.removeAll();
        boolean needLoginOptions = false;
        AuthStatus status = startup ? LoginUtil.getAuthStatus(this.project) : LoginUtil.getAuthStatusCacheFirst(this.project);
        if (status.getStatus() == null) {
            status.setStatus(AuthStateEnum.NOT_LOGIN.getValue());
        }
        if (AuthStateEnum.LOGIN.getValue() == status.getStatus().intValue()) {
            message = status.getWhitelist() != null && AuthWhitelistStatusEnum.PASS.getValue() == status.getWhitelist().intValue() ? this.getWelcomeMessage() : (status.getWhitelist() != null && AuthWhitelistStatusEnum.NO_LICENCE.getValue() == status.getWhitelist().intValue() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)status.getOrgId()) ? CosyBundle.messageVpc("message.chat.login.require.licence.access", new Object[0]) : (status.getWhitelist() != null && status.getWhitelist().intValue() == AuthWhitelistStatusEnum.ORG_ORDER_EXPIRED.getValue() ? String.format(CosyBundle.message("message.chat.answer.org.order.expired", new Object[0]), status.getName(), status.getOrgName()) : (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)status.getOrgId()) ? String.format(AuthStatusUtil.getNoAccessMessageForOrgMember("message.chat.login.require.org.access"), status.getName(), status.getOrgName()) : String.format(CosyBundle.messageVpc("message.chat.login.require.access", new Object[0]), status.getName()))));
        } else if (AuthStateEnum.NETWORK_ERROR.getValue() == status.getStatus().intValue()) {
            message = CosyBundle.message("message.chat.quick.network.error", new Object[0]);
        } else if (AuthStateEnum.IP_BANNED_ERROR.getValue() == status.getStatus().intValue()) {
            message = CosyBundle.message("message.chat.login.ip.whitelist.error", new Object[0]);
        } else if (AuthStateEnum.APP_DISABLED_ERROR.getValue() == status.getStatus().intValue()) {
            message = CosyBundle.message("message.chat.login.app.disabled.error", new Object[0]);
        } else if (CosyConfig.getFeature(BuildFeature.VPC_ENABLED.getKey(), false)) {
            message = CosyBundle.message("message.chat.not.login", new Object[0]);
        } else if (CosyConfig.isQoderEnabled()) {
            message = CosyBundle.message("message.chat.not.login.qoder", new Object[0]);
        } else {
            message = CosyBundle.message("message.chat.not.login.before.options", new Object[0]);
            needLoginOptions = true;
        }
        SystemMessageCard card = new SystemMessageCard(this.project, message);
        if (needLoginOptions) {
            card.addLoginOptions();
        }
        this.flowPanel.add(card);
        this.inputPanel.setState(status);
        ((WelcomeBgPanel)this.flowPanel).setShowTooltips(true);
        this.flowPanel.invalidate();
        this.flowPanel.validate();
        this.flowPanel.repaint();
        this.isAnswering.set(false);
        this.initInput = ChatTaskUtil.getInitInput(this.project, this.getSessionTab());
        if (null != this.chatViewPanel) {
            this.chatViewPanel.clear();
        }
        TelemetryService.getInstance().telemetrySessionId(this.project, TrackEventTypeEnum.CHAT_NEW_SESSION, UUID.randomUUID().toString(), this.initInput.getChatContext().getSessionId(), this.getSessionTypeEnum().getTelemetryType());
    }

    private void handleOpenToolWindow() {
        this.inputPanel.setTextFocus();
    }

    protected void updateUiTexts() {
        this.inputPanel.setTextAreaPlaceholder();
        this.flowPanel.updateUI();
        for (Component component : this.flowPanel.getComponents()) {
            if (!(component instanceof SystemMessageCard)) continue;
            this.flowPanel.remove(component);
            this.showWelcomeInfoPanel();
        }
    }

    public void clearChat(String sessionId, String requestId) {
        this.inputPanel.clearTags();
        this.manualScroll.getAndSet(false);
        this.drawClearContextLine(requestId);
        this.moveScrollToBottom(false);
        ChatSystemEventParam param = ChatSystemEventParam.builder().sessionId(sessionId).requestId(requestId).systemEvent(ChatSystemEventEnum.SESSION_HISTORY_CLEAR.getName()).build();
        ThreadUtil.execute(() -> this.cosyService.chatSystemEvent(this.project, param));
        AuthStatus status = LoginUtil.getAuthStatusCacheFirst(this.project);
        this.inputPanel.setState(status);
        this.archiveChatHistory();
        ChatHistory chatHistory = this.initInput.getChatHistory();
        this.initInput = ChatTaskUtil.getInitInput(this.project, this.getSessionTab());
        this.initInput.getChatContext().setSessionId(sessionId);
        this.initInput.setChatHistory(chatHistory);
        this.inputPanel.setTextFocus();
        ChatSessionUtil.updateRequestId(this.getSessionTypeEnum().getType());
    }

    protected void drawClearContextLine(String requestId) {
        this.drawLineWithMessage("Clear Context", "clearContext", requestId);
    }

    protected void drawLineWithMessage(String message, String panelName, String requestId) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ColorUtil.getAuxiliaryForegroundColor()), message, 2, 0, null, ColorUtil.getAuxiliaryForegroundColor()));
        if (panelName != null && requestId != null) {
            panel.setName(panelName + "_" + requestId);
        }
        this.flowPanel.add(panel);
    }

    protected void drawLineWithKey(String key) {
        String message = CosyBundle.message(key, new Object[0]);
        this.drawLineWithMessage(message, null, null);
    }

    private void archiveChatHistory() {
        List<AskAnswer> toArchive = this.initInput.getChatHistory().getAskAnswerList();
        if (CollectionUtils.isNotEmpty(toArchive)) {
            if (this.initInput.getChatHistory().getArchivedAskAnswerList() == null) {
                this.initInput.getChatHistory().setArchivedAskAnswerList(new ArrayList<AskAnswer>());
            }
            this.initInput.getChatHistory().getArchivedAskAnswerList().addAll(toArchive);
            this.initInput.getChatHistory().setAskAnswerList(new ArrayList<AskAnswer>());
        }
    }

    public void showHelpAnswer() {
        this.inputPanel.clearTags();
        ApplicationManager.getApplication().invokeLater(() -> {
            Object chatContext = ((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)ChatContext.builder().fileLanguage(FileUtil.getLanguageFileType(this.project))).filePath("")).sessionId(this.initInput.getChatContext().getSessionId())).range(null)).methodContent(null)).docContent(null)).sourceCode(null)).inputComplete(false)).build();
            GenerateInput genInput = new GenerateInput(I18NConstant.CHAT_HELP_QUESTION, ChatTaskEnum.CHAT_HELP.getName(), (ChatContext)chatContext);
            ChatAskInput chatAskInput = new ChatAskInput();
            ArrayList<ChatInputElement> elements = new ArrayList<ChatInputElement>();
            ChatInputElement helpTagElement = new ChatInputElement();
            elements.add(helpTagElement);
            helpTagElement.setType("tag");
            helpTagElement.setTag(new TaskChatAskTag(ChatTaskEnum.CHAT_HELP.getName(), "/help"));
            chatAskInput.setChatInputElements(elements);
            genInput.setChatAskInput(chatAskInput);
            this.triggerAsk(genInput, ChatSessionUtil.getRequestId(this.getSessionTypeEnum().getType()));
        });
    }

    protected void triggerAsk(GenerateInput input, String requestId) {
        if (this.project != null && input != null) {
            boolean containsCode;
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.project).getToolWindow(Constants.PLUGIN_NAME);
            if (toolWindow == null) {
                return;
            }
            if (!toolWindow.isVisible()) {
                SearchToolWindowFactory.showToolWindow(this.project);
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.initInput.getChatTask()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)input.getChatTask())) {
                this.initInput.setChatTask(input.getChatTask());
            }
            Object displayText = input.getQuestion();
            boolean isFirstRoundChat = input.getChatHistory() != null && CollectionUtils.isEmpty(input.getChatHistory().getAskAnswerList());
            boolean bl = containsCode = input.getChatContext() != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)input.getChatContext().getSourceCode()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)input.getChatContext().getFilePath());
            if (isFirstRoundChat && containsCode) {
                this.questionCodeWithExt = CodeWithExt.builder().content(input.getChatContext().getSourceCode()).filePath(input.getChatContext().getFilePath()).ext(FileUtil.getPathExt(input.getChatContext().getFilePath())).build();
                displayText = (String)displayText + "\n```" + FileUtil.getPathExt(input.getChatContext().getFilePath()) + "\n" + input.getChatContext().getSourceCode() + "\n```";
            }
            this.prepareAndAsynchronousChat(input, input.getQuestion(), (String)displayText, requestId);
        }
        ChatSessionUtil.updateRequestId(this.getSessionTypeEnum().getType());
    }

    public void prepareAndAsynchronousChat(GenerateInput input, String prompt, String questionText, String requestId) {
        this.isAnswering.set(true);
        boolean isReply = ChatTaskUtil.isReply(input);
        String chatTask = this.getChatTaskForAsynchronousChat(input);
        SwingUtilities.invokeLater(() -> {
            this.prepareAnswer(input, chatTask, questionText, requestId);
            this.asynchronousChat(input, isReply, chatTask, prompt, questionText, requestId);
        });
    }

    protected abstract String getChatTaskForAsynchronousChat(GenerateInput var1);

    public void prepareAnswer(GenerateInput input, String chatTask, String displayText, String requestId) {
        if (this.answerPanel != null) {
            this.answerPanel.hideBottomPanel();
        }
        this.doPrepareAnswer(input, chatTask, displayText, requestId);
    }

    protected void doPrepareAnswer(GenerateInput input, String chatTask, String displayText, String requestId) {
        ChatAskInput chatAskInput = input.getChatAskInput();
        SessionTypeEnum sessionTypeEnum = this.getSessionTypeEnum();
        this.answerPanel = new GenerateAnswerPanel(this.project, this, this.basePanel, chatTask, chatAskInput, sessionTypeEnum);
        String extraTextFormChatContext = this.getExtraTextFormChatContext(input, displayText);
        this.chatQuestionForm = new ChatQuestionForm(this.project, this.basePanel, extraTextFormChatContext, null, chatAskInput, requestId, chatTask, sessionTypeEnum.getType(), this.answerPanel);
        this.flowPanel.add(this.chatQuestionForm.getComponent());
        this.flowPanel.add(this.answerPanel.getComponent());
        this.chatQuestionForm.addDeleteListener(this.flowPanel, this.chatQuestionForm.getComponent(), this.answerPanel.getComponent(), (Computable<Boolean>)((Computable)() -> {
            this.sendStopChatRequest(requestId, true);
            if (this.flowPanel.getComponents() == null || this.flowPanel.getComponents().length == 0) {
                this.showWelcomeInfoPanel();
            } else {
                this.flowPanel.invalidate();
                this.flowPanel.validate();
                this.flowPanel.repaint();
            }
            return true;
        }));
        this.chatQuestionForm.addRestoreListener();
        this.moveScrollToBottom(false);
    }

    private void sendStopChatRequest(String requestId, boolean needUpdateUI) {
        String sessionId = this.answerPanel.getSessionId();
        Long timestamp = (Long)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).get(requestId);
        if (timestamp != null) {
            log.warn("Stop chatting. sessionId=" + sessionId + ", requestId=" + requestId);
            ApplicationManager.getApplication().invokeLater(() -> this.cosyService.chatStop(this.project, ChatStopParam.builder().sessionId(sessionId).requestId(requestId).build()));
            Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(requestId);
            Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(requestId);
            if (needUpdateUI) {
                this.pauseGenerate(requestId, this.answerPanel.getSessionId());
            }
        }
    }

    protected String getExtraTextFormChatContext(GenerateInput input, String originDisplayText) {
        if (input == null || input.getChatAskInput() == null) {
            return originDisplayText;
        }
        Object chatContextObj = ChatContextDtoBuilderFactory.getChatContextDtoBuilder(input.getChatTask()).build(input, originDisplayText);
        if (chatContextObj == null) {
            return originDisplayText;
        }
        String code = null;
        if (chatContextObj instanceof TerminalRelatedDto) {
            code = ((TerminalRelatedDto)chatContextObj).getTerminalContent();
        }
        StringBuilder textBuilder = new StringBuilder();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)code)) {
            textBuilder.append("```\n");
            textBuilder.append(code);
            textBuilder.append("```\n");
        }
        return textBuilder.toString();
    }

    public void asynchronousChat(GenerateInput input, boolean isReply, String chatTask, String prompt, String questionText, String requestId) {
        AskAnswer askAnswer;
        if (input == null || input.getChatContext() == null) {
            return;
        }
        input.setQuestion(prompt);
        Object dto = null;
        if (chatTask != null) {
            dto = ChatContextDtoBuilderFactory.getChatContextDtoBuilder(chatTask).build(input, questionText);
        }
        if (dto == null) {
            log.error("Chat context dto cannot build. Generate input = " + JSON.toJSONString((Object)input));
            return;
        }
        this.manualScroll.getAndSet(false);
        this.hideWelcomeInfoPanel();
        log.debug("Chat context = " + JSONObject.toJSONString((Object)dto));
        questionText = this.fillChatAskInputToQuestText(input, questionText);
        SessionTypeEnum sessionTypeEnum = this.getSessionTypeEnum();
        ChatTaskUtil.configChatTaskExtraModel(this.project, input, sessionTypeEnum.getType());
        ChatAskParam chatAskParam = ChatAskParam.builder().chatTask(chatTask).chatContext(dto).requestId(requestId).isReply(isReply).source(1).sessionId(input.getChatContext().getSessionId() == null ? this.initInput.getChatContext().getSessionId() : input.getChatContext().getSessionId()).codeLanguage(input.getChatContext().getFileLanguage()).questionText(questionText).stream(Boolean.TRUE).taskDefinitionType(input.getTaskDefinitionType()).extra(input.getExtra()).sessionType(sessionTypeEnum.getType()).targetAgent(input.getTargetAgent()).mode(this.answerPanel.getChatMode()).pluginPayloadConfig(new PluginPayloadConfig(this.project)).shellType(CosyKey.PROJECT_SHELL_PATH_MAP.get(this.project.getBasePath())).build();
        if (this.initInput.getChatHistory() == null) {
            this.initInput.setChatHistory(new ChatHistory(new ArrayList<AskAnswer>(), new ArrayList<AskAnswer>()));
        }
        if ((askAnswer = this.recordAskToHistory(requestId, chatTask, input.getQuestion(), dto)) != null) {
            chatAskParam.setChatContext(askAnswer.getQuestionObject());
            chatAskParam.setChatTask(askAnswer.getChatTask());
        }
        this.answerPanel.clearText();
        this.flowPanel.add(this.answerPanel.getComponent());
        this.answerPanel.setRequestId(requestId);
        this.answerPanel.setSessionId(chatAskParam.getSessionId());
        if (this.chatQuestionForm != null) {
            this.chatQuestionForm.setSessionId(chatAskParam.getSessionId());
        }
        final ChatAskParam finalChatAskParam = chatAskParam;
        new Task.Backgroundable(this.project, I18NConstant.GENERATE_TIP){
            private boolean success;
            {
                super(project, title);
                this.success = false;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                BaseChatPanel.this.chatAsk(finalChatAskParam);
                this.success = true;
            }

            public void onFinished() {
                if (this.success) {
                    BaseChatPanel.this.answerPanel.revalidate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/alibabacloud/intellij/qoder/ui/chat/BaseChatPanel$1", "run"));
            }
        }.queue();
        this.scheduleChatTimeout(requestId, input, 30L);
        if (!ChatTaskEnum.CHAT_HELP.getName().equals(chatAskParam.getChatTask())) {
            String placeHolderByTag = ChatAskTagUtil.getPlaceholderByTextArea(this.inputPanel.textArea);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)placeHolderByTag)) {
                this.inputPanel.textArea.setPlaceholder(placeHolderByTag);
            } else {
                this.inputPanel.textArea.setPlaceholder(CosyBundle.message("chat.input.placeholder.normal.continue", new Object[0]));
            }
        }
    }

    public String getChatMode() {
        if (null == this.inputPanel || null == this.inputPanel.getInputOperationPanel() || null == this.inputPanel.getInputOperationPanel().getModeChooser()) {
            return null;
        }
        return ModeService.getInstance().getSelectionModeItem(this.project).getMode();
    }

    protected void hideWelcomeInfoPanel() {
        for (Component component : this.flowPanel.getComponents()) {
            if (!(component instanceof SystemMessageCard)) continue;
            this.flowPanel.remove(component);
        }
        this.inputPanel.setIsHistoryEmpty(false);
        ((WelcomeBgPanel)this.flowPanel).setShowTooltips(false);
    }

    private String fillChatAskInputToQuestText(GenerateInput input, String questionText) {
        String extraTextFormChatContext;
        if (input.getChatAskInput() == null) {
            return questionText;
        }
        StringBuilder displayTextBuilder = new StringBuilder();
        ChatAskInput chatAskInput = input.getChatAskInput();
        if (CollectionUtils.isNotEmpty(chatAskInput.getChatInputElements())) {
            for (ChatInputElement element : chatAskInput.getChatInputElements()) {
                if (element.getType().equals("text")) {
                    displayTextBuilder.append(element.getText());
                    continue;
                }
                if (!element.getType().equals("tag")) continue;
                displayTextBuilder.append(" ").append(element.getTag().getText()).append(" ");
            }
        } else {
            if (CollectionUtils.isNotEmpty(chatAskInput.getTags())) {
                StringBuilder tagStrBuilder = new StringBuilder();
                for (ChatAskTag tag : input.getTags()) {
                    if (tagStrBuilder.length() > 0) {
                        tagStrBuilder.append(" ");
                    }
                    tagStrBuilder.append(tag.getText());
                }
                tagStrBuilder.append(" ");
                displayTextBuilder.append((CharSequence)tagStrBuilder);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)chatAskInput.getText())) {
                displayTextBuilder.append(chatAskInput.getText());
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(extraTextFormChatContext = this.getExtraTextFormChatContext(input, questionText)))) {
            displayTextBuilder.append(extraTextFormChatContext);
        }
        return displayTextBuilder.toString();
    }

    private AskAnswer recordAskToHistory(String requestId, String chatTask, String question, Object questionObject) {
        List<AskAnswer> askAnswerList = this.initInput.getChatHistory().getAskAnswerList();
        if ("<COSY::RETRY>".equals(question) && !askAnswerList.isEmpty()) {
            int toRemove = askAnswerList.size() - 1;
            AskAnswer lastAskAnswer = askAnswerList.remove(toRemove);
            chatTask = ChatTaskEnum.RETRY_TASK.getName();
            question = lastAskAnswer.getQuestion();
            questionObject = lastAskAnswer.getQuestionObject();
        }
        AskAnswer askAnswer = AskAnswer.builder().requestId(requestId).chatTask(chatTask).question(question).questionObject(questionObject).like(0).build();
        if (!askAnswerList.isEmpty() && askAnswerList.get(askAnswerList.size() - 1).getAnswer() == null) {
            askAnswerList.remove(askAnswerList.size() - 1);
        }
        askAnswerList.add(askAnswer);
        return askAnswer;
    }

    private void chatAsk(ChatAskParam chatAskParam) {
        if (ChatTaskEnum.CHAT_HELP.getName().equals(chatAskParam.getChatTask())) {
            String helpTemplate = ThemeUtil.loadHelpContent();
            this.pushGenerate(chatAskParam.getRequestId(), chatAskParam.getSessionId(), helpTemplate, true, false, null, null);
            this.answerPanel.hideBottomPanel();
            this.isAnswering.set(false);
            return;
        }
        if (!Cosy.INSTANCE.checkCosy(this.project, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.pushGenerate(chatAskParam.getRequestId(), chatAskParam.getSessionId(), I18NConstant.COSY_RESTARTING, true, false, null, null);
                this.initInput.getChatHistory().setAskAnswerList(new ArrayList<AskAnswer>());
                this.showFirstTimeRetryQuickAsk(this.initInput, DisplayTask.builder().displayText(I18NConstant.CHAT_ERROR_RETRY_TIPS).displayEnText(I18NConstant.CHAT_ERROR_RETRY_TIPS).prompt(this.initInput.getQuestion()).build());
                this.enableSendButton();
                this.isAnswering.set(false);
            });
            return;
        }
        AuthStatus status = LoginUtil.getAuthStatus(this.project);
        if (status != null && !status.isAllow()) {
            if (this.isNotLogin(status)) {
                log.warn("Not login when chatting, show welcome panel");
                this.showWelcomeInfoPanel(false);
                if (!UserAuthService.getInstance().requireLogin(this.project)) {
                    return;
                }
            }
            String message = AuthStatusUtil.generateAuthMessage(status);
            log.warn("Login status not allowed");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)message)) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.pushGenerate(chatAskParam.getRequestId(), chatAskParam.getSessionId(), message, true, false, null, null);
                    this.showRetryQuickAsk();
                    this.enableSendButton();
                });
            }
            return;
        }
        this.answerPanel.registerStopButton();
        ChatAskResult chatAskResult = this.cosyService.chatAsk(this.project, chatAskParam);
        if (chatAskResult != null) {
            log.info(String.format("chat result = %s %s", chatAskResult.getIsSuccess(), chatAskResult.getStatus()));
        }
    }

    protected void scheduleChatTimeout(String requestId, GenerateInput input, long timeout) {
        SCHEDULED_EXECUTOR.schedule(() -> {
            if (this.answerPanel != null) {
                if (this.answerPanel.getRequestId() != null && !this.answerPanel.getRequestId().equals(requestId)) {
                    log.info("Answer panel request id not equals, skip timeout");
                    return;
                }
                Long timestamp = (Long)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).get(requestId);
                Project project = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(requestId);
                if (project != null && timestamp != null && System.currentTimeMillis() - timestamp > 30000L) {
                    log.info("Plugin chat timeout after 30seconds. sessionId=" + this.answerPanel.getSessionId() + ", requestId=" + this.answerPanel.getRequestId());
                    ApplicationManager.getApplication().invokeLater(() -> this.cosyService.chatStop(project, ChatStopParam.builder().sessionId(this.answerPanel.getSessionId()).requestId(this.answerPanel.getRequestId()).build()));
                    Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(requestId);
                    Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                    Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(requestId);
                    this.isAnswering.set(false);
                    this.flowPanel.remove(this.answerPanel.getComponent());
                    this.drawLineWithKey("line.response.timeout");
                    if (this.initInput.getChatHistory().getAskAnswerList() == null || this.initInput.getChatHistory().getAskAnswerList().size() == 1) {
                        this.initInput.getChatHistory().setAskAnswerList(new ArrayList<AskAnswer>());
                        this.showFirstTimeRetryQuickAsk(input, DisplayTask.builder().displayText(I18NConstant.CHAT_ERROR_RETRY_TIPS).displayEnText(I18NConstant.CHAT_ERROR_RETRY_TIPS).prompt(input.getQuestion()).build());
                    } else {
                        this.showRetryQuickAsk();
                    }
                    this.enableSendButton();
                }
            }
        }, timeout, TimeUnit.SECONDS);
    }

    private void disableSendButton() {
        this.inputPanel.disableSendButton();
    }

    private void showFirstTimeRetryQuickAsk(GenerateInput input, DisplayTask displayTask) {
        List<DisplayTask> displayTasks = Collections.singletonList(displayTask);
        this.answerPanel.showQuickPanel(input, displayTasks);
    }

    public boolean isNotLogin(AuthStatus status) {
        if (status != null) {
            return status.getStatus() == null || status.getStatus().intValue() == AuthStateEnum.NOT_LOGIN.getValue() || status.getStatus().intValue() == AuthStateEnum.LOGIN_EXPIRED.getValue() || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)status.getName());
        }
        return false;
    }

    public abstract String getNewChatText();

    public void scrollToAnswerPanel(String requestId) {
        throw new UnsupportedOperationException();
    }

    public boolean isFirstRoundChatProcessing() {
        boolean noChatHistory = this.initInput.getChatHistory() == null;
        boolean hasNotAsked = this.initInput.getChatHistory() != null && CollectionUtils.isEmpty(this.initInput.getChatHistory().getAskAnswerList());
        boolean askNotAnswered = this.initInput.getChatHistory() != null && CollectionUtils.isNotEmpty(this.initInput.getChatHistory().getAskAnswerList()) && this.initInput.getChatHistory().getAskAnswerList().size() == 1;
        return noChatHistory || hasNotAsked || askNotAnswered;
    }

    public boolean isFirstRoundChatFinished() {
        return this.initInput.getChatHistory() != null && CollectionUtils.isNotEmpty(this.initInput.getChatHistory().getAskAnswerList()) && this.initInput.getChatHistory().getAskAnswerList().size() == 1 && this.initInput.getChatHistory().getAskAnswerList().get(0).getAnswer() != null;
    }

    public String getFirstRoundTask() {
        return this.initInput.getChatTask();
    }

    public void recoverSession(ChatSession chatSession) {
        this.doRecoverSession(chatSession);
        TelemetryService.getInstance().telemetrySessionId(this.project, TrackEventTypeEnum.CHAT_RECOVER_SESSION, UUID.randomUUID().toString(), this.initInput.getChatContext().getSessionId(), this.getSessionTypeEnum().getTelemetryType());
    }

    protected void doRecoverSession(ChatSession chatSession) {
        this.clearProjectToRequest(this.project);
        this.flowPanel.removeAll();
        this.initInput = ChatTaskUtil.getInitInput(this.project, this.getSessionTab());
        ChatHistory chatHistory = new ChatHistory();
        ArrayList<AskAnswer> askAnswerList = new ArrayList<AskAnswer>();
        ArrayList<AskAnswer> toArchive = new ArrayList<AskAnswer>();
        ((WelcomeBgPanel)this.flowPanel).setShowTooltips(false);
        List<ToolCallSyncResult> toolCallInfos = null;
        if (SessionTypeEnum.ASSISTANT.getType().equals(chatSession.getSessionType())) {
            toolCallInfos = this.listToolCallInfo(this.project, chatSession.getSessionId());
        }
        for (ChatRecord chatRecord : chatSession.getChatRecords()) {
            if (ChatSystemEventEnum.SESSION_HISTORY_CLEAR.getName().equalsIgnoreCase(chatRecord.getChatTask())) {
                this.drawClearContextLine(chatRecord.getRequestId());
                toArchive.addAll(askAnswerList);
                askAnswerList = new ArrayList();
                this.inputPanel.setIsHistoryEmpty(true);
                continue;
            }
            ChatAskInput chatAskInput = ChatSessionUtil.getChatAskInputFromRecord(chatRecord, this.project);
            String extraText = ChatSessionUtil.getExtraTextFromRecord(chatRecord);
            GenerateAnswerPanel answerPanel = new GenerateAnswerPanel(this.project, this, this.basePanel, chatRecord.getChatTask(), chatAskInput, this.getSessionTypeEnum());
            answerPanel.setSessionId(chatRecord.getSessionId());
            answerPanel.setRequestId(chatRecord.getRequestId());
            ChatQuestionForm questionForm = new ChatQuestionForm(this.project, this.basePanel, extraText, new Date(chatRecord.getGmtCreate()), chatAskInput, chatRecord.getRequestId(), chatRecord.getChatTask(), this.getSessionTypeEnum().getType(), answerPanel);
            questionForm.setSessionId(chatRecord.getSessionId());
            if (chatRecord.getFilterStatus().equals(FilterStatusEnum.FILTERED.getStatus())) {
                questionForm.showChatFilteredMessage();
            }
            this.flowPanel.add(questionForm.getComponent());
            this.initInput.setChatTask(chatRecord.getChatTask());
            String extra = chatRecord.getExtra();
            JSONObject extraObj = null;
            List testAgentSteps = null;
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)extra)) {
                extraObj = JSON.parseObject((String)extra);
            }
            if (extraObj != null) {
                Object codeChunkObj = extraObj.get((Object)ChatStageParseKey.CODE_CHUNK.getKey());
                ChatReferenceChunk chunk = (ChatReferenceChunk)JSON.parseObject((String)JSON.toJSONString((Object)codeChunkObj), ChatReferenceChunk.class);
                if (chunk != null && CollectionUtils.isNotEmpty(chunk.getChunks())) {
                    DefaultListModel<ChatReferenceItem> listModel = new DefaultListModel<ChatReferenceItem>();
                    for (ChatReferenceItem item : chunk.getChunks()) {
                        item.setType(ChatStageParseKey.CODE_CHUNK.getKey());
                        listModel.addElement(item);
                    }
                    answerPanel.showReferencePanelForRecoverSession(listModel);
                } else {
                    this.recoverTeamDocsChunkFromSession(answerPanel, extraObj);
                }
                if (extraObj.containsKey((Object)"testAgentSteps")) {
                    testAgentSteps = extraObj.getJSONArray("testAgentSteps").toJavaList(ChatStep.class);
                }
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)chatRecord.getReasoningContent())) {
                answerPanel.updateThinkingPanel(chatRecord.getReasoningContent(), true, true, null);
            }
            answerPanel.appendText(chatRecord.getAnswer(), true);
            if (SessionTypeEnum.ASSISTANT.getType().equals(chatSession.getSessionType()) && CollectionUtils.isNotEmpty(toolCallInfos)) {
                this.recoverToolCallListFromSession(answerPanel, toolCallInfos);
            }
            if (IntentionTypeEnum.UNITTEST.getValue().equals(chatRecord.getIntentionType()) && CollectionUtils.isNotEmpty(testAgentSteps)) {
                testAgentSteps.forEach(step -> {
                    step.setStatus(ChatStepStatusEnum.convertToFinalState(step.getStatus()).getKey());
                    answerPanel.addOrUpdateStep((ChatStep)step, true);
                });
            } else if (null != chatRecord.getIntentionType() && !IntentionTypeEnum.CHAT.getValue().equals(chatRecord.getIntentionType()) && extraObj != null) {
                this.recoverFileListFromSession(answerPanel);
            }
            answerPanel.hideBottomPanel();
            answerPanel.renderLike(chatRecord.getLikeStatus());
            answerPanel.endGenerate();
            this.flowPanel.add(answerPanel.getComponent());
            questionForm.addDeleteListener(this.flowPanel, questionForm.getComponent(), answerPanel.getComponent(), (Computable<Boolean>)((Computable)() -> {
                if (this.flowPanel.getComponents() == null || this.flowPanel.getComponents().length == 0) {
                    this.showWelcomeInfoPanel();
                } else {
                    this.flowPanel.invalidate();
                    this.flowPanel.validate();
                    this.flowPanel.repaint();
                }
                return true;
            }));
            questionForm.addRestoreListener();
            this.inputPanel.setIsHistoryEmpty(false);
            askAnswerList.add(AskAnswer.builder().chatTask(chatRecord.getChatTask()).questionObject(chatRecord.getChatContext()).question(chatRecord.getQuestion()).answer(chatRecord.getAnswer()).like(chatRecord.getLikeStatus()).build());
        }
        this.flowPanel.invalidate();
        this.flowPanel.validate();
        this.flowPanel.repaint();
        chatHistory.setArchivedAskAnswerList(toArchive);
        chatHistory.setAskAnswerList(askAnswerList);
        this.initInput.setChatHistory(chatHistory);
        Object chatContext = ((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)ChatContext.builder().sessionId(chatSession.getSessionId())).fileLanguage(FileUtil.getLanguageFileType(this.project))).localeLanguage(Locale.getDefault().getLanguage())).build();
        this.initInput.setChatContext((ChatContext)chatContext);
        this.isAnswering.set(false);
    }

    protected void recoverFileListFromSession(GenerateAnswerPanel answerPanel) {
        throw new UnsupportedOperationException();
    }

    protected void recoverToolCallListFromSession(GenerateAnswerPanel answerPanel, List<ToolCallSyncResult> toolCallInfos) {
        throw new UnsupportedOperationException();
    }

    protected void clearProjectToRequest(Project project) {
        Map requestToSessionTypeMap = (Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_SESSION_TYPE);
        if (!CosyKey.PROJECT_TO_REQUEST.isEmpty() && !CosyKey.PROJECT_TO_REQUEST.containsKey(project.getName())) {
            Set<String> requestIdSet = CosyKey.PROJECT_TO_REQUEST.get(project.getName());
            if (requestIdSet == null) {
                CosyKey.PROJECT_TO_REQUEST.put(project.getName(), new HashSet());
                return;
            }
            for (String requestId : requestIdSet) {
                if (ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT) == null || !Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).containsKey(requestId)) continue;
                if (requestToSessionTypeMap != null) {
                    String sessionType = (String)requestToSessionTypeMap.get(requestId);
                    if (!this.getSessionTypeEnum().getType().equals(sessionType)) continue;
                }
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(requestId);
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(requestId);
            }
        }
    }

    private void recoverTeamDocsChunkFromSession(GenerateAnswerPanel answerPanel, JSONObject extraObj) {
        Object teamDocsObj = extraObj.get((Object)"team_docs");
        ChatReferenceTeamDocsHistory teamDocsHistory = (ChatReferenceTeamDocsHistory)JSON.parseObject((String)JSON.toJSONString((Object)teamDocsObj), ChatReferenceTeamDocsHistory.class);
        if (teamDocsHistory == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty(teamDocsHistory.getDocuments())) {
            DefaultListModel<ChatReferenceItem> listModel = ChatReferenceParser.transferDocItemToReferenceItem(teamDocsHistory.getDocuments());
            answerPanel.showReferencePanelForRecoverSession(listModel);
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)teamDocsHistory.getMessage())) {
            answerPanel.showReferencePanelMessageForRecoverSession(teamDocsHistory.getMessage());
        }
    }

    public abstract void createNewTask(QoderToolWindowPanel var1, Point var2);

    public void createNewTaskDirectly(QoderToolWindowPanel toolPanel) {
        toolPanel.switchChatPanel(this);
        this.initFlowPanel();
    }

    public void initFlowPanel() {
        this.clearProjectToRequest(this.project);
        this.enableInputPanel();
        this.enableSendButton();
        this.showWelcomeInfoPanel(true);
        this.inputPanel.clearTextArea();
        this.inputPanel.clearTags();
        this.isAnswering.set(false);
    }

    private List<ToolCallSyncResult> listToolCallInfo(Project project, String sessionId) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sessionId)) {
            return null;
        }
        if (!Cosy.INSTANCE.checkCosy(project)) {
            return null;
        }
        return Cosy.INSTANCE.getLanguageService(project).listToolCallInfo(sessionId, 10000L);
    }

    protected void anyGenerate(SearchContext context, GenerateInput input, String requestId, Boolean clearContext) {
        if (input.getChatContext() == null) {
            log.warn("generate context is null");
            return;
        }
        if (!this.inputPanel.isSendEnabled()) {
            NotificationFactory.showInfoNotification(this.project, CosyBundle.message("notifications.ask.when.generating", new Object[0]));
            return;
        }
        ((QoderTabChangeNotifier)this.project.getMessageBus().syncPublisher(QoderTabChangeNotifier.CHANGE_MAIN_TAB_NOTIFICATION)).changeTab(this.getSessionTab());
        if (BooleanUtils.isTrue((Boolean)clearContext) && CollectionUtils.isNotEmpty(this.initInput.getChatHistory().getAskAnswerList())) {
            this.clearChat(this.initInput.getChatContext().getSessionId(), UUID.randomUUID().toString());
        } else {
            this.inputPanel.clearTags();
        }
        this.recordSelectionCode(this.project);
        if (CollectionUtils.isEmpty(input.getTags())) {
            String text = InputConstants.CHAT_TASK_QUERY_MAP.get(input.getChatTask());
            if (text != null) {
                this.inputPanel.resetRecentQueryIndex();
            }
        } else {
            this.inputPanel.resetRecentQueryIndex();
        }
        this.triggerAsk(input, requestId);
    }

    protected String recordSelectionCode(Project project) {
        Editor editor = EditorUtil.getSelectedEditorSafely(project);
        if (editor != null && editor.getSelectionModel().getSelectedText() != null) {
            SelectionModel selectionModel = editor.getSelectionModel();
            String code = selectionModel.getSelectedText();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)code)) {
                return null;
            }
            String projectName = project.getName();
            HashMap<String, String> map = (HashMap<String, String>)ApplicationManager.getApplication().getUserData(CosyKey.PROJECT_FREE_INPUT_SELECTION_CODE_MAP);
            if (map == null) {
                map = new HashMap<String, String>();
                map.put(projectName, code);
                ApplicationManager.getApplication().putUserData(CosyKey.PROJECT_FREE_INPUT_SELECTION_CODE_MAP, map);
            } else if (!map.containsKey(projectName)) {
                map.put(projectName, code);
            } else {
                map.put(projectName, code);
            }
            return code;
        }
        return null;
    }

    protected String getActionId(List<ChatAskTag> tags) {
        List taskTagList;
        String actionId = null;
        if (CollectionUtils.isNotEmpty(tags) && CollectionUtils.isNotEmpty(taskTagList = tags.stream().filter(tag -> tag.getType().equals("task")).collect(Collectors.toList())) && (actionId = InputConstants.TASK_SLASH_ACTION_MAP.get(((ChatAskTag)taskTagList.get(0)).getText())) == null) {
            actionId = ActionConstants.TRIGGER_COSY_CUSTOM_COMMAND_ACTION;
        }
        return actionId;
    }

    protected void processEnterKey(String text) {
        List<ChatInputElement> elements = ChatTaskUtil.convertTextToElements(this.inputPanel.getTextArea());
        List<ChatAskTag> tags = ChatTaskUtil.getTagsByElements(elements);
        List<ChatContextTag> contextTags = this.inputPanel.inputTagsPanel.getTags();
        if (CollectionUtils.isEmpty(elements)) {
            this.inputPanel.clearTextArea();
            this.inputPanel.clearTags();
            return;
        }
        SuggestPromptPopupPanel suggestPromptPopupPanel = this.inputPanel.getChatInputSuggester().getSuggestPromptPopupPanel();
        SuggestPrompt suggestPrompt = suggestPromptPopupPanel.chooseSuggestPromptSelection();
        if (suggestPrompt != null) {
            if (suggestPrompt.isEnabled()) {
                suggestPromptPopupPanel.triggerChooseSuggestPrompt(suggestPrompt);
            }
            return;
        }
        if (!this.inputPanel.isSendEnabled()) {
            log.info("send button is not enabled");
            NotificationFactory.showToast((JComponent)this.inputPanel.getInputOperationPanel().getSendLabel(), MessageType.INFO, CosyBundle.message("notifications.send.button.answering", new Object[0]));
            return;
        }
        this.inputPanel.clearAfterSent();
        ChatAskInput chatAskInput = new ChatAskInput();
        chatAskInput.setChatInputElements(elements);
        chatAskInput.setContextTags(contextTags);
        String actionId = this.getActionId(tags);
        if (this.isAnswering.get()) {
            this.chatViewPanel.getMessageQueuePanel().offerMessage(new ChatMessageQueuePanel.ChatMessageItem(text, actionId, tags, chatAskInput));
        } else {
            this.triggerAskWithActionId(text, actionId, tags, chatAskInput);
        }
    }

    protected void triggerAskWithActionId(String text, String actionId, List<ChatAskTag> tags, ChatAskInput chatAskInput) {
    }

    private void newFile(String content, String markdownLanguage, CodeWithExt questionCodeWithExt, Boolean isTestcase, SessionTypeEnum sessionType) {
        if (sessionType == this.getSessionTypeEnum()) {
            String ext = LanguageUtil.guessExtensionByMarkdownLanguage(markdownLanguage);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ext) && questionCodeWithExt != null) {
                ext = questionCodeWithExt.getExt();
            }
            String sourceFilePath = null;
            if (questionCodeWithExt != null) {
                sourceFilePath = questionCodeWithExt.getFilePath();
            }
            NewFileAction newFileAction = new NewFileAction(this.project, content, isTestcase, ext, sourceFilePath);
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.basePanel);
            newFileAction.actionPerformed(new AnActionEvent(null, dataContext, "EditorPopup", new Presentation(), ActionManager.getInstance(), 0));
        }
    }

    private void showDiff(String answerCode, String markdownLanguage, CodeWithExt questionCodeWithExt, SessionTypeEnum sessionType) {
        if (sessionType == this.getSessionTypeEnum()) {
            String ext = LanguageUtil.guessExtensionByMarkdownLanguage(markdownLanguage);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ext) && questionCodeWithExt != null) {
                ext = questionCodeWithExt.getExt();
            }
            String sourceFilePath = null;
            String sourceContent = "";
            if (questionCodeWithExt != null) {
                sourceFilePath = questionCodeWithExt.getFilePath();
                sourceContent = questionCodeWithExt.getContent();
            }
            ShowDiffAction showDiffAction = new ShowDiffAction(this.project, sourceContent, answerCode, ext, sourceFilePath);
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.basePanel);
            showDiffAction.actionPerformed(new AnActionEvent(null, dataContext, "EditorPopup", new Presentation(), ActionManager.getInstance(), 0));
        }
    }

    public void stopSessionChat() {
        Long answeringRequest;
        Map map;
        if (this.answerPanel != null && this.answerPanel.getRequestId() != null && (map = (Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)) != null && (answeringRequest = (Long)map.get(this.answerPanel.getRequestId())) != null) {
            this.answerPanel.stopChat();
        }
        if (this.answerPanel != null && this.answerPanel.getSessionId() != null) {
            StopSessionParam param = StopSessionParam.builder().sessionId(this.answerPanel.getSessionId()).build();
            ApplicationManager.getApplication().invokeLater(() -> this.cosyService.stopSession(this.project, param));
        }
    }

    public void stopSessionChatSync() {
        Long answeringRequest;
        if (this.answerPanel != null && this.answerPanel.getRequestId() != null && (answeringRequest = (Long)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).get(this.answerPanel.getRequestId())) != null) {
            this.answerPanel.stopChatSync();
        }
        if (this.answerPanel != null && this.answerPanel.getSessionId() != null) {
            StopSessionParam param = StopSessionParam.builder().sessionId(this.answerPanel.getSessionId()).build();
            this.cosyService.stopSession(this.project, param);
        }
    }

    public void reloadTodoViewPanel(List<TaskItem> taskItems) {
    }

    public void summaryTodoViewPanel() {
    }

    @Generated
    public JPanel getBasePanel() {
        return this.basePanel;
    }

    @Generated
    public GenerateAnswerPanel getAnswerPanel() {
        return this.answerPanel;
    }

    @Generated
    public GenerateInput getInitInput() {
        return this.initInput;
    }

    @Generated
    public CosyService getCosyService() {
        return this.cosyService;
    }

    @Generated
    public AskInputPanel getInputPanel() {
        return this.inputPanel;
    }

    @Generated
    public CodeWithExt getQuestionCodeWithExt() {
        return this.questionCodeWithExt;
    }

    @Generated
    public String getSessionType() {
        return this.sessionType;
    }

    @Generated
    public WorkingSpacePanel getWorkingSpacePanel() {
        return this.workingSpacePanel;
    }
}

