/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.chat.inline;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.chat.enums.ChatTaskEnum;
import com.alibabacloud.intellij.qoder.chat.factory.ChatContextDtoBuilderFactory;
import com.alibabacloud.intellij.qoder.chat.model.AskAnswer;
import com.alibabacloud.intellij.qoder.chat.model.ChatAskInput;
import com.alibabacloud.intellij.qoder.chat.model.ChatAskParam;
import com.alibabacloud.intellij.qoder.chat.model.ChatContext;
import com.alibabacloud.intellij.qoder.chat.model.ChatHistory;
import com.alibabacloud.intellij.qoder.chat.model.ChatStopParam;
import com.alibabacloud.intellij.qoder.chat.model.result.ChatAskResult;
import com.alibabacloud.intellij.qoder.constants.CosyKey;
import com.alibabacloud.intellij.qoder.constants.QoderUrls;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.AuthStatus;
import com.alibabacloud.intellij.qoder.core.lsp.model.model.InlineChatModeItem;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.search.enums.TrackEventTypeEnum;
import com.alibabacloud.intellij.qoder.service.TelemetryService;
import com.alibabacloud.intellij.qoder.service.UserAuthService;
import com.alibabacloud.intellij.qoder.ui.chat.BaseChatPanel;
import com.alibabacloud.intellij.qoder.ui.chat.inline.InlineChatAnswerPanel;
import com.alibabacloud.intellij.qoder.ui.chat.inline.InlineChatButtonStateEnum;
import com.alibabacloud.intellij.qoder.ui.chat.inline.InlineChatInputPanel;
import com.alibabacloud.intellij.qoder.ui.chat.inline.InlineChatQuestion;
import com.alibabacloud.intellij.qoder.ui.diff.ComponentInlayAlignment;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.ComponentInlayKt;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.InEditorDiffRenderer;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.InlayProperties;
import com.alibabacloud.intellij.qoder.ui.ineditordiff.util.CodeBlockFinder;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.QoderToolWindowPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectLabel;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.WelcomeBgPanel;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.ChatModelChooser;
import com.alibabacloud.intellij.qoder.ui.search.component.chat.chooser.InlineChatModeChooser;
import com.alibabacloud.intellij.qoder.ui.search.component.tool.result.BaseToolCallHandler;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatMode;
import com.alibabacloud.intellij.qoder.ui.search.enums.InlineChatMode;
import com.alibabacloud.intellij.qoder.ui.search.enums.SessionTypeEnum;
import com.alibabacloud.intellij.qoder.ui.search.generate.AskInputPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.SuggestPromptPopupPanel;
import com.alibabacloud.intellij.qoder.ui.search.generate.input.ChatInputTextArea;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.model.ActiveFileInfo;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatContextTag;
import com.alibabacloud.intellij.qoder.ui.search.model.ChatInputElement;
import com.alibabacloud.intellij.qoder.ui.search.model.GenerateInput;
import com.alibabacloud.intellij.qoder.ui.search.model.SuggestPrompt;
import com.alibabacloud.intellij.qoder.ui.search.model.tag.ChatAskTag;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLoginNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.AuthLogoutNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.InlineChatGenerateStepCallbackNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.InlineChatStreamPauseNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.InlineChatStreamPushNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.InlineChatStreamStopNotifier;
import com.alibabacloud.intellij.qoder.ui.search.topic.InlineChatThinkingStreamPushNotifier;
import com.alibabacloud.intellij.qoder.util.AuthStatusUtil;
import com.alibabacloud.intellij.qoder.util.ChatAskTagUtil;
import com.alibabacloud.intellij.qoder.util.ChatSessionUtil;
import com.alibabacloud.intellij.qoder.util.ChatTaskUtil;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.ComponentUtil;
import com.alibabacloud.intellij.qoder.util.CosyKeymapUtil;
import com.alibabacloud.intellij.qoder.util.DocumentUtils;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.ErrorMessageHandler;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.LoginUtil;
import com.alibabacloud.intellij.qoder.util.RecentQueryUtil;
import com.alibabacloud.intellij.qoder.util.StringUtils;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;

public class InlineChatPanel
extends BaseChatPanel {
    public static final String INLINE_TAB = "InlineTab";
    private static final Logger log = Logger.getInstance(InlineChatPanel.class);
    private static final int DEFAULT_MAX_VISIBLE_WIDTH = 1000;
    private static final int ANSWER_DEFAULT_MAX_HEIGHT = 480;
    private static final int INLINE_CHAT_MAX_FILE_LENGTH = 1000000;
    public static final int INLINE_CHAT_PANEL_DEFAULT_CORNER_RADIUS = 16;
    public static final int INLINE_CHAT_INPUT_PANEL_DEFAULT_CORNER_RADIUS = 8;
    private Editor editor;
    private Box changeOperationPanel;
    private RoundRectLabel acceptButton;
    private RoundRectLabel rejectButton;
    private StringBuffer answerText;
    private String chatMode;
    private final AtomicBoolean panelClosed = new AtomicBoolean(true);
    private InEditorDiffRenderer currentDiffRenderer;
    private Inlay<?> currentInlay;
    private JPanel inlineChatInputPanel;
    private JPanel chatOperationPanel;
    protected InlineChatQuestion inlineChatQuestion;
    protected int currentSelectStartLine;
    protected int currentSelectEndLine;
    private String selectedText;
    private String requestId;
    private InlineChatButtonStateEnum buttonState;
    private RangeHighlighter rangeHighlighter;
    ChatContext chatContext;
    private JLabel generatingLabel;
    JPanel chatOperationLeftPanel;
    JPanel chatOperationRightPanel;
    JLabel chatCloseLabel;
    InlineChatModeChooser modeChooser;
    JComponent selectedModelComponent;
    KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
    KeyStroke altEnterKeyStroke = KeyStroke.getKeyStroke(10, 512);
    KeyStroke cmdShiftEnterKeyStroke = SystemInfo.isMac ? CosyKeymapUtil.getKeyStroke(10, 256, 64) : CosyKeymapUtil.getKeyStroke(10, 128, 64);
    private final AtomicBoolean editFinished = new AtomicBoolean(false);
    GenerateInput retryInput;
    private DocumentListener documentListener;
    private JPanel collapsePanel;
    private JLabel collapseLabel;
    private final AtomicBoolean isCollapsed = new AtomicBoolean(false);
    public static final String KEY_COMPONENT_MODE = "KEY_COMPONENT_MODE";
    public static final String KEY_COMPONENT_TYPE = "KEY_COMPONENT_TYPE";
    public static final String VALUE_COMPONENT_TYPE_QUESTION = "question";
    public static final String VALUE_COMPONENT_TYPE_ANSWER = "answer";
    private boolean isDragging = false;
    private Point lastMousePosition;
    private MouseAdapter panelDragAdapter;
    private JComponent floatingPanel;
    private boolean isFloatingMode = false;
    private Point floatingPanelPosition;

    private InlineChatPanel(Project project, Editor editor) {
        super(project);
        this.editor = editor;
        this.chatContext = ((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)ChatContext.builder().sessionId(UUID.randomUUID().toString())).fileLanguage(FileUtil.getLanguageFileType(project))).build();
        this.configChatOperationPanel();
        this.configInlineChatInputPanel();
        this.configBasePanel();
        this.configFlowPanelUI();
    }

    @Override
    protected void initBasePanel() {
        this.basePanel = new RoundRectPanel(new BorderLayout(), 16){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Dimension scrollSize = InlineChatPanel.this.scrollPane.getPreferredSize();
                Dimension chatInputSize = InlineChatPanel.this.inlineChatInputPanel.getPreferredSize();
                int basePanelTopAndBottomBorder = 24;
                size.height = scrollSize.height == 16 ? chatInputSize.height + basePanelTopAndBottomBorder : scrollSize.height + chatInputSize.height + basePanelTopAndBottomBorder;
                return size;
            }
        };
        this.basePanel.setBorder((Border)JBUI.Borders.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createInlineChatPanel(Project project, Editor editor) {
        Class<InlineChatPanel> clazz = InlineChatPanel.class;
        synchronized (InlineChatPanel.class) {
            InlineChatPanel instance = (InlineChatPanel)editor.getUserData(CosyKey.INLINE_CHAT_PANEL_KEY);
            if (instance != null) {
                instance.removePanel();
            }
            instance = new InlineChatPanel(project, editor);
            instance.reset(project, editor, true);
            instance.insertPanel();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void configFlowPanelUI() {
        this.flowPanel.setLayout((LayoutManager)new VerticalFlowLayout(2, 0, 8, true, false));
        this.flowPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    private void configChatOperationPanel() {
        this.configChatOperationLeftPanel();
        this.configChatOperationRightPanel();
        this.chatOperationPanel = new RoundRectPanel((LayoutManager)new BorderLayout(), 16);
        this.chatOperationPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.chatOperationPanel.add((Component)this.chatOperationLeftPanel, "West");
        this.chatOperationPanel.add((Component)this.chatOperationRightPanel, "East");
        this.setBottomPanelToState(InlineChatButtonStateEnum.INIT);
    }

    private void configBasePanel() {
        this.basePanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)12, (int)4));
        this.basePanel.add((Component)this.inlineChatInputPanel, "South");
        this.basePanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                InlineChatPanel.this.updateScrollPaneSize();
                if (!InlineChatPanel.this.manualScroll.get()) {
                    InlineChatPanel.this.moveScrollToBottom(false);
                }
            }
        });
        this.basePanel.setFocusable(true);
        this.basePanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
    }

    private void setupPanelDragListeners() {
        this.panelDragAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    InlineChatPanel.this.isDragging = true;
                    InlineChatPanel.this.lastMousePosition = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), InlineChatPanel.this.editor.getContentComponent());
                    InlineChatPanel.this.basePanel.setCursor(Cursor.getPredefinedCursor(13));
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (InlineChatPanel.this.isDragging) {
                    InlineChatPanel.this.isDragging = false;
                    Point editorPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), InlineChatPanel.this.editor.getContentComponent());
                    InlineChatPanel.this.finalizePanelPosition(editorPoint);
                    InlineChatPanel.this.basePanel.setCursor(Cursor.getDefaultCursor());
                    e.consume();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (InlineChatPanel.this.isDragging) {
                    Point currentPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), InlineChatPanel.this.editor.getContentComponent());
                    if (InlineChatPanel.this.isFloatingMode) {
                        InlineChatPanel.this.updateFloatingPosition(currentPoint);
                    } else {
                        InlineChatPanel.this.switchToFloatingMode(currentPoint);
                    }
                    InlineChatPanel.this.lastMousePosition = currentPoint;
                    e.consume();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!InlineChatPanel.this.isDragging) {
                    InlineChatPanel.this.basePanel.setCursor(Cursor.getPredefinedCursor(13));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!InlineChatPanel.this.isDragging) {
                    InlineChatPanel.this.basePanel.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        this.addDragListenersToComponent(this.floatingPanel);
    }

    public void switchToFloatingMode() {
        this.removeMarkSelectTextRange();
        this.switchToFloatingMode(this.getInitPosition());
        this.setupPanelDragListeners();
        this.inputPanel.getTextArea().requestFocus();
    }

    private void switchToFloatingMode(Point mousePosition) {
        try {
            if (this.currentInlay != null) {
                try {
                    Disposer.dispose(this.currentInlay);
                }
                catch (Exception e) {
                    log.warn("Error disposing current inlay", (Throwable)e);
                }
                this.currentInlay = null;
            }
            this.floatingPanel = this.wrapToComponent();
            this.floatingPanelPosition = new Point(mousePosition.x, mousePosition.y);
            JRootPane rootPane = SwingUtilities.getRootPane(this.editor.getContentComponent());
            if (null == rootPane) {
                log.warn("rootPane is null, ignore switch");
                return;
            }
            JLayeredPane layeredPane = rootPane.getLayeredPane();
            Point editorLocationInLayeredPane = SwingUtilities.convertPoint(this.editor.getContentComponent(), mousePosition, layeredPane);
            int layeredX = editorLocationInLayeredPane.x;
            int layeredY = editorLocationInLayeredPane.y;
            Dimension preferredSize = this.floatingPanel.getPreferredSize();
            this.floatingPanel.setBounds(layeredX, layeredY, preferredSize.width, preferredSize.height);
            this.floatingPanelPosition.setLocation(layeredX, layeredY);
            layeredPane.add((Component)this.floatingPanel, JLayeredPane.POPUP_LAYER);
            this.isFloatingMode = true;
        }
        catch (Exception e) {
            log.warn("Error switching to floating mode", (Throwable)e);
            this.isFloatingMode = false;
            this.restoreToOriginalPosition();
        }
    }

    private void updateFloatingPosition(Point mousePosition) {
        if (this.floatingPanel != null && this.isFloatingMode) {
            try {
                int deltaX = mousePosition.x - this.lastMousePosition.x;
                int deltaY = mousePosition.y - this.lastMousePosition.y;
                int newX = this.floatingPanelPosition.x + deltaX;
                int newY = this.floatingPanelPosition.y + deltaY;
                JRootPane rootPane = SwingUtilities.getRootPane(this.editor.getContentComponent());
                if (null == rootPane) {
                    log.warn("rootPane is null, ignore update");
                    return;
                }
                JLayeredPane layeredPane = rootPane.getLayeredPane();
                JComponent editorComponent = this.editor.getContentComponent();
                Rectangle editorVisibleRect = editorComponent.getVisibleRect();
                int verticalScrollbarWidth = 0;
                int horizontalScrollbarHeight = 0;
                if (this.editor instanceof EditorImpl) {
                    JScrollBar horizontalScrollBar;
                    JScrollPane scrollPane = ((EditorImpl)this.editor).getScrollPane();
                    JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
                    if (verticalScrollBar != null && verticalScrollBar.isVisible()) {
                        verticalScrollbarWidth = verticalScrollBar.getWidth();
                    }
                    if ((horizontalScrollBar = scrollPane.getHorizontalScrollBar()) != null && horizontalScrollBar.isVisible()) {
                        horizontalScrollbarHeight = horizontalScrollBar.getHeight();
                    }
                }
                int contentWidth = editorVisibleRect.width - verticalScrollbarWidth;
                int contentHeight = editorVisibleRect.height - horizontalScrollbarHeight;
                Point editorTopLeft = SwingUtilities.convertPoint(editorComponent, new Point(editorVisibleRect.x, editorVisibleRect.y), layeredPane);
                Point editorBottomRight = SwingUtilities.convertPoint(editorComponent, new Point(editorVisibleRect.x + contentWidth, editorVisibleRect.y + contentHeight), layeredPane);
                Dimension panelSize = this.floatingPanel.getSize();
                if (newX < editorTopLeft.x) {
                    newX = editorTopLeft.x;
                }
                if (newX + panelSize.width > editorBottomRight.x) {
                    newX = editorBottomRight.x - panelSize.width;
                }
                if (newY < editorTopLeft.y) {
                    newY = editorTopLeft.y;
                }
                if (newY + panelSize.height > editorBottomRight.y) {
                    newY = editorBottomRight.y - panelSize.height;
                }
                newX = Math.max(editorTopLeft.x, newX);
                newY = Math.max(editorTopLeft.y, newY);
                this.floatingPanel.setLocation(newX, newY);
                this.floatingPanelPosition.setLocation(newX, newY);
                this.lastMousePosition = mousePosition;
            }
            catch (Exception e) {
                log.warn("Failed to update floating panel position", (Throwable)e);
            }
        }
    }

    private void finalizePanelPosition(Point mousePosition) {
        if (this.isFloatingMode && this.floatingPanel != null) {
            try {
                this.updateFloatingPosition(mousePosition);
            }
            catch (Exception e) {
                log.warn("Error finalizing panel position", (Throwable)e);
                this.restoreToOriginalPosition();
            }
        }
    }

    public void insertFloatingPanel(Point initialPosition) {
        this.panelClosed.set(false);
        try {
            this.switchToFloatingMode(initialPosition);
        }
        catch (Exception e) {
            log.warn("Error creating floating panel", (Throwable)e);
            this.isFloatingMode = false;
        }
    }

    private void addDragListenersToComponent(JComponent component) {
        SwingUtil.foreachChildComponent(component, cp -> {
            if (!(cp instanceof ChatInputTextArea)) {
                cp.addMouseListener(this.panelDragAdapter);
                cp.addMouseMotionListener(this.panelDragAdapter);
            }
        });
    }

    private void restoreToOriginalPosition() {
        try {
            int originalOffset = this.editor.getDocument().getLineStartOffset(this.currentSelectStartLine);
            InlayProperties properties = new InlayProperties().showAbove(true);
            properties.priority(0);
            JComponent wrapToComponent = this.wrapToComponent();
            this.currentInlay = ComponentInlayKt.addComponentInlay(this.editor, originalOffset, properties, wrapToComponent, ComponentInlayAlignment.COMPONENT_WIDTH_ONLY);
            if (this.currentInlay != null) {
                this.scrollToInlayPosition();
            }
        }
        catch (Exception e) {
            log.error("Failed to restore panel to original position", (Throwable)e);
        }
    }

    public Point getInitPosition() {
        Rectangle visibleArea = this.editor.getScrollingModel().getVisibleArea();
        int centerX = visibleArea.width / 2 - this.basePanel.getPreferredSize().width / 2;
        int bottomY = visibleArea.height - 160;
        return new Point(centerX + visibleArea.x, bottomY + visibleArea.y);
    }

    private void configChatOperationLeftPanel() {
        this.chatOperationLeftPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.chatOperationLeftPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        ChatModelChooser modelChooser = new ChatModelChooser(this.project, this.getSessionType(), ColorUtil.getToolWindowBackgroundColor(), ColorUtil.getAuxiliaryForegroundColor(), ColorUtil.getToolWindowBackgroundColor());
        this.selectedModelComponent = modelChooser.getBaseComponent();
        this.modeChooser = new InlineChatModeChooser(this.project, this.inputPanel);
        this.chatOperationLeftPanel.add(this.selectedModelComponent);
        this.selectedModelComponent.setVisible(false);
        this.modeChooser.getBaseComponent().setVisible(false);
        this.chatOperationLeftPanel.add(this.modeChooser.getBaseComponent());
        JLabel label = new JLabel(CosyBundle.message("inline.chat.mode.edit.in.selection.no.shortcut", new Object[0]));
        label.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        label.setBackground(ColorUtil.getToolWindowBackgroundColor());
        label.setFont(label.getFont().deriveFont(12.0f));
        this.chatOperationLeftPanel.add(label);
    }

    private void configChatOperationRightPanel() {
        this.configChangeOperationPanel();
        this.initChatOperationRightPanelComponents();
        this.configChatOperationRightPanelUI();
    }

    private void initChatOperationRightPanelComponents() {
        this.generatingLabel = new JLabel();
        this.generatingLabel.setIcon(QoderIcons.StatusBarLoadingIcon);
        this.generatingLabel.setText(CosyBundle.message("statusbar.state.generating", new Object[0]));
        this.generatingLabel.setFont(this.generatingLabel.getFont().deriveFont(12.0f));
        this.generatingLabel.setBorder((Border)JBUI.Borders.empty());
        this.generatingLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        String chatCloseText = String.format("%s %s", CosyKeymapUtil.getEscKeyText(), CosyBundle.message("inline.chat.close.text", new Object[0]));
        this.chatCloseLabel = ComponentUtil.createRoundRectLabel(chatCloseText, ColorUtil.getToolWindowBackgroundColor(), null, ColorUtil.getTextForegroundColor(), 0, null, 8, 3, 8, 0);
        this.chatCloseLabel.setFont(this.chatCloseLabel.getFont().deriveFont(12.0f));
        this.chatCloseLabel.setBorder((Border)JBUI.Borders.empty());
        this.chatCloseLabel.setEnabled(false);
        this.chatCloseLabel.setOpaque(false);
    }

    private void configChatOperationRightPanelUI() {
        this.chatOperationRightPanel = new JPanel();
        this.chatOperationRightPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.chatOperationRightPanel.setLayout(new BoxLayout(this.chatOperationRightPanel, 0));
        this.chatOperationRightPanel.add(this.chatCloseLabel);
        this.chatOperationRightPanel.add(this.generatingLabel);
        this.chatOperationRightPanel.add(this.changeOperationPanel);
    }

    private void handleButtonClick(String chatMode) {
        String text = this.inputPanel.getTextArea().getText();
        String chatTask = ChatTaskEnum.INLINE_CHAT.getName();
        for (ChatAskTag tag : this.inputPanel.getTags()) {
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)ChatTaskEnum.OPTIMIZE_CODE.getName(), (CharSequence)tag.getId())) {
                chatTask = ChatTaskEnum.OPTIMIZE_CODE.getName();
                break;
            }
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)ChatTaskEnum.CODE_GENERATE_COMMENT.getName(), (CharSequence)tag.getId())) continue;
            chatTask = ChatTaskEnum.CODE_GENERATE_COMMENT.getName();
            break;
        }
        this.chatMode = chatMode;
        if (this.editor != null) {
            ActiveFileInfo activeFileInfo = ActiveFileInfo.getFromEditor(this.editor);
            activeFileInfo.setStatLine(this.currentSelectStartLine + 1);
            activeFileInfo.setEndLine(this.currentSelectEndLine + 1);
            activeFileInfo.setSelectedCode(this.selectedText);
            ChatContextTag chatContextTag = ChatContextTag.buildFromActiveFileInfoForInline(activeFileInfo);
            if (chatContextTag != null && (activeFileInfo.getFileProtocol().equals("jar") || activeFileInfo.getFilePath().endsWith(".java") || activeFileInfo.getFilePath().endsWith(".class"))) {
                Map<String, Object> extra = chatContextTag.getExtra();
                String fullContent = (String)ReadAction.compute(() -> {
                    String content = this.editor.getDocument().getText();
                    return content.length() > 1000000 ? content.substring(0, 1000000) : content;
                });
                extra.put("fullContent", fullContent);
            }
            this.inputPanel.getInputTagsPanel().addOrUpdateTag(1, chatContextTag, AskInputPanel.compareContextTag(true, false));
        }
        List<ChatInputElement> elements = ChatTaskUtil.convertTextToElements(this.inputPanel.getTextArea());
        ChatAskInput chatAskInput = new ChatAskInput();
        chatAskInput.setChatInputElements(elements);
        List<ChatContextTag> tags = this.inputPanel.getInputTagsPanel().getTags();
        chatAskInput.setContextTags(tags);
        GenerateInput input = new GenerateInput(text, chatTask, this.chatContext, chatAskInput);
        input.setChatHistory(new ChatHistory(new ArrayList<AskAnswer>(), new ArrayList<AskAnswer>()));
        this.requestId = UUID.randomUUID().toString();
        TrackEventTypeEnum trackEventType = ChatMode.CHAT.getMode().equals(chatMode) ? TrackEventTypeEnum.INLINE_CHAT_OPERATION : TrackEventTypeEnum.INLINE_EDIT_OPERATION;
        TelemetryService.getInstance().telemetryChatTask(this.project, trackEventType, this.requestId, this.chatContext.getSessionId(), chatTask, input, SessionTypeEnum.INLINE.getTelemetryType());
        this.handleInlineChat(input, this.requestId);
        this.inputPanel.clearAfterSent();
        this.retryInput = input;
    }

    private void handleInlineChat(GenerateInput input, String requestId) {
        try {
            FileDocumentManager.getInstance().saveDocument(this.editor.getDocument());
        }
        catch (Exception e) {
            log.warn("saveDocument failed", (Throwable)e);
        }
        if (this.project != null && input != null) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.initInput.getChatTask()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)input.getChatTask())) {
                this.initInput.setChatTask(input.getChatTask());
            }
            RecentQueryUtil.addRecentComplexQuery(this.project, input.getChatAskInput());
            String displayText = input.getQuestion();
            this.prepareAndAsynchronousChat(input, input.getQuestion(), displayText, requestId);
        }
        ChatSessionUtil.updateRequestId(this.getSessionTypeEnum().getType());
    }

    @Override
    public void prepareAndAsynchronousChat(GenerateInput input, String prompt, String questionText, String requestId) {
        boolean isReply = ChatTaskUtil.isReply(input);
        String chatTask = this.getChatTaskForAsynchronousChat(input);
        SwingUtilities.invokeLater(() -> {
            this.prepareAnswer(input, chatTask, questionText, requestId);
            this.asynchronousChat(input, isReply, chatTask, this.chatMode, prompt, questionText, requestId);
        });
    }

    @Override
    protected String getChatMainVerticalScrollbarKey() {
        return "INLINE_CHAT_MAIN_VERTICAL_SCROLLBAR_KEY";
    }

    @Override
    protected void setupTextArea() {
        this.inputPanel.setTextAreaPlaceholder();
        this.inputPanel.getTextArea().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (KeyStroke.getKeyStrokeForEvent(e).equals(InlineChatPanel.this.enterKeyStroke)) {
                    SuggestPromptPopupPanel suggestPromptPopupPanel = InlineChatPanel.this.inputPanel.getChatInputSuggester().getSuggestPromptPopupPanel();
                    SuggestPrompt suggestPrompt = suggestPromptPopupPanel.chooseSuggestPromptSelection();
                    if (null == suggestPrompt) {
                        InlineChatPanel.this.sendButtonClicked();
                    } else {
                        suggestPromptPopupPanel.triggerChooseSuggestPrompt(suggestPrompt);
                        e.consume();
                    }
                } else if (KeyStroke.getKeyStrokeForEvent(e).equals(InlineChatPanel.this.cmdShiftEnterKeyStroke)) {
                    InlineChatPanel.this.editFileClicked();
                } else if (KeyStroke.getKeyStrokeForEvent(e).equals(InlineChatPanel.this.altEnterKeyStroke)) {
                    InlineChatPanel.this.askButtonClicked();
                }
            }
        });
    }

    private boolean hasAskComponent() {
        for (Component component : this.flowPanel.getComponents()) {
            if (!(component instanceof JComponent) || ((JComponent)component).getClientProperty(KEY_COMPONENT_MODE) != InlineChatMode.ASK) continue;
            return true;
        }
        return false;
    }

    public void sendButtonClicked() {
        InlineChatModeItem mode = this.modeChooser.getModeSelectedLabel().getModeItem();
        Component[] components = this.flowPanel.getComponents();
        if (InlineChatModeChooser.ASK == mode) {
            boolean hasAskComponent = this.hasAskComponent();
            if (hasAskComponent) {
                if (this.isCollapsed.get()) {
                    for (Component component : components) {
                        component.setVisible(false);
                    }
                    this.collapsePanel.setVisible(true);
                }
            } else {
                this.hideHistoricComponents(components);
            }
            this.askButtonClicked();
        } else if (InlineChatModeChooser.EDIT_IN_SELECTION == mode) {
            this.hideHistoricComponents(components);
            this.editSelectionClicked();
        } else {
            if (!this.isFloatingMode) {
                this.switchToFloatingMode();
            }
            this.hideHistoricComponents(components);
            this.editFileClicked();
        }
    }

    private void hideHistoricComponents(Component[] components) {
        for (Component component : components) {
            component.setVisible(false);
        }
        this.isCollapsed.set(true);
        this.collapsePanel.setVisible(false);
    }

    @Override
    public SessionTypeEnum getSessionTypeEnum() {
        return SessionTypeEnum.INLINE;
    }

    @Override
    public String getSessionTab() {
        return INLINE_TAB;
    }

    @Override
    public String getWelcomeMessage() {
        return CosyBundle.message("inline.chat.placeholder.normal.text", new Object[0]);
    }

    @Override
    protected String getChatTaskForAsynchronousChat(GenerateInput input) {
        return input.getChatTask();
    }

    @Override
    public String getNewChatText() {
        return "";
    }

    @Override
    public void createNewTask(QoderToolWindowPanel toolPanel, Point location) {
    }

    @Override
    protected void constructPanel() {
        this.basePanel.add((Component)this.scrollPane, "Center");
    }

    @Override
    protected void registerMessageListener() {
        this.messageBusConnection = this.project.getMessageBus().connect();
        this.messageBusConnection.subscribe(InlineChatStreamPushNotifier.INLINE_CHAT_GENERATE_STREAM_PUSH_NOTIFICATION, this::pushGenerate);
        this.messageBusConnection.subscribe(InlineChatStreamStopNotifier.INLINE_CHAT_GENERATE_STREAM_STOP_NOTIFICATION, this::stopGenerate);
        this.messageBusConnection.subscribe(InlineChatStreamPauseNotifier.INLINE_CHAT_STREAM_PAUSE_NOTIFIER_TOPIC, this::pauseGenerate);
        this.messageBusConnection.subscribe(InlineChatThinkingStreamPushNotifier.INLINE_CHAT_THINKING_PUSH_NOTIFICATION, this::pushThinking);
        this.messageBusConnection.subscribe(InlineChatGenerateStepCallbackNotifier.INLINE_CHAT_GENERATE_STEP_CALLBACK_NOTIFIER_TOPIC, this::processStepCallback);
        this.messageBusConnection.subscribe(AuthLoginNotifier.AUTH_LOGIN_NOTIFICATION, this::notifyLoginAuth);
        this.messageBusConnection.subscribe(AuthLogoutNotifier.AUTH_LOGOUT_NOTIFICATION, this::notifyLogoutAuth);
    }

    @Override
    protected void notifyLoginAuth(AuthStatus status) {
        this.inputPanel.setState(status);
        if (status.isAllow()) {
            this.enableInputPanel();
        }
        this.inputPanel.getChatInputSuggester().getSuggestPromptPopupPanel().initSuggestPromptChooser();
    }

    @Override
    protected void notifyLogoutAuth(AuthStatus status) {
        this.inputPanel.setState(status);
        if (!status.isAllow()) {
            this.disableInputPanel();
        }
    }

    @Override
    protected void enableInputPanel() {
        super.enableInputPanel();
        this.reset(this.project, this.editor, false);
    }

    @Override
    protected void disableInputPanel() {
        super.disableInputPanel();
        this.reset(this.project, this.editor, true);
    }

    @Override
    protected void pushGenerate(String requestId, String sessionId, String value, Boolean overwrite, Boolean refresh, String intentionType, String sessionType) {
        if (sessionType == null || !this.getSessionTypeEnum().getType().equals(sessionType)) {
            return;
        }
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)sessionId, (CharSequence)this.chatContext.getSessionId())) {
            return;
        }
        this.answerPanel.setIntentionType(intentionType);
        if (this.answerPanel.getRequestId() == null || this.answerPanel.getSessionId() == null) {
            this.answerPanel.setRequestId(requestId);
            this.answerPanel.setSessionId(sessionId);
        }
        if (this.inlineChatQuestion != null && this.inlineChatQuestion.getSessionId() == null) {
            this.inlineChatQuestion.setSessionId(sessionId);
        }
        if (ChatMode.EDIT.getMode().equals(this.chatMode)) {
            if (value.isEmpty()) {
                return;
            }
            if (this.editFinished.get()) {
                return;
            }
            if (refresh.booleanValue()) {
                this.answerText = new StringBuffer(value);
                if (this.currentDiffRenderer != null) {
                    this.currentDiffRenderer.clear();
                }
                this.showDiff(true);
                log.info("Rendered complete content with buttons: " + value);
            } else {
                if (this.answerText == null || this.answerText.length() == 0) {
                    this.answerText = new StringBuffer();
                }
                this.answerText.append(value);
                if (this.currentDiffRenderer != null) {
                    this.currentDiffRenderer.clear();
                }
                this.showDiff(false);
            }
        }
        if (ChatMode.CHAT.getMode().equals(this.chatMode)) {
            this.updateInlineChatResult(requestId, sessionId, value, overwrite, refresh, intentionType, sessionType);
        }
    }

    @Override
    public void stopGenerate(String requestId, String sessionId, Integer statusCode, String reason, Map<String, Object> extra) {
        String intentType;
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)sessionId, (CharSequence)this.chatContext.getSessionId())) {
            return;
        }
        String string = intentType = null == extra ? "" : StringUtils.objectToString(extra.get("intentType"));
        if (statusCode == null || statusCode != 200) {
            log.warn("Abnormal finish inline chat, code=" + (Serializable)(statusCode == null ? "null" : statusCode) + ", reason=" + reason);
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.chatMode, (CharSequence)ChatMode.EDIT.getMode())) {
                this.flowPanel.add(this.answerPanel.getComponent());
            }
            if (statusCode != null && statusCode == 429) {
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                Object message = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.answerText) ? I18NConstant.CHAT_TOO_MANY_REQUESTS : "\n" + I18NConstant.CHAT_TOO_MANY_REQUESTS;
                this.updateInlineChatResult(requestId, sessionId, (String)message, true, false, intentType, null);
            } else if (statusCode != null && statusCode == 31404) {
                Object message = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.answerText) ? I18NConstant.DIRECTORY_NOT_EXISTED_ERROR : "\n" + I18NConstant.DIRECTORY_NOT_EXISTED_ERROR;
                this.updateInlineChatResult(requestId, sessionId, (String)message, true, false, intentType, null);
            } else if (statusCode != null && statusCode == 403) {
                String message = InlineChatPanel.getQuotaUsageExceptionMessage(this.answerText.toString(), reason);
                NotificationFactory.showErrorNotification(this.project, I18NConstant.COSY_PLUGIN_NAME, message);
                this.updateInlineChatResult(requestId, sessionId, "", true, false, intentType, null);
            } else if (statusCode != null && statusCode == 408) {
                this.updateInlineChatResult(requestId, sessionId, "", false, false, intentType, null);
            } else if (statusCode != null && statusCode == 409) {
                Object message = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.answerText) ? I18NConstant.CHAT_ERROR_RETRY_NO_HISTORY : "\n" + I18NConstant.CHAT_ERROR_RETRY_NO_HISTORY;
                this.updateInlineChatResult(requestId, sessionId, (String)message, true, false, intentType, null);
            } else if (statusCode != null && statusCode == 500) {
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                Object message = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.answerText) ? I18NConstant.CHAT_INTERNAL_ERROR : "\n" + I18NConstant.CHAT_INTERNAL_ERROR;
                this.updateInlineChatResult(requestId, sessionId, (String)message, true, false, null, null);
            } else if (statusCode != null && statusCode == 601) {
                this.updateInlineChatResult(requestId, sessionId, I18NConstant.CHAT_BLOCKED_BY_FILTER, false, false, intentType, null);
            } else {
                Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                String text = ErrorMessageHandler.convertErrorMessage(this.project, requestId, reason, null);
                Object message = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.answerText) ? text : "\n" + text;
                this.updateInlineChatResult(requestId, sessionId, (String)message, true, false, intentType, null);
            }
        }
        this.resetAfterFinishChat(statusCode, Optional.ofNullable(extra).map(e -> e.get("fullAnswer")).orElse(null));
    }

    @NotNull
    public static String getQuotaUsageExceptionMessage(String answerText, String reason) {
        String text = "";
        try {
            JSONObject reasonJson = JSON.parseObject((String)reason);
            if (null != reasonJson) {
                Integer code = reasonJson.getInteger("code");
                JSONObject message = reasonJson.getJSONObject("message");
                if (null != code) {
                    String pricingUrl = null;
                    Boolean isHighestTier = null;
                    if (null != message) {
                        pricingUrl = message.getString("pricingUrl");
                        isHighestTier = message.getBoolean("isHighestTier");
                    }
                    if (code == 112) {
                        text = Boolean.TRUE.equals(isHighestTier) ? CosyBundle.message("quota.daily.limit.text.highest.plain", pricingUrl) : CosyBundle.message("quota.daily.limit.text.plain", pricingUrl);
                    } else if (code == 114) {
                        text = CosyBundle.message("quota.same.person.text.plain", QoderUrls.TROUBLESHOOTING_ACCOUNT_MANAGEMENT.getRealUrl());
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to parse reason to json object: " + reason, (Throwable)e);
        }
        Object object = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)answerText) ? text : "\n" + text;
        if (object == null) {
            InlineChatPanel.$$$reportNull$$$0(0);
        }
        return object;
    }

    private void resetAfterFinishChat(Integer statusCode, Object fullAnswer) {
        boolean canSend = false;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.inputPanel.getTextArea().getText())) {
            canSend = this.inputPanel.getTextArea().canSend();
        }
        if (statusCode != null && statusCode == 200) {
            InlineChatButtonStateEnum state = this.findNextButtonPanelState(canSend, true);
            this.setBottomPanelToState(state);
        } else {
            this.setBottomPanelToState(InlineChatButtonStateEnum.INIT);
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.chatMode, (CharSequence)ChatMode.EDIT.getMode())) {
            if (this.currentDiffRenderer != null) {
                this.currentDiffRenderer.clear();
            }
            if (!org.apache.commons.lang3.StringUtils.endsWith((CharSequence)this.answerText, (CharSequence)"\n") && this.answerText != null) {
                this.answerText.append("\n");
            }
            if (InlineChatMode.EDIT_IN_FILE.getMode().equals(this.getCurrentMode()) && null != fullAnswer) {
                this.answerText = new StringBuffer(fullAnswer.toString());
            }
            this.editFinished.set(true);
            this.showDiff(true);
            this.removeMarkSelectTextRange();
        }
        this.answerText = new StringBuffer();
    }

    public void reset(Project project, Editor editor, boolean disposeInlayAndHighlighter) {
        this.project = project;
        this.editor = editor;
        this.inputPanel.clearAll();
        this.setBottomPanelToState(InlineChatButtonStateEnum.INIT);
        this.isDragging = false;
        this.basePanel.setCursor(Cursor.getDefaultCursor());
        if (this.isFloatingMode && this.floatingPanel != null) {
            try {
                Container parent = this.floatingPanel.getParent();
                parent.remove(this.floatingPanel);
                parent.revalidate();
                parent.repaint();
            }
            catch (Exception e) {
                log.warn("Error removing floating panel", (Throwable)e);
            }
        }
        this.isFloatingMode = false;
        this.floatingPanel = null;
        this.floatingPanelPosition = null;
        this.lastMousePosition = null;
        if (this.currentDiffRenderer != null) {
            this.currentDiffRenderer.clear();
            this.currentDiffRenderer = null;
        }
        if (this.flowPanel != null) {
            this.flowPanel.removeAll();
        }
        if (this.scrollPane != null) {
            this.scrollPane.invalidate();
            this.scrollPane.setVisible(false);
        }
        if (this.rangeHighlighter != null && disposeInlayAndHighlighter) {
            this.rangeHighlighter.dispose();
            this.rangeHighlighter = null;
        }
        this.basePanel.revalidate();
        this.basePanel.repaint();
        if (this.currentInlay != null && disposeInlayAndHighlighter) {
            try {
                Disposer.dispose(this.currentInlay);
            }
            catch (Exception e) {
                log.warn("Error disposing inlay", (Throwable)e);
            }
            this.currentInlay = null;
        }
        log.info("InlineChatPanel successfully removed");
        this.answerText = new StringBuffer();
        this.chatMode = null;
        if (this.documentListener != null) {
            editor.getDocument().removeDocumentListener(this.documentListener);
            this.documentListener = null;
        }
        this.removeMarkSelectTextRange();
        this.chatContext = ((ChatContext.ChatContextBuilder)((ChatContext.ChatContextBuilder)ChatContext.builder().sessionId(UUID.randomUUID().toString())).fileLanguage(FileUtil.getLanguageFileType(project))).build();
    }

    private void asynchronousChat(GenerateInput input, boolean isReply, String chatTask, String mode, String prompt, String questionText, String requestId) {
        if (input == null || input.getChatContext() == null) {
            return;
        }
        input.setQuestion(prompt);
        Object dto = null;
        if (chatTask != null) {
            dto = ChatContextDtoBuilderFactory.getChatContextDtoBuilder(chatTask).build(input, questionText);
        }
        if (dto == null) {
            log.warn("Chat context dto cannot build. Generate input = " + JSON.toJSONString((Object)input));
            return;
        }
        this.manualScroll.getAndSet(false);
        this.hideWelcomeInfoPanel();
        log.debug("Chat context = " + JSONObject.toJSONString((Object)dto));
        SessionTypeEnum sessionTypeEnum = this.getSessionTypeEnum();
        ChatTaskUtil.configChatTaskExtraModel(this.project, input, sessionTypeEnum.getType());
        if (InlineChatMode.EDIT_IN_FILE.getMode().equals(this.getCurrentMode())) {
            input.getExtra().setFullFileEdit(true);
        }
        ChatAskParam chatAskParam = ChatAskParam.builder().chatTask(chatTask).chatContext(dto).requestId(requestId).isReply(isReply).source(1).sessionId(input.getChatContext().getSessionId() == null ? this.initInput.getChatContext().getSessionId() : input.getChatContext().getSessionId()).codeLanguage(input.getChatContext().getFileLanguage()).questionText(questionText).stream(Boolean.TRUE).taskDefinitionType(input.getTaskDefinitionType()).extra(input.getExtra()).sessionType(sessionTypeEnum.getType()).targetAgent(input.getTargetAgent()).mode(mode).shellType(CosyKey.PROJECT_SHELL_PATH_MAP.get(this.project.getBasePath())).build();
        if (this.initInput.getChatHistory() == null) {
            this.initInput.setChatHistory(new ChatHistory(new ArrayList<AskAnswer>(), new ArrayList<AskAnswer>()));
        }
        if (this.inlineChatQuestion != null) {
            this.inlineChatQuestion.setSessionId(chatAskParam.getSessionId());
        }
        this.answerPanel.setRequestId(requestId);
        this.answerPanel.setSessionId(chatAskParam.getSessionId());
        final ChatAskParam finalChatAskParam = chatAskParam;
        new Task.Backgroundable(this.project, I18NConstant.GENERATE_TIP){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                InlineChatPanel.this.invokeInline(finalChatAskParam);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/alibabacloud/intellij/qoder/ui/chat/inline/InlineChatPanel$5", "run"));
            }
        }.queue();
        this.scheduleChatTimeout(requestId, input, 30L);
        if (!ChatTaskEnum.CHAT_HELP.getName().equals(chatAskParam.getChatTask())) {
            String placeHolderByTag = ChatAskTagUtil.getPlaceholderByTextArea(this.inputPanel.textArea);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)placeHolderByTag)) {
                this.inputPanel.textArea.setPlaceholder(placeHolderByTag);
            } else {
                this.inputPanel.textArea.setPlaceholder(CosyBundle.message("chat.input.placeholder.normal.continue", new Object[0]));
            }
        }
    }

    private String getCurrentMode() {
        return this.modeChooser.getModeSelectedLabel().getModeItem().getMode();
    }

    private InlineChatMode getCurrentModeEnum() {
        return InlineChatMode.getByMode(this.getCurrentMode());
    }

    @Override
    protected void scheduleChatTimeout(String requestId, GenerateInput input, long timeout) {
        SCHEDULED_EXECUTOR.schedule(() -> {
            if (this.answerPanel != null) {
                if (this.answerPanel.getRequestId() != null && !this.answerPanel.getRequestId().equals(requestId)) {
                    log.info("Answer panel request id not equals, skip timeout");
                    return;
                }
                Long timestamp = (Long)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).get(requestId);
                Project project = (Project)Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).get(requestId);
                if (project != null && timestamp != null && System.currentTimeMillis() - timestamp > 30000L) {
                    log.info("inline chat timeout after 30seconds. sessionId=" + this.answerPanel.getSessionId() + ", requestId=" + this.answerPanel.getRequestId());
                    ApplicationManager.getApplication().invokeLater(() -> this.cosyService.chatStop(project, ChatStopParam.builder().sessionId(this.answerPanel.getSessionId()).requestId(this.answerPanel.getRequestId()).build()));
                    Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_PROJECT)).remove(requestId);
                    Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_TO_ANSWER_LIST)).remove(requestId);
                    Objects.requireNonNull((Map)ApplicationManager.getApplication().getUserData(CosyKey.REQUEST_ANSWERING)).remove(requestId);
                    this.isAnswering.set(false);
                    this.flowPanel.remove(this.answerPanel.getComponent());
                    this.drawLineWithKey("line.response.timeout");
                    this.reset(project, this.editor, false);
                }
            }
        }, timeout, TimeUnit.SECONDS);
    }

    private void configInlineChatInputPanel() {
        this.inputPanel.getTextArea().getDocument().removeDocumentListener(this.inputPanel.getDefaultDocumentListener());
        this.inputPanel.getTextArea().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                InlineChatPanel.this.processAfterChangeAll(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/alibabacloud/intellij/qoder/ui/chat/inline/InlineChatPanel$6", "textChanged"));
            }
        });
        this.editor.getScrollingModel().addVisibleAreaListener(visibleAreaEvent -> this.inputPanel.getTextArea().updateSuggestPopupPosition());
        this.inlineChatInputPanel = new RoundRectPanel(new BorderLayout(), 8){

            @Override
            public Dimension getPreferredSize() {
                return super.getPreferredSize();
            }
        };
        this.configInlineChatInputPanelUI();
    }

    private void configInlineChatInputPanelUI() {
        this.inlineChatInputPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.inlineChatInputPanel.add((Component)this.inputPanel, "Center");
        this.inlineChatInputPanel.add((Component)this.chatOperationPanel, "South");
        this.inlineChatInputPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
    }

    private int countLines(CharSequence text) {
        if (text == null || text.length() == 0) {
            return 0;
        }
        int lines = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++lines;
        }
        return lines;
    }

    private void updateScrollPaneSize() {
        this.basePanel.revalidate();
        if (this.scrollPane != null) {
            this.scrollPane.revalidate();
            this.scrollPane.getVerticalScrollBar().revalidate();
        }
        if (this.flowPanel != null) {
            this.flowPanel.revalidate();
        }
        if (this.isFloatingMode && null != this.floatingPanel) {
            this.floatingPanel.setBounds(this.floatingPanelPosition.x, this.floatingPanelPosition.y, this.floatingPanel.getPreferredSize().width, this.floatingPanel.getPreferredSize().height);
        }
    }

    @Override
    public void moveScrollToBottom(boolean forceScroll) {
        if (Boolean.TRUE.equals(forceScroll) || !this.manualScroll.get()) {
            this.updateScrollPaneSize();
            this.flowPanel.validate();
            if (null != this.scrollPane) {
                this.scrollPane.validate();
            }
            SwingUtilities.invokeLater(() -> {
                if (null != this.scrollPane) {
                    JScrollBar verticalScrollBar = this.scrollPane.getVerticalScrollBar();
                    verticalScrollBar.setBackground(ColorUtil.getToolWindowBackgroundColor());
                    verticalScrollBar.setValue(verticalScrollBar.getMaximum());
                }
            });
        }
    }

    private void invokeInline(ChatAskParam chatAskParam) {
        if (!Cosy.INSTANCE.checkCosy(this.project, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.chatMode, (CharSequence)ChatMode.EDIT.getMode())) {
                    this.flowPanel.add(this.answerPanel.getComponent());
                }
                this.updateInlineChatResult(chatAskParam.getRequestId(), chatAskParam.getSessionId(), I18NConstant.COSY_RESTARTING, true, false, null, null);
                this.initInput.getChatHistory().setAskAnswerList(new ArrayList<AskAnswer>());
                this.setBottomPanelToState(InlineChatButtonStateEnum.INIT);
            });
            return;
        }
        AuthStatus status = LoginUtil.getAuthStatus(this.project);
        if (status != null && !status.isAllow()) {
            if (this.isNotLogin(status)) {
                log.warn("Not login when inline chatting");
                if (!UserAuthService.getInstance().requireLogin(this.project)) {
                    return;
                }
            }
            String message = AuthStatusUtil.generateAuthMessage(status);
            log.warn("Login status not allowed");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)message)) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.chatMode, (CharSequence)ChatMode.EDIT.getMode())) {
                        this.flowPanel.add(this.answerPanel.getComponent());
                    }
                    this.updateInlineChatResult(chatAskParam.getRequestId(), chatAskParam.getSessionId(), message, true, false, null, null);
                    this.setBottomPanelToState(InlineChatButtonStateEnum.INIT);
                });
            }
            return;
        }
        ChatAskResult chatAskResult = this.cosyService.chatAsk(this.project, chatAskParam);
        if (chatAskResult != null) {
            log.info(String.format("chat result = %s %s", chatAskResult.getIsSuccess(), chatAskResult.getStatus()));
        }
    }

    private void updateInlineChatResult(String requestId, String sessionId, String value, Boolean overwrite, Boolean refresh, String intentionType, String sessionType) {
        if (this.answerPanel == null) {
            log.warn("Answer panel is not ready when pushGenerate");
            return;
        }
        if (!this.answerPanel.getRequestId().equals(requestId)) {
            return;
        }
        this.answerPanel.updateGenerateState(CosyBundle.message("chat.answer.btn.generating", new Object[0]));
        this.answerPanel.doneThinking();
        if (overwrite.booleanValue()) {
            this.answerPanel.clearText();
            this.answerPanel.hideGenerateStatePanel();
        } else if (BooleanUtils.isTrue((Boolean)refresh)) {
            this.answerPanel.clearText();
        }
        this.answerPanel.appendText(value, false);
        this.postGenerate();
        this.updateScrollPaneSize();
        this.moveScrollToBottom(false);
        SwingUtilities.invokeLater(() -> {
            this.answerPanel.getComponent().invalidate();
            this.answerPanel.getComponent().repaint();
            if (BooleanUtils.isTrue((Boolean)overwrite) || BooleanUtils.isTrue((Boolean)refresh)) {
                this.answerPanel.endGenerate();
            }
        });
    }

    public void showDiff(Boolean needButton) {
        String textStr = this.answerText.toString();
        String res = DocumentUtils.convertSeparatorToSlashN(textStr);
        Project project = this.project;
        if (this.editor != null) {
            this.removeMarkSelectTextRange();
            FileType fileType = null;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(this.editor.getDocument());
            if (virtualFile != null) {
                fileType = virtualFile.getFileType();
            }
            InEditorDiffRenderer diffRenderer = InlineChatModeChooser.EDIT_IN_FILE == this.modeChooser.getModeSelectedLabel().getModeItem() ? InEditorDiffRenderer.create(this.editor, project, fileType, 0, this.editor.getDocument().getText(), this.getRequestId(), this.getChatContext().getSessionId(), this) : InEditorDiffRenderer.create(this.editor, project, fileType, this.currentSelectStartLine, this.selectedText, this.getRequestId(), this.getChatContext().getSessionId(), this);
            this.currentDiffRenderer = diffRenderer;
            diffRenderer.render(res, needButton);
        } else {
            log.warn("No editor found when attempting to render diff");
        }
    }

    private JComponent wrapToComponent() {
        Dimension size = this.basePanel.getPreferredSize();
        Integer width = EditorUtil.getEditorVisibleWidth(this.project);
        if (width == null) {
            width = 1000;
        }
        width = Math.max((int)(0.5 * (double)width.intValue()), 550);
        this.basePanel.setPreferredSize(new Dimension(width, size.height));
        RoundRectPanel wrapper = new RoundRectPanel((LayoutManager)new BorderLayout(), 16);
        wrapper.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        wrapper.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.configCollapsePanel();
        wrapper.add((Component)this.collapsePanel, "North");
        wrapper.add((Component)this.basePanel, "Center");
        wrapper.putClientProperty("AuxEditorComponent", true);
        return wrapper;
    }

    private void configCollapsePanel() {
        this.collapseLabel = new JLabel(QoderIcons.ArrowdownGrey12Icon);
        this.collapseLabel.setBackground(ColorUtil.getChatCardBackgroundColor());
        this.collapseLabel.setCursor(Cursor.getDefaultCursor());
        this.collapseLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Component[] components = InlineChatPanel.this.flowPanel.getComponents();
                if (InlineChatPanel.this.isCollapsed.get()) {
                    InlineChatPanel.this.collapseLabel.setIcon(QoderIcons.ArrowdownGrey12Icon);
                    InlineChatPanel.this.isCollapsed.set(false);
                    for (Component component : components) {
                        if (component.isVisible() || !(component instanceof JComponent)) continue;
                        component.setVisible(((JComponent)component).getClientProperty(InlineChatPanel.KEY_COMPONENT_MODE) == InlineChatMode.ASK);
                    }
                } else {
                    Object type;
                    InlineChatPanel.this.collapseLabel.setIcon(QoderIcons.ArrowUpGrey12Icon);
                    InlineChatPanel.this.isCollapsed.set(true);
                    for (Component component : components) {
                        component.setVisible(false);
                    }
                    Component component = components[components.length - 1];
                    if (component instanceof JComponent && InlineChatPanel.VALUE_COMPONENT_TYPE_ANSWER.equals(type = ((JComponent)component).getClientProperty(InlineChatPanel.KEY_COMPONENT_TYPE))) {
                        component.setVisible(true);
                        if (components.length > 1) {
                            components[components.length - 2].setVisible(true);
                        }
                    }
                }
            }
        });
        this.collapsePanel = new JPanel(new FlowLayout(1, 0, 0)){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int width = this.getWidth();
                int x = width / 2 - 24;
                RoundRectangle2D.Float lowerRoundRect = new RoundRectangle2D.Float(x, 0.0f, 48.0f, 12.0f, 8.0f, 8.0f);
                Rectangle2D.Float upperRoundRect = new Rectangle2D.Float(x, 0.0f, 48.0f, 6.0f);
                g2.setColor(ColorUtil.getChatCardBackgroundColor());
                g2.fill(lowerRoundRect);
                g2.fill(upperRoundRect);
                this.paintChildren(g2);
                g2.dispose();
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(48, 12);
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.collapsePanel.setOpaque(false);
        this.collapsePanel.setVisible(false);
        this.collapsePanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.collapsePanel.add(this.collapseLabel);
    }

    public void insertPanel() {
        this.insertPanel(false);
    }

    public void insertPanel(boolean enableFloating) {
        FoldRegion relatedCodeBlock;
        int offset;
        this.panelClosed.set(false);
        if (enableFloating) {
            this.insertFloatingPanel(this.getInitPosition());
            return;
        }
        Document document = this.editor.getDocument();
        SelectionModel selectionModel = this.editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            offset = selectionModel.getSelectionStart();
            int endOffset = selectionModel.getSelectionEnd();
            int startLine = this.editor.getDocument().getLineNumber(offset);
            int endLine = this.editor.getDocument().getLineNumber(endOffset);
            int newSelectionStart = this.editor.getDocument().getLineStartOffset(startLine);
            int newSelectionEnd = this.editor.getDocument().getLineEndOffset(endLine);
            selectionModel.setSelection(newSelectionStart, newSelectionEnd);
            this.currentSelectStartLine = startLine;
            this.currentSelectEndLine = endLine;
            relatedCodeBlock = CodeBlockFinder.findFoldableBlock(this.editor, offset);
        } else {
            int caretLine = this.editor.getCaretModel().getLogicalPosition().line;
            offset = this.editor.getDocument().getLineStartOffset(caretLine);
            String lineText = document.getText(new TextRange(offset, this.editor.getDocument().getLineEndOffset(caretLine)));
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)org.apache.commons.lang3.StringUtils.trim((String)lineText))) {
                relatedCodeBlock = null;
                this.currentSelectStartLine = caretLine;
                this.currentSelectEndLine = caretLine;
            } else {
                relatedCodeBlock = CodeBlockFinder.findFoldableBlock(this.editor, offset);
                if (relatedCodeBlock != null) {
                    int line;
                    offset = this.editor.getDocument().getLineNumber(relatedCodeBlock.getEndOffset()) == caretLine ? ((line = this.editor.getDocument().getLineNumber(relatedCodeBlock.getEndOffset()) + 1) >= this.editor.getDocument().getLineCount() ? relatedCodeBlock.getStartOffset() : this.editor.getDocument().getLineStartOffset(line)) : relatedCodeBlock.getStartOffset();
                    this.currentSelectStartLine = this.editor.getDocument().getLineNumber(relatedCodeBlock.getStartOffset());
                    this.currentSelectEndLine = this.editor.getDocument().getLineNumber(relatedCodeBlock.getEndOffset());
                } else {
                    this.currentSelectStartLine = caretLine;
                    this.currentSelectEndLine = caretLine;
                }
            }
        }
        if (relatedCodeBlock != null && !relatedCodeBlock.isExpanded()) {
            if (relatedCodeBlock.shouldNeverExpand()) {
                if (offset == relatedCodeBlock.getEndOffset()) {
                    ++offset;
                }
            } else {
                this.editor.getFoldingModel().runBatchFoldingOperation(() -> relatedCodeBlock.setExpanded(true));
            }
        }
        int selectStartOffSet = this.editor.getDocument().getLineStartOffset(this.currentSelectStartLine);
        int selectEndOffSet = this.editor.getDocument().getLineEndOffset(this.currentSelectEndLine);
        this.selectedText = this.editor.getDocument().getText(new TextRange(selectStartOffSet, selectEndOffSet));
        this.markSelectTextRange();
        this.editor.getSelectionModel().removeSelection();
        InlayProperties properties = new InlayProperties().showAbove(true);
        properties.priority(0);
        JComponent wrapToComponent = this.wrapToComponent();
        this.currentInlay = ComponentInlayKt.addComponentInlay(this.editor, offset, properties, wrapToComponent, ComponentInlayAlignment.COMPONENT_WIDTH_ONLY);
        this.inputPanel.getTextArea().putClientProperty("AuxEditorComponent", true);
        SwingUtilities.invokeLater(() -> this.inputPanel.getTextArea().requestFocusInWindow());
        this.documentListener = new DocumentListener(){

            public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
                if (event == null) {
                    10.$$$reportNull$$$0(0);
                }
                InlineChatPanel.this.handleDocumentChange(event);
                InlineChatPanel.this.basePanel.revalidate();
                InlineChatPanel.this.basePanel.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/alibabacloud/intellij/qoder/ui/chat/inline/InlineChatPanel$10", "documentChanged"));
            }
        };
        document.addDocumentListener(this.documentListener);
        ApplicationManager.getApplication().invokeLater(() -> this.editor.putUserData(CosyKey.INLINE_CHAT_PANEL_KEY, (Object)this));
        this.scrollToInlayPosition();
    }

    private void scrollToInlayPosition() {
        if (this.currentInlay != null) {
            int inlayOffset = this.currentInlay.getOffset();
            LogicalPosition logicalPosition = this.editor.offsetToLogicalPosition(inlayOffset);
            this.editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.CENTER);
        }
    }

    public void removePanel() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.panelClosed.set(true);
            this.reset(this.project, this.editor, true);
            this.editor.putUserData(CosyKey.INLINE_CHAT_PANEL_KEY, null);
        });
    }

    @Override
    protected void configScrollAndFlowPanel() {
        this.flowPanel = new WelcomeBgPanel();
        this.scrollPane = new JBScrollPane(this.flowPanel, 20, 31){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Dimension flowSize = InlineChatPanel.this.flowPanel.getPreferredSize();
                size.height = Math.min(flowSize.height, 480);
                return size;
            }
        };
    }

    @Override
    protected void configInputPanel() {
        this.inputPanel = new InlineChatInputPanel(this.project, this, "inlineChatPanel");
    }

    @Override
    protected void doPrepareAnswer(GenerateInput input, String chatTask, String displayText, String requestId) {
        ChatAskInput chatAskInput = input.getChatAskInput();
        SessionTypeEnum sessionTypeEnum = this.getSessionTypeEnum();
        InlineChatMode chatModeEnum = this.getCurrentModeEnum();
        this.answerPanel = new InlineChatAnswerPanel(this.project, this, this.basePanel, chatTask, chatAskInput, sessionTypeEnum);
        String extraTextFormChatContext = this.getExtraTextFormChatContext(input, displayText);
        this.inlineChatQuestion = new InlineChatQuestion(this.project, this.basePanel, extraTextFormChatContext, null, chatAskInput, requestId, chatTask, sessionTypeEnum.getType(), this.answerPanel);
        this.inlineChatQuestion.getComponent().setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.answerPanel.getComponent().putClientProperty(KEY_COMPONENT_MODE, (Object)chatModeEnum);
        this.answerPanel.getComponent().putClientProperty(KEY_COMPONENT_TYPE, VALUE_COMPONENT_TYPE_ANSWER);
        this.inlineChatQuestion.getComponent().putClientProperty(KEY_COMPONENT_MODE, (Object)chatModeEnum);
        this.inlineChatQuestion.getComponent().putClientProperty(KEY_COMPONENT_TYPE, VALUE_COMPONENT_TYPE_QUESTION);
        this.flowPanel.add(this.inlineChatQuestion.getComponent());
        if (this.chatMode.equals(ChatMode.CHAT.getMode())) {
            this.flowPanel.add(this.answerPanel.getComponent());
        }
        this.scrollPane.setVisible(true);
        this.moveScrollToBottom(false);
        if (this.isFloatingMode) {
            this.addDragListenersToComponent(this.inlineChatQuestion.getComponent());
            this.addDragListenersToComponent(this.answerPanel.getComponent());
        }
    }

    private void setBottomPanelToState(InlineChatButtonStateEnum state) {
        this.buttonState = state;
        switch (this.buttonState) {
            case CAN_SEND: {
                this.setButtonPanelToCanSend();
                break;
            }
            case NEED_CONFIRM: {
                this.setButtonPanelToNeedConfirm();
                break;
            }
            case WAIT_FOR_ASK_FINISH: 
            case WAIT_FOR_EDIT_FINISH: {
                this.setButtonPanelToWaitFinish();
                break;
            }
            default: {
                this.setButtonPanelToInit();
            }
        }
        this.chatOperationPanel.revalidate();
        this.chatOperationPanel.repaint();
        ((InlineChatInputPanel)this.inputPanel).setSendLabelStatus(state);
        ((InlineChatInputPanel)this.inputPanel).getSendLabel().revalidate();
        ((InlineChatInputPanel)this.inputPanel).getSendLabel().repaint();
    }

    private InlineChatButtonStateEnum findNextButtonPanelState(boolean canSend, boolean finished) {
        if (this.buttonState == InlineChatButtonStateEnum.INIT) {
            if (canSend) {
                return InlineChatButtonStateEnum.CAN_SEND;
            }
            if (this.currentDiffRenderer != null && this.currentDiffRenderer.hasChanges()) {
                return InlineChatButtonStateEnum.NEED_CONFIRM;
            }
        }
        if (this.buttonState == InlineChatButtonStateEnum.CAN_SEND && !canSend) {
            if (this.currentDiffRenderer != null && this.currentDiffRenderer.hasChanges()) {
                return InlineChatButtonStateEnum.NEED_CONFIRM;
            }
            return InlineChatButtonStateEnum.INIT;
        }
        if (this.buttonState == InlineChatButtonStateEnum.WAIT_FOR_ASK_FINISH) {
            if (this.currentDiffRenderer != null && this.currentDiffRenderer.hasChanges()) {
                return InlineChatButtonStateEnum.NEED_CONFIRM;
            }
            return canSend ? InlineChatButtonStateEnum.CAN_SEND : InlineChatButtonStateEnum.INIT;
        }
        if (this.buttonState == InlineChatButtonStateEnum.WAIT_FOR_EDIT_FINISH) {
            if (finished) {
                return InlineChatButtonStateEnum.NEED_CONFIRM;
            }
            return canSend ? InlineChatButtonStateEnum.CAN_SEND : InlineChatButtonStateEnum.INIT;
        }
        if (this.buttonState == InlineChatButtonStateEnum.NEED_CONFIRM) {
            if (canSend) {
                return InlineChatButtonStateEnum.CAN_SEND;
            }
            if (this.currentDiffRenderer != null && this.currentDiffRenderer.hasChanges()) {
                return InlineChatButtonStateEnum.NEED_CONFIRM;
            }
            return InlineChatButtonStateEnum.INIT;
        }
        return this.buttonState;
    }

    private void setButtonPanelToInit() {
        this.chatCloseLabel.setVisible(true);
        this.generatingLabel.setVisible(false);
        this.changeOperationPanel.setVisible(false);
        this.inputPanel.getTextArea().setEditable(true);
        this.inputPanel.getTextArea().setFocusable(true);
    }

    private void setButtonPanelToCanSend() {
        this.chatCloseLabel.setVisible(true);
        this.generatingLabel.setVisible(false);
        this.changeOperationPanel.setVisible(false);
        this.inputPanel.getTextArea().setEditable(true);
        this.inputPanel.getTextArea().setFocusable(true);
    }

    private void setButtonPanelToWaitFinish() {
        this.chatCloseLabel.setVisible(false);
        this.generatingLabel.setVisible(true);
        this.changeOperationPanel.setVisible(false);
        this.inputPanel.getTextArea().setEditable(false);
        this.inputPanel.getTextArea().setFocusable(false);
    }

    private void setButtonPanelToNeedConfirm() {
        this.chatCloseLabel.setVisible(false);
        this.generatingLabel.setVisible(false);
        this.changeOperationPanel.setVisible(true);
        this.inputPanel.getTextArea().setEditable(true);
        this.inputPanel.getTextArea().setFocusable(true);
    }

    @Override
    protected void pauseGenerate(String requestId, String sessionId) {
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)sessionId, (CharSequence)this.chatContext.getSessionId())) {
            return;
        }
        this.resetAfterFinishChat(null, null);
    }

    public void askButtonClicked() {
        if (this.buttonState == InlineChatButtonStateEnum.CAN_SEND) {
            this.handleButtonClick(ChatMode.CHAT.getMode());
            this.setBottomPanelToState(InlineChatButtonStateEnum.WAIT_FOR_ASK_FINISH);
        }
    }

    public void editSelectionClicked() {
        if (this.buttonState == InlineChatButtonStateEnum.CAN_SEND) {
            this.editFinished.set(false);
            this.handleButtonClick(ChatMode.EDIT.getMode());
            this.setBottomPanelToState(InlineChatButtonStateEnum.WAIT_FOR_EDIT_FINISH);
            this.markSelectTextRange();
        }
    }

    public void editFileClicked() {
        if (this.buttonState == InlineChatButtonStateEnum.CAN_SEND) {
            this.editFinished.set(false);
            this.handleButtonClick(ChatMode.EDIT.getMode());
            this.setBottomPanelToState(InlineChatButtonStateEnum.WAIT_FOR_EDIT_FINISH);
        }
    }

    public void stopButtonClicked() {
        if (this.buttonState == InlineChatButtonStateEnum.WAIT_FOR_ASK_FINISH || this.buttonState == InlineChatButtonStateEnum.WAIT_FOR_EDIT_FINISH) {
            this.stopSessionChat();
        }
    }

    public void acceptButtonClicked() {
        if (this.buttonState != InlineChatButtonStateEnum.NEED_CONFIRM) {
            return;
        }
        if (this.currentDiffRenderer != null) {
            this.currentDiffRenderer.acceptAll();
            this.removePanel();
        }
    }

    public void rejectButtonClicked() {
        if (this.buttonState != InlineChatButtonStateEnum.NEED_CONFIRM) {
            return;
        }
        if (this.currentDiffRenderer != null) {
            this.currentDiffRenderer.rejectAll();
        }
        this.onRejectAllChanges();
    }

    public void markSelectTextRange() {
        if (this.rangeHighlighter != null && this.rangeHighlighter.isValid()) {
            return;
        }
        int selectStartOffSet = this.editor.getDocument().getLineStartOffset(this.currentSelectStartLine);
        int selectEndOffSet = this.editor.getDocument().getLineEndOffset(this.currentSelectEndLine);
        TextAttributes textAttributes = new TextAttributes();
        textAttributes.setBackgroundColor(ColorUtil.getInlineChatSelectionBackground(this.editor));
        this.rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(selectStartOffSet, selectEndOffSet, 3500, textAttributes, HighlighterTargetArea.LINES_IN_RANGE);
    }

    private void removeMarkSelectTextRange() {
        if (this.rangeHighlighter != null && this.rangeHighlighter.isValid()) {
            try {
                this.editor.getMarkupModel().removeHighlighter(this.rangeHighlighter);
                this.rangeHighlighter.dispose();
            }
            catch (Exception e) {
                log.warn("removeMarkSelectTextRange error", (Throwable)e);
            }
            this.rangeHighlighter = null;
        }
    }

    public void onRejectAllChanges() {
        this.markSelectTextRange();
        this.answerText = new StringBuffer();
        this.processAfterChangeAll(true);
    }

    private void processAfterChangeAll(boolean finished) {
        boolean canSend = false;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.inputPanel.getTextArea().getText())) {
            canSend = this.inputPanel.getTextArea().canSend();
        }
        InlineChatButtonStateEnum buttonStateEnum = this.findNextButtonPanelState(canSend, finished);
        this.setBottomPanelToState(buttonStateEnum);
    }

    public void onAcceptAllChanges() {
        this.removePanel();
    }

    private void handleDocumentChange(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
        if (event == null) {
            InlineChatPanel.$$$reportNull$$$0(1);
        }
        Document document = event.getDocument();
        int offset = event.getOffset();
        int changeLine = document.getLineNumber(offset);
        int addedLines = this.countLines(event.getNewFragment()) - this.countLines(event.getOldFragment());
        log.info("handleDocumentChange: changeLine=" + changeLine + ", addedLines=" + addedLines);
        log.info("handleDocumentChange: currentSelectStartLine=" + this.currentSelectStartLine + ", currentSelectEndLine=" + this.currentSelectEndLine);
        if (changeLine < this.currentSelectStartLine) {
            this.currentSelectStartLine += addedLines;
            this.currentSelectEndLine += addedLines;
        } else if (changeLine <= this.currentSelectEndLine) {
            this.currentSelectEndLine += addedLines;
        }
        if (this.currentSelectEndLine < this.currentSelectStartLine) {
            this.currentSelectEndLine = this.currentSelectStartLine;
        }
        int startOffSet = document.getLineStartOffset(this.currentSelectStartLine);
        int endOffSet = document.getLineEndOffset(this.currentSelectEndLine);
        this.selectedText = document.getText(new TextRange(startOffSet, endOffSet));
        if (this.currentDiffRenderer != null) {
            this.currentDiffRenderer.adjustChangeLine(changeLine, addedLines);
        }
    }

    private void configChangeOperationPanel() {
        this.initButtons();
        this.changeOperationPanel = new Box(0);
        this.changeOperationPanel.setBorder((Border)JBUI.Borders.empty());
        this.changeOperationPanel.setBackground(ColorUtil.getToolWindowBackgroundColor());
        this.changeOperationPanel.revalidate();
        this.changeOperationPanel.repaint();
        this.changeOperationPanel.add(this.rejectButton);
        this.changeOperationPanel.add(Box.createHorizontalStrut(12));
        this.changeOperationPanel.add(this.acceptButton);
    }

    private void initButtons() {
        String cmdReturnKey = BaseToolCallHandler.getCmdReturnKey();
        String cmdDeleteKey = BaseToolCallHandler.getCmdDeleteKey();
        Cursor handCursor = Cursor.getPredefinedCursor(12);
        this.acceptButton = ComponentUtil.createRoundRectLabel(String.format("%s %s", CosyBundle.message("inline.edit.accept.text", new Object[0]), cmdReturnKey), ColorUtil.getItemSelectionBackground(), handCursor, ColorUtil.getItemSelectionForeground(), 0, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                InlineChatPanel.this.acceptButtonClicked();
            }
        }, 8, 3, 8, 0);
        this.rejectButton = ComponentUtil.createRoundRectLabel(String.format("%s %s", CosyBundle.message("inline.edit.reject.text", new Object[0]), cmdDeleteKey), ColorUtil.getChatCardBackgroundColor(), handCursor, ColorUtil.getTextForegroundColor(), 0, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                InlineChatPanel.this.rejectButtonClicked();
            }
        }, 8, 3, 8, 0);
    }

    public void onEscapePressed() {
        if (!this.panelClosed.get()) {
            if (this.buttonState == InlineChatButtonStateEnum.WAIT_FOR_EDIT_FINISH || this.buttonState == InlineChatButtonStateEnum.WAIT_FOR_ASK_FINISH) {
                this.stopButtonClicked();
            } else if (this.buttonState == InlineChatButtonStateEnum.NEED_CONFIRM) {
                this.rejectButtonClicked();
            } else {
                this.removePanel();
            }
        }
    }

    public void onMetaEnterPressed() {
        if (!this.panelClosed.get()) {
            this.acceptButtonClicked();
        }
    }

    public void onMetaDeletePressed() {
        if (!this.panelClosed.get()) {
            this.rejectButtonClicked();
        }
    }

    @Generated
    public InEditorDiffRenderer getCurrentDiffRenderer() {
        return this.currentDiffRenderer;
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public ChatContext getChatContext() {
        return this.chatContext;
    }

    @Generated
    public boolean isFloatingMode() {
        return this.isFloatingMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/alibabacloud/intellij/qoder/ui/chat/inline/InlineChatPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuotaUsageExceptionMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/alibabacloud/intellij/qoder/ui/chat/inline/InlineChatPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleDocumentChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

