/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.chat.testagent.component.apply;

import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.apply.ApplyingFileItemPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.apply.ApplyingStageComponent;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.apply.ApplyingFileItem;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;

public class ApplyingFileListPanel
extends JPanel {
    private ApplyingStageComponent parentComponent;
    private JLabel summaryCountLabel;
    private Box fileListArea;

    public ApplyingFileListPanel(ApplyingStageComponent parentComponent) {
        this.parentComponent = parentComponent;
        this.setup();
    }

    private void setup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(true);
        this.setBackground(ColorUtil.getEditorBackgroundColor());
        this.setBorder((Border)new JBEmptyBorder(8, 12, 0, 12));
        JPanel summaryPanel = new JPanel();
        summaryPanel.setOpaque(false);
        summaryPanel.setLayout(new BorderLayout());
        summaryPanel.setPreferredSize(new Dimension(-1, 32));
        summaryPanel.setBorder(JBUI.Borders.customLine((Color)ColorUtil.getToolWindowBackgroundColor(), (int)0, (int)0, (int)2, (int)0));
        this.summaryCountLabel = new JLabel();
        this.summaryCountLabel.setFont(this.summaryCountLabel.getFont().deriveFont(13.0f));
        this.updateSummaryLabel();
        summaryPanel.add((Component)this.summaryCountLabel, "West");
        this.add(summaryPanel);
        this.fileListArea = Box.createVerticalBox();
        for (ApplyingFileItem file : this.parentComponent.getFileList()) {
            ApplyingFileItemPanel fileItemPanel = new ApplyingFileItemPanel(this, file.getTestFileUuid());
            this.fileListArea.add(fileItemPanel);
        }
        this.add(this.fileListArea);
    }

    private void updateSummaryLabel() {
        int fileCount = this.parentComponent.getFileList().size();
        int caseCount = 0;
        for (ApplyingFileItem file : this.parentComponent.getFileList()) {
            if (file.getTestCases() == null) continue;
            caseCount += file.getTestCases().size();
        }
        StringBuilder stringBuffer = new StringBuilder();
        if (fileCount <= 1) {
            stringBuffer.append(String.format(CosyBundle.message("test.agent.apply.fileList.summary.file", new Object[0]), fileCount));
        } else {
            stringBuffer.append(String.format(CosyBundle.message("test.agent.apply.fileList.summary.files", new Object[0]), fileCount));
        }
        if (caseCount == 1) {
            stringBuffer.append(CosyBundle.message("test.agent.apply.fileList.summary.case", new Object[0]));
        } else if (caseCount > 1) {
            stringBuffer.append(String.format(CosyBundle.message("test.agent.apply.fileList.summary.cases", new Object[0]), caseCount));
        }
        this.summaryCountLabel.setText(stringBuffer.toString());
    }

    public void updateAllFiles() {
        for (Component component : this.fileListArea.getComponents()) {
            if (!(component instanceof ApplyingFileItemPanel)) continue;
            ((ApplyingFileItemPanel)component).update();
        }
        this.updateSummaryLabel();
    }

    public void updateSingleFile(String fileUuid) {
        for (Component component : this.fileListArea.getComponents()) {
            if (!(component instanceof ApplyingFileItemPanel) || !((ApplyingFileItemPanel)component).getTestFileUuid().equals(fileUuid)) continue;
            ((ApplyingFileItemPanel)component).update();
            break;
        }
        this.updateSummaryLabel();
    }

    public Set<String> getCurrentSelectedTestCase() {
        HashSet<String> resultSet = new HashSet<String>();
        for (Component component : this.fileListArea.getComponents()) {
            if (!(component instanceof ApplyingFileItemPanel)) continue;
            resultSet.addAll(((ApplyingFileItemPanel)component).getCurrentSelectedTestCase());
        }
        return resultSet;
    }

    public void updateCheckBoxEnabledRecursively(Boolean isEnabled) {
        for (Component component : this.fileListArea.getComponents()) {
            if (!(component instanceof ApplyingFileItemPanel)) continue;
            ((ApplyingFileItemPanel)component).updateCheckBoxEnabledRecursively(isEnabled);
        }
    }

    public void stop() {
        for (Component component : this.fileListArea.getComponents()) {
            if (!(component instanceof ApplyingFileItemPanel)) continue;
            ((ApplyingFileItemPanel)component).stop();
        }
    }

    public void updateUiLanguage() {
        this.updateSummaryLabel();
        for (Component component : this.fileListArea.getComponents()) {
            if (!(component instanceof ApplyingFileItemPanel)) continue;
            ((ApplyingFileItemPanel)component).updateUiLanguage();
        }
    }

    @Generated
    public ApplyingStageComponent getParentComponent() {
        return this.parentComponent;
    }
}

