/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.chat.testagent.component.apply;

import com.alibabacloud.intellij.qoder.chat.model.StepProcessConfirmParam;
import com.alibabacloud.intellij.qoder.chat.model.result.StepProcessConfirmResult;
import com.alibabacloud.intellij.qoder.core.Cosy;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.apply.ApplyingStageComponent;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.enums.ApplyingConfirmActionEnum;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.apply.ApplyingConfirmResult;
import com.alibabacloud.intellij.qoder.ui.search.I18NConstant;
import com.alibabacloud.intellij.qoder.ui.search.color.CosyColor;
import com.alibabacloud.intellij.qoder.ui.search.component.DisplayLabel;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatStepEnum;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.ui.search.topic.AiDeveloperGenerateStreamStopNotifier;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ApplyingFooterPanel
extends JPanel {
    private ApplyingStageComponent parentComponent;
    DisplayLabel label;
    private static final int MARGIN = 8;
    private volatile boolean clicking = false;

    ApplyingFooterPanel(ApplyingStageComponent parentComponent) {
        this.parentComponent = parentComponent;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        this.update();
    }

    public void update() {
        Set<String> currentSelectedTestCaseSet = this.parentComponent.getCurrentSelectedTestCase();
        if (this.parentComponent.waitingMannualConfirm) {
            this.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
            if (this.label == null) {
                this.label = new DisplayLabel("", CosyColor.BLUE_BUTTON_COLOR, Color.WHITE);
                this.label.setCursor(Cursor.getPredefinedCursor(12));
                this.label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        if (ApplyingFooterPanel.this.clicking) {
                            return;
                        }
                        ApplyingFooterPanel.this.clicking = true;
                        ApplyingFooterPanel.this.label.setIcon(QoderIcons.StatusBarLoadingIcon);
                        ApplyingFooterPanel.this.parentComponent.fileListPanel.updateCheckBoxEnabledRecursively(false);
                        Set<String> currentSelectedTestCaseSet = ApplyingFooterPanel.this.parentComponent.getCurrentSelectedTestCase();
                        final Project project = ApplyingFooterPanel.this.parentComponent.project;
                        final String requestId = ApplyingFooterPanel.this.parentComponent.getChatStagePanel().getParentAnswerPanel().getRequestId();
                        final String sessionId = ApplyingFooterPanel.this.parentComponent.getChatStagePanel().getParentAnswerPanel().getSessionId();
                        ApplyingConfirmResult resultParam = new ApplyingConfirmResult();
                        final StepProcessConfirmParam param = new StepProcessConfirmParam();
                        param.setSessionId(sessionId);
                        param.setRequestId(requestId);
                        param.setStep(ChatStepEnum.TEST_AGENT_APPLY_TEST_CASES.getKey());
                        param.setConfirmResult(resultParam);
                        resultParam.setAction(ApplyingConfirmActionEnum.ACCEPT.name());
                        resultParam.setTestCaseUuids(currentSelectedTestCaseSet);
                        new Task.Backgroundable(project, I18NConstant.CONFIRM_TIP){

                            public void run(@NotNull ProgressIndicator indicator) {
                                StepProcessConfirmResult result;
                                if (indicator == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (Cosy.INSTANCE.checkCosy(project, false) && (result = Cosy.INSTANCE.getLanguageService(project).stepProcessConfirm(param, 10000L)) != null && result.isSuccessful()) {
                                    return;
                                }
                                try {
                                    SwingUtilities.invokeAndWait(() -> ((AiDeveloperGenerateStreamStopNotifier)project.getMessageBus().syncPublisher(AiDeveloperGenerateStreamStopNotifier.AI_DEVELOPER_GENERATE_STREAM_STOP_NOTIFICATION)).stop(requestId, sessionId, Integer.valueOf("605"), "confirm exception", null));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/alibabacloud/intellij/qoder/ui/chat/testagent/component/apply/ApplyingFooterPanel$1$1", "run"));
                            }
                        }.queue();
                    }
                });
                this.add((Component)this.label, "West");
                this.parentComponent.getChatStagePanel().getParentAnswerPanel().switchStateToWaiting();
            }
            this.label.setVisible(true);
            if (currentSelectedTestCaseSet.isEmpty()) {
                this.label.setText(CosyBundle.message("test.agent.apply.finish", new Object[0]));
            } else {
                this.label.setText(CosyBundle.message("test.agent.apply.confirm", new Object[0]));
            }
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
            if (this.label != null) {
                this.label.setVisible(false);
                this.label = null;
                this.clicking = false;
            }
            this.parentComponent.getChatStagePanel().getParentAnswerPanel().switchStateToGenerating();
        }
    }

    public void updateUiLanguage() {
        if (this.label != null) {
            Set<String> currentSelectedTestCaseSet = this.parentComponent.getCurrentSelectedTestCase();
            if (currentSelectedTestCaseSet.isEmpty()) {
                this.label.setText(CosyBundle.message("test.agent.apply.finish", new Object[0]));
            } else {
                this.label.setText(CosyBundle.message("test.agent.apply.confirm", new Object[0]));
            }
        }
    }
}

