/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.chat.testagent.component.apply;

import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.apply.ApplyingFileItemPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.apply.ApplyingTestCaseItemPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.enums.ApplyingTestCaseRunningStateEnum;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.apply.ApplyingTestCaseItem;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;

public class ApplyingTestCaseFolderPanel
extends JPanel {
    private ApplyingFileItemPanel parentPanel;
    private List<ApplyingTestCaseItem> testCases;
    private RoundRectPanel titlePanel;
    ThreeStateCheckBox checkBox;
    private JLabel expandLabel;
    private JLabel titleLabel;
    private Box textArea;
    private Boolean isExpanded;
    private Box testCaseArea;
    public static final int MIN_TOTAL_HEIGHT = 28;
    public static final int MIN_TITLE_PANEL_HEIGHT = 24;
    private MouseAdapter hoverMouseAdapter;
    public static final int LEFT_MARGIN = 24;
    private static final int FOLD_MARGIN = 8;
    private ApplyingTestCaseRunningStateEnum caseRunningState;

    ApplyingTestCaseFolderPanel(ApplyingFileItemPanel parentPanel, List<ApplyingTestCaseItem> testCases, ApplyingTestCaseRunningStateEnum caseRunningState) {
        this.parentPanel = parentPanel;
        this.testCases = testCases;
        this.isExpanded = false;
        this.caseRunningState = caseRunningState;
        this.hoverMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ApplyingTestCaseFolderPanel.this.onMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ApplyingTestCaseFolderPanel.this.onMouseExited();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ApplyingTestCaseFolderPanel.this.onMouseClickForExpand();
            }
        };
        this.setup();
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JPanel titleOuterPanel = new JPanel(new BorderLayout());
        titleOuterPanel.setOpaque(false);
        titleOuterPanel.setPreferredSize(new Dimension(-1, 28));
        JPanel emptyTopPanel = new JPanel();
        emptyTopPanel.setPreferredSize(new Dimension(-1, 2));
        emptyTopPanel.setOpaque(false);
        JPanel emptyBottomPanel = new JPanel();
        emptyBottomPanel.setPreferredSize(new Dimension(-1, 2));
        emptyBottomPanel.setOpaque(false);
        this.titlePanel = new RoundRectPanel(new BorderLayout());
        this.titlePanel.setOpaque(false);
        this.titlePanel.setBackground(this.parentPanel.getBackground());
        this.titlePanel.setPreferredSize(new Dimension(-1, 24));
        this.titlePanel.setMaximumSize(new Dimension(-1, 24));
        this.titlePanel.setMinimumSize(new Dimension(-1, 24));
        this.titlePanel.setBorder((Border)new JBEmptyBorder(0, 24, 0, 4));
        titleOuterPanel.add((Component)emptyTopPanel, "North");
        titleOuterPanel.add((Component)this.titlePanel, "Center");
        titleOuterPanel.add((Component)emptyBottomPanel, "South");
        this.testCaseArea = Box.createVerticalBox();
        this.testCaseArea.setOpaque(false);
        this.add((Component)titleOuterPanel, "North");
        this.add((Component)this.testCaseArea, "Center");
        this.textArea = Box.createHorizontalBox();
        this.textArea.setOpaque(false);
        this.expandLabel = new JLabel();
        this.expandLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.updateExpandLabel();
        this.textArea.add(this.expandLabel);
        this.textArea.add(Box.createHorizontalStrut(8));
        this.titleLabel = new JLabel();
        this.titleLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.updateTitleText();
        this.textArea.add(this.titleLabel);
        this.titlePanel.add((Component)this.textArea, "West");
        SwingUtil.foreachChildComponent(this.titlePanel, jComponent -> jComponent.addMouseListener(this.hoverMouseAdapter));
        this.checkBox = new ThreeStateCheckBox();
        this.checkBox.setBackground(this.parentPanel.getBackground());
        for (MouseListener mouseListener : this.checkBox.getMouseListeners()) {
            this.checkBox.removeMouseListener(mouseListener);
        }
        this.titlePanel.add((Component)this.checkBox, "East");
        this.checkBox.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ApplyingTestCaseFolderPanel.this.checkBox.isEnabled()) {
                    return;
                }
                ThreeStateCheckBox.State currentState = ApplyingTestCaseFolderPanel.this.checkBox.getState();
                if (ThreeStateCheckBox.State.SELECTED.equals((Object)currentState)) {
                    ApplyingTestCaseFolderPanel.this.updateCheckBoxStateRecursively(false);
                } else {
                    ApplyingTestCaseFolderPanel.this.updateCheckBoxStateRecursively(true);
                }
                ApplyingTestCaseFolderPanel.this.parentPanel.updateCheckBoxState();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ApplyingTestCaseFolderPanel.this.onMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ApplyingTestCaseFolderPanel.this.onMouseExited();
            }
        });
        for (ApplyingTestCaseItem testCaseItem : this.testCases) {
            ApplyingTestCaseItemPanel itemPanel = new ApplyingTestCaseItemPanel(this, testCaseItem);
            this.testCaseArea.add(itemPanel);
        }
        this.updateCheckBoxState();
        this.updateBodyPanelExpandState();
    }

    private void updateExpandLabel() {
        if (this.isExpanded.booleanValue()) {
            this.expandLabel.setIcon(QoderIcons.ArrowdownEmptyGreyIcon);
        } else {
            this.expandLabel.setIcon(QoderIcons.ArrowrightEmptyGreyIcon);
        }
    }

    private void updateBodyPanelExpandState() {
        this.testCaseArea.setVisible(this.isExpanded);
    }

    private void updateTitleText() {
        String template = "";
        if (ApplyingTestCaseRunningStateEnum.PASS.equals((Object)this.caseRunningState)) {
            template = this.testCases.size() == 1 ? CosyBundle.message("test.agent.apply.testcase.run.success", new Object[0]) : CosyBundle.message("test.agent.apply.testcases.run.success", new Object[0]);
        } else if (ApplyingTestCaseRunningStateEnum.FAILED.equals((Object)this.caseRunningState)) {
            template = this.testCases.size() == 1 ? CosyBundle.message("test.agent.apply.testcase.run.failed", new Object[0]) : CosyBundle.message("test.agent.apply.testcases.run.failed", new Object[0]);
        } else if (ApplyingTestCaseRunningStateEnum.COMPILE_ERROR.equals((Object)this.caseRunningState)) {
            template = this.testCases.size() == 1 ? CosyBundle.message("test.agent.apply.testcase.compile.failed", new Object[0]) : CosyBundle.message("test.agent.apply.testcases.compile.failed", new Object[0]);
        }
        if (this.titleLabel != null) {
            this.titleLabel.setText(String.format(template, this.testCases.size()));
        }
    }

    private void onMouseEntered() {
        this.titlePanel.setOpaque(true);
        this.titlePanel.setBackground(this.parentPanel.getFileListPanel().getParentComponent().getBackground());
        this.checkBox.setOpaque(true);
        this.checkBox.setBackground(this.parentPanel.getFileListPanel().getParentComponent().getBackground());
    }

    private void onMouseExited() {
        this.titlePanel.setOpaque(false);
        this.titlePanel.setBackground(this.parentPanel.getFileListPanel().getBackground());
        this.checkBox.setOpaque(false);
        this.checkBox.setBackground(this.parentPanel.getFileListPanel().getBackground());
    }

    private void onMouseClickForExpand() {
        this.isExpanded = this.isExpanded == false;
        this.updateExpandLabel();
        this.updateBodyPanelExpandState();
        if (this.isExpanded.booleanValue()) {
            this.parentPanel.getFileListPanel().getParentComponent().getChatStagePanel().getParentAnswerPanel().moveDownRelatively(this.testCaseArea.getHeight());
        }
    }

    public void updateCheckBoxState() {
        int selectedCount = 0;
        int unSelectedCount = 0;
        for (Component component : this.testCaseArea.getComponents()) {
            if (!(component instanceof ApplyingTestCaseItemPanel)) continue;
            if (((ApplyingTestCaseItemPanel)component).getIsCurrentSelected().booleanValue()) {
                ++selectedCount;
                continue;
            }
            ++unSelectedCount;
        }
        if (selectedCount > 0 && unSelectedCount == 0) {
            this.checkBox.setState(ThreeStateCheckBox.State.SELECTED);
        } else if (selectedCount > 0 && unSelectedCount > 0) {
            this.checkBox.setState(ThreeStateCheckBox.State.DONT_CARE);
        } else {
            this.checkBox.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        }
    }

    public void updateCheckBoxStateRecursively(Boolean isSelected) {
        this.checkBox.setState(isSelected != false ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED);
        for (Component component : this.testCaseArea.getComponents()) {
            if (!(component instanceof ApplyingTestCaseItemPanel)) continue;
            ((ApplyingTestCaseItemPanel)component).updateCheckBoxStateFromOutside(isSelected);
        }
    }

    public Set<String> getCurrentSelectedTestCase() {
        HashSet<String> resultSet = new HashSet<String>();
        for (Component component : this.testCaseArea.getComponents()) {
            if (!(component instanceof ApplyingTestCaseItemPanel) || !((ApplyingTestCaseItemPanel)component).getIsCurrentSelected().booleanValue()) continue;
            resultSet.add(((ApplyingTestCaseItemPanel)component).getTestCaseItem().getTestCaseUuid());
        }
        return resultSet;
    }

    public ThreeStateCheckBox.State getCurrentCheckBoxState() {
        return this.checkBox.getState();
    }

    public void updateCheckBoxEnabledRecursively(Boolean isEnabled) {
        this.checkBox.setEnabled(isEnabled.booleanValue());
        for (Component component : this.testCaseArea.getComponents()) {
            if (!(component instanceof ApplyingTestCaseItemPanel)) continue;
            ((ApplyingTestCaseItemPanel)component).updateCheckBoxEnabled(isEnabled);
        }
    }

    public void stop() {
        this.updateCheckBoxEnabledRecursively(false);
    }

    public void updateUiLanguage() {
        this.updateTitleText();
    }

    @Generated
    public ApplyingFileItemPanel getParentPanel() {
        return this.parentPanel;
    }
}

