/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.chat.testagent.component.apply;

import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.listener.CosyCurrentFileSelectionListener;
import com.alibabacloud.intellij.qoder.search.util.StringCheckUtil;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.apply.ApplyingDiffWindow;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.apply.ApplyingTestCaseFolderPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.enums.ApplyingFileStateEnum;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.enums.ApplyingTestCaseRunningStateEnum;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.apply.ApplyingFileItem;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.apply.ApplyingTestCaseItem;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.generate.GenerateCaseMethodParameterDTO;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.FileUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

public class ApplyingTestCaseItemPanel
extends JPanel {
    private static final Logger log = Logger.getInstance(ApplyingTestCaseItemPanel.class);
    private ApplyingTestCaseItem testCaseItem;
    private ApplyingTestCaseFolderPanel parentPanel;
    private JLabel methodNameLabel;
    private Box eastArea;
    private JBCheckBox checkBox;
    public static final float FILE_PATH_WIDTH_FULLFILE_RATIO = 0.35f;
    public static final float FILE_PATH_WIDTH_FULLFILE_RATIO_WITHOUT_SUMMARY = 0.8f;
    public static final float SUMMARY_WIDTH_FULLFILE_RATIO = 0.4f;
    private JLabel summaryLabel;
    private Boolean isCurrentSelected;
    private ApplyingDiffWindow notAppliedDiffWindow;
    public static final int MIN_TOTAL_HEIGHT = 28;
    public static final int MIN_TITLE_PANEL_HEIGHT = 24;
    private MouseAdapter hoverMouseAdapter;
    private RoundRectPanel bodyPanel;

    ApplyingTestCaseItemPanel(ApplyingTestCaseFolderPanel parentPanel, ApplyingTestCaseItem testCaseItem) {
        this.parentPanel = parentPanel;
        this.testCaseItem = testCaseItem;
        this.hoverMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ApplyingTestCaseItemPanel.this.onMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ApplyingTestCaseItemPanel.this.onMouseExited();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ApplyingTestCaseItemPanel.this.onMouseClickForDiffView();
            }
        };
        this.setup();
    }

    private void setup() {
        float actualFilePathRatio;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(-1, 28));
        JPanel emptyTopPanel = new JPanel();
        emptyTopPanel.setPreferredSize(new Dimension(-1, 2));
        emptyTopPanel.setOpaque(false);
        JPanel emptyBottomPanel = new JPanel();
        emptyBottomPanel.setPreferredSize(new Dimension(-1, 2));
        emptyBottomPanel.setOpaque(false);
        this.bodyPanel = new RoundRectPanel(new BorderLayout());
        this.bodyPanel.setPreferredSize(new Dimension(-1, 24));
        this.bodyPanel.setMaximumSize(new Dimension(-1, 24));
        this.bodyPanel.setMinimumSize(new Dimension(-1, 24));
        this.bodyPanel.setOpaque(false);
        this.bodyPanel.setBackground(this.parentPanel.getParentPanel().getFileListPanel().getBackground());
        this.bodyPanel.setBorder((Border)new JBEmptyBorder(0, 48, 0, 4));
        this.add((Component)emptyTopPanel, "North");
        this.add((Component)this.bodyPanel, "Center");
        this.add((Component)emptyBottomPanel, "South");
        this.methodNameLabel = new JLabel();
        if (ApplyingTestCaseRunningStateEnum.PASS.equals((Object)this.testCaseItem.getRunningState())) {
            this.methodNameLabel.setIcon(QoderIcons.TestRunSuccessIcon);
        } else if (ApplyingTestCaseRunningStateEnum.FAILED.equals((Object)this.testCaseItem.getRunningState())) {
            this.methodNameLabel.setIcon(QoderIcons.TestRunErrorIcon);
        } else if (ApplyingTestCaseRunningStateEnum.COMPILE_ERROR.equals((Object)this.testCaseItem.getRunningState())) {
            this.methodNameLabel.setIcon(QoderIcons.TestCompileErrorIcon);
        }
        this.bodyPanel.add((Component)this.methodNameLabel, "West");
        this.eastArea = Box.createHorizontalBox();
        this.eastArea.setOpaque(false);
        this.bodyPanel.add((Component)this.eastArea, "East");
        if (StringUtils.isNotBlank((String)this.testCaseItem.getSummary())) {
            actualFilePathRatio = 0.35f;
            this.summaryLabel = new JLabel();
            this.summaryLabel.setFont(this.summaryLabel.getFont().deriveFont(12.0f));
            this.summaryLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
            this.summaryLabel.setText(this.getDisplaySummary((int)((float)(this.getWidth() - 24 - 4 - 20) * 0.4f)));
            this.eastArea.add(this.summaryLabel);
            this.eastArea.add(Box.createHorizontalStrut(4));
        } else {
            actualFilePathRatio = 0.8f;
        }
        SwingUtil.foreachChildComponent(this.bodyPanel, jComponent -> {
            jComponent.addMouseListener(this.hoverMouseAdapter);
            jComponent.setToolTipText(this.testCaseItem.getSummary());
        });
        this.checkBox = new JBCheckBox();
        this.checkBox.setBackground(this.parentPanel.getBackground());
        this.checkBox.setSelected(this.testCaseItem.isApplied());
        this.isCurrentSelected = this.testCaseItem.isApplied();
        for (MouseListener mouseListener : this.checkBox.getMouseListeners()) {
            this.checkBox.removeMouseListener(mouseListener);
        }
        this.checkBox.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ApplyingTestCaseItemPanel.this.checkBox.isEnabled()) {
                    return;
                }
                ApplyingTestCaseItemPanel.this.isCurrentSelected = ApplyingTestCaseItemPanel.this.isCurrentSelected == false;
                ApplyingTestCaseItemPanel.this.checkBox.setSelected(ApplyingTestCaseItemPanel.this.isCurrentSelected.booleanValue());
                ApplyingTestCaseItemPanel.this.parentPanel.updateCheckBoxState();
                ApplyingTestCaseItemPanel.this.parentPanel.getParentPanel().updateCheckBoxState();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ApplyingTestCaseItemPanel.this.onMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ApplyingTestCaseItemPanel.this.onMouseExited();
            }
        });
        this.eastArea.add((Component)this.checkBox);
        this.methodNameLabel.setText(this.getDisplayMethodName((int)((float)(this.getWidth() - 24 - 4 - 20) * actualFilePathRatio)));
        this.bodyPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int totalWidth = e.getComponent().getWidth();
                int suitableFilePathWidth = (int)((float)(totalWidth - 24 - 4 - 20) * actualFilePathRatio);
                ApplyingTestCaseItemPanel.this.methodNameLabel.setText(ApplyingTestCaseItemPanel.this.getDisplayMethodName(suitableFilePathWidth));
                if (ApplyingTestCaseItemPanel.this.summaryLabel != null) {
                    ApplyingTestCaseItemPanel.this.summaryLabel.setText(ApplyingTestCaseItemPanel.this.getDisplaySummary((int)((float)(totalWidth - 24 - 4 - 20) * 0.4f)));
                }
            }
        });
    }

    private String getMethodName() {
        Object paramsType = "";
        for (int i = 0; i < this.testCaseItem.getParameterList().size(); ++i) {
            GenerateCaseMethodParameterDTO parameter = this.testCaseItem.getParameterList().get(i);
            paramsType = i < this.testCaseItem.getParameterList().size() - 1 ? (String)paramsType + parameter.getType() + ", " : (String)paramsType + parameter.getType();
        }
        return String.format("%s(%s)", this.testCaseItem.getMethodName(), paramsType);
    }

    private void onMouseEntered() {
        this.bodyPanel.setOpaque(true);
        this.bodyPanel.setBackground(this.parentPanel.getParentPanel().getFileListPanel().getParentComponent().getBackground());
        this.checkBox.setOpaque(true);
        this.checkBox.setBackground(this.parentPanel.getParentPanel().getFileListPanel().getParentComponent().getBackground());
    }

    private void onMouseExited() {
        this.bodyPanel.setOpaque(false);
        this.bodyPanel.setBackground(this.parentPanel.getParentPanel().getFileListPanel().getBackground());
        this.checkBox.setOpaque(false);
        this.checkBox.setBackground(this.parentPanel.getParentPanel().getFileListPanel().getBackground());
    }

    public void updateCheckBoxStateFromOutside(Boolean selectedState) {
        this.isCurrentSelected = selectedState;
        this.checkBox.setSelected(selectedState.booleanValue());
    }

    public void updateCheckBoxEnabled(Boolean isEnabled) {
        this.checkBox.setEnabled(isEnabled.booleanValue());
    }

    private void onMouseClickForDiffView() {
        ApplyingFileItem fileItem = this.parentPanel.getParentPanel().getFileListPanel().getParentComponent().getFileItemByFileUuid(this.parentPanel.getParentPanel().getTestFileUuid());
        if (ApplyingFileStateEnum.APPLIED.equals((Object)fileItem.getState())) {
            if (this.testCaseItem.isApplied()) {
                this.parentPanel.getParentPanel().openFileDiffView();
            } else {
                if (this.notAppliedDiffWindow != null) {
                    return;
                }
                String agentTestFilePath = this.testCaseItem.getAgentTestFilePath();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agentTestFilePath)) {
                    log.warn("getAgentTestFilePath is blank");
                    return;
                }
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByExtension(fileItem.getTestFileName().substring(fileItem.getTestFileName().lastIndexOf(".") + 1));
                VirtualFile emptyVirtualFile = FileUtil.buildVirtualFile(fileItem.getTestFileName(), fileType, "", false);
                VirtualFile agentVirtualFile = LocalFileSystem.getInstance().findFileByPath(agentTestFilePath);
                DiffContentFactory diffContentFactory = DiffContentFactory.getInstance();
                Project project = this.parentPanel.getParentPanel().getFileListPanel().getParentComponent().getProject();
                if (emptyVirtualFile == null) {
                    log.warn("emptyVirtualFile is blank");
                    return;
                }
                if (agentVirtualFile == null) {
                    log.warn("agentVirtualFile is blank: " + agentTestFilePath);
                    return;
                }
                emptyVirtualFile.putUserData(CosyCurrentFileSelectionListener.KEY_TEMP_FILE_SHOULD_NOT_QUOTE, (Object)true);
                agentVirtualFile.putUserData(CosyCurrentFileSelectionListener.KEY_TEMP_FILE_SHOULD_NOT_QUOTE, (Object)true);
                DiffContent beforeChangeContent = diffContentFactory.create(project, emptyVirtualFile);
                DiffContent afterChangeContent = diffContentFactory.create(project, agentVirtualFile);
                SimpleDiffRequest diffRequest = new SimpleDiffRequest("Applying Comparison", beforeChangeContent, afterChangeContent, "Before Change", "After Change");
                SimpleDiffRequestChain diffRequestChain = new SimpleDiffRequestChain((DiffRequest)diffRequest);
                DiffDialogHints diffDialogHints = DiffDialogHints.DEFAULT;
                this.notAppliedDiffWindow = new ApplyingDiffWindow(project, (DiffRequestChain)diffRequestChain, diffDialogHints);
            }
        }
    }

    private String getDisplayMethodName(int width) {
        int maxCharLength = Math.max(width / 6, 5);
        String methodName = this.getMethodName();
        if (methodName.length() <= maxCharLength) {
            return methodName;
        }
        return methodName.substring(0, maxCharLength) + "...";
    }

    private String getDisplaySummary(int width) {
        int maxCharLength = this.guessSummaryDisplayCharLengthByWidth(width);
        if (this.testCaseItem.getSummary().length() <= maxCharLength) {
            return this.testCaseItem.getSummary();
        }
        return this.testCaseItem.getSummary().substring(0, maxCharLength) + "...";
    }

    private void resetNotAppliedDiffWindow() {
        this.notAppliedDiffWindow = null;
    }

    private int guessSummaryDisplayCharLengthByWidth(int width) {
        String summary = this.testCaseItem.getSummary();
        int accumulatedWidth = 0;
        for (int i = 0; i < summary.length(); ++i) {
            char c = summary.charAt(i);
            accumulatedWidth = StringCheckUtil.isChineseChar(c) ? (accumulatedWidth += 12) : (accumulatedWidth += 6);
            if (accumulatedWidth < width) continue;
            return i + 1;
        }
        return summary.length();
    }

    @Generated
    public ApplyingTestCaseItem getTestCaseItem() {
        return this.testCaseItem;
    }

    @Generated
    public Boolean getIsCurrentSelected() {
        return this.isCurrentSelected;
    }
}

