/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.chat.testagent.component.checkEnv;

import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.checkEnv.CheckEnvBodyPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.checkEnv.CheckEnvItemSelectionComponent;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.enums.CheckEnvResultItemStatusEnum;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.checkEnv.CheckEnvConfirmResultItem;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.checkEnv.CheckEnvResultItem;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;

public class CheckEnvItemComponent
extends JPanel {
    private static final int ICON_TEXT_MARGIN = 8;
    private static final int PANEL_HEIGHT = 40;
    private static final int BORDER_VERTICAL_GAP = 12;
    private CheckEnvBodyPanel checkEnvBodyPanel;
    private CheckEnvResultItem checkItem;
    JLabel textLabel;
    JLabel statusIconLabel;
    JLabel statusLabel;
    CheckEnvItemSelectionComponent selectionComponent;
    private static final int BORDER_VERTICAL_HEIGHT = 8;

    public CheckEnvItemComponent(CheckEnvBodyPanel checkEnvBodyPanel, CheckEnvResultItem checkItem) {
        this.checkEnvBodyPanel = checkEnvBodyPanel;
        this.checkItem = checkItem;
        this.setup();
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setBorder((Border)new JBEmptyBorder(8, 0, 8, 0));
        Box westBox = Box.createHorizontalBox();
        Object textContent = this.checkItem.getCheckItemDescription();
        if (this.checkItem.isOptional()) {
            textContent = (String)textContent + " " + CosyBundle.message("test.agent.checkEnv.optional", new Object[0]);
        }
        this.textLabel = new JLabel((String)textContent);
        this.textLabel.setFont(this.textLabel.getFont().deriveFont(13.0f));
        this.statusIconLabel = new JLabel();
        this.updateStatusIcon();
        westBox.add(this.statusIconLabel);
        westBox.add(Box.createHorizontalStrut(8));
        westBox.add(this.textLabel);
        this.add((Component)westBox, "West");
        this.selectionComponent = new CheckEnvItemSelectionComponent(this, this.checkItem.getProperties());
        this.add((Component)this.selectionComponent, "East");
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(13.0f));
        this.statusLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.statusLabel.setBorder((Border)new JBEmptyBorder(0, 8, 0, 0));
        this.updateStatusText();
        this.add((Component)this.statusLabel, "Center");
    }

    public void update(CheckEnvResultItem checkItem) {
        this.checkItem = checkItem;
        this.updateStatusText();
        this.updateStatusIcon();
        this.selectionComponent.update(checkItem.getProperties(), checkItem.getCheckResult(), checkItem.getCheckItemKey(), checkItem.getCheckItemDescription(), checkItem.getMetaData());
        this.repaint();
        this.revalidate();
    }

    private void updateStatusIcon() {
        if (CheckEnvResultItemStatusEnum.PASSED.equals((Object)this.checkItem.getCheckResult())) {
            this.statusIconLabel.setIcon(QoderIcons.SuccessGreenIcon);
        } else if (this.checkItem.getCheckResult() == null) {
            this.statusIconLabel.setIcon(QoderIcons.PendingGreyIcon);
        } else if (CheckEnvResultItemStatusEnum.UNDETERMINED.equals((Object)this.checkItem.getCheckResult())) {
            this.statusIconLabel.setIcon(QoderIcons.SuccessGreenIcon);
        } else if (CheckEnvResultItemStatusEnum.UNSUPPORTED.equals((Object)this.checkItem.getCheckResult())) {
            this.statusIconLabel.setIcon(QoderIcons.AttentionYellowIcon);
        } else if (CheckEnvResultItemStatusEnum.NOT_FOUND.equals((Object)this.checkItem.getCheckResult())) {
            this.statusIconLabel.setIcon(QoderIcons.ErrorRedIcon);
        }
    }

    private void updateStatusText() {
        if (CheckEnvResultItemStatusEnum.NOT_FOUND.equals((Object)this.checkItem.getCheckResult())) {
            this.statusLabel.setText(CosyBundle.message("test.agent.checkEnv.status.notfound", new Object[0]));
        } else if (CheckEnvResultItemStatusEnum.UNSUPPORTED.equals((Object)this.checkItem.getCheckResult())) {
            this.statusLabel.setText(CosyBundle.message("test.agent.checkEnv.status.notsupport", new Object[0]));
        } else {
            this.statusLabel.setText("");
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(-1, 40);
    }

    public CheckEnvConfirmResultItem getSelectedResultItem() {
        CheckEnvConfirmResultItem resultItem = new CheckEnvConfirmResultItem();
        resultItem.setCheckItemKey(this.checkItem.getCheckItemKey());
        resultItem.setProperties(this.selectionComponent.getSelectedProperties());
        return resultItem;
    }

    @Generated
    public CheckEnvBodyPanel getCheckEnvBodyPanel() {
        return this.checkEnvBodyPanel;
    }

    @Generated
    public CheckEnvResultItem getCheckItem() {
        return this.checkItem;
    }
}

