/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.chat.testagent.component.checkEnv;

import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.checkEnv.CheckEnvStageComponent;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.enums.CheckEnvResultItemStatusEnum;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.checkEnv.CheckEnvResultItem;
import com.alibabacloud.intellij.qoder.ui.search.enums.ChatStepStatusEnum;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class CheckEnvTitlePanel
extends JPanel {
    private static final int MARGIN = 8;
    private CheckEnvStageComponent parentComponent;
    JLabel textLabel;
    JLabel statusLabel;
    JLabel actionLabel;

    public CheckEnvTitlePanel(CheckEnvStageComponent parentComponent) {
        this.parentComponent = parentComponent;
        this.setup();
    }

    public void updateBorderByExpanded() {
        int bottomBorder = this.parentComponent.isBodyPanelExpanded() ? 12 : 0;
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)bottomBorder, (int)12));
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        this.updateBorderByExpanded();
        Box box = Box.createHorizontalBox();
        this.textLabel = new JLabel(this.parentComponent.getDescription());
        this.textLabel.setFont(this.textLabel.getFont().deriveFont(13.0f));
        this.statusLabel = new JLabel();
        box.add(this.statusLabel);
        box.add(Box.createHorizontalStrut(8));
        box.add(this.textLabel);
        this.add((Component)box, "West");
        this.setBackground(ColorUtil.getChatCardChildBackgroundColor());
        this.update();
    }

    public void update() {
        List<CheckEnvResultItem> checkItemList = this.parentComponent.getCheckItemList();
        List checkingList = checkItemList.stream().filter(item -> item.getCheckResult() == null).collect(Collectors.toList());
        List notFoundList = checkItemList.stream().filter(item -> CheckEnvResultItemStatusEnum.NOT_FOUND.equals((Object)item.getCheckResult()) && !item.isOptional()).collect(Collectors.toList());
        List passedList = checkItemList.stream().filter(item -> CheckEnvResultItemStatusEnum.PASSED.equals((Object)item.getCheckResult())).collect(Collectors.toList());
        List unsupportedList = checkItemList.stream().filter(item -> CheckEnvResultItemStatusEnum.UNSUPPORTED.equals((Object)item.getCheckResult()) && !item.isOptional()).collect(Collectors.toList());
        List undeterminedList = checkItemList.stream().filter(item -> CheckEnvResultItemStatusEnum.UNDETERMINED.equals((Object)item.getCheckResult())).collect(Collectors.toList());
        if (ChatStepStatusEnum.ERROR.getKey().equals(this.parentComponent.getStatus()) || !notFoundList.isEmpty() || !unsupportedList.isEmpty()) {
            this.statusLabel.setIcon(QoderIcons.ErrorRedIcon);
        } else if (!checkingList.isEmpty()) {
            this.statusLabel.setIcon(QoderIcons.StatusBarLoadingIcon);
        } else {
            this.statusLabel.setIcon(QoderIcons.SuccessGreenIcon);
            if (this.actionLabel == null) {
                this.actionLabel = new JLabel();
                this.actionLabel.setPreferredSize(new Dimension(16, 16));
                this.actionLabel.setBorder((Border)JBUI.Borders.empty());
                this.actionLabel.setCursor(Cursor.getPredefinedCursor(12));
                this.add((Component)this.actionLabel, "East");
                this.actionLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        CheckEnvTitlePanel.this.parentComponent.changeBodyExpandState();
                        CheckEnvTitlePanel.this.updateActionLabel();
                    }
                });
            }
            this.updateActionLabel();
        }
    }

    private void updateActionLabel() {
        if (this.parentComponent.isBodyPanelExpanded()) {
            this.actionLabel.setIcon(QoderIcons.ArrowdownEmptyGreyIcon);
        } else {
            this.actionLabel.setIcon(QoderIcons.ArrowrightEmptyGreyIcon);
        }
    }
}

