/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.chat.testagent.component.generate;

import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.generate.GenerateCaseFileItemPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.generate.GenerateCaseFileListPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.generate.GenerateCaseMethodItemPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.generate.GenerateCaseClassDTO;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.generate.GenerateCaseFileDTO;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.generate.GenerateCaseMethodDTO;
import com.intellij.icons.AllIcons;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;

public class GenerateCaseClassItemPanel
extends JPanel {
    private String className;
    private GenerateCaseFileListPanel fileListPanel;
    private GenerateCaseFileItemPanel parentFileItemPanel;
    private JLabel classNameLabel;
    private Box methodArea;

    public GenerateCaseClassItemPanel(GenerateCaseFileListPanel fileListPanel, GenerateCaseFileItemPanel parentFileItemPanel, String className) {
        this.fileListPanel = fileListPanel;
        this.parentFileItemPanel = parentFileItemPanel;
        this.className = className;
        this.setup();
    }

    private void setup() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        JPanel methodNameContainerPanel = new JPanel(new BorderLayout());
        methodNameContainerPanel.setOpaque(false);
        methodNameContainerPanel.setBorder((Border)new JBEmptyBorder(0, 4, 0, 4));
        methodNameContainerPanel.setPreferredSize(new Dimension(-1, 28));
        this.add((Component)methodNameContainerPanel, "North");
        this.classNameLabel = new JLabel();
        this.classNameLabel.setText(this.getDisplayClassName((int)((float)(methodNameContainerPanel.getWidth() - 8 - 20) * 0.8f)));
        this.classNameLabel.setIcon(AllIcons.Nodes.Class);
        methodNameContainerPanel.add((Component)this.classNameLabel, "West");
        methodNameContainerPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int totalWidth = e.getComponent().getWidth();
                int suitableWidth = (int)((float)(totalWidth - 8 - 20) * 0.8f);
                GenerateCaseClassItemPanel.this.classNameLabel.setText(GenerateCaseClassItemPanel.this.getDisplayClassName(suitableWidth));
            }
        });
        this.methodArea = Box.createVerticalBox();
        this.methodArea.setOpaque(false);
        GenerateCaseFileDTO fileDTO = this.fileListPanel.getParentComponent().fileMap.get(this.parentFileItemPanel.getFilePath());
        GenerateCaseClassDTO classDTO = fileDTO.getClasses().stream().filter(item -> item.getName().equals(this.className)).findFirst().get();
        for (GenerateCaseMethodDTO methodItem : classDTO.getMethods()) {
            GenerateCaseMethodItemPanel methodItemPanel = new GenerateCaseMethodItemPanel(this.fileListPanel, this, methodItem.getUuid());
            this.methodArea.add(methodItemPanel);
        }
        this.add((Component)this.methodArea, "Center");
    }

    public void updateAllMethodsActionArea() {
        for (Component component : this.methodArea.getComponents()) {
            if (!(component instanceof GenerateCaseMethodItemPanel)) continue;
            ((GenerateCaseMethodItemPanel)component).updateActionArea();
        }
    }

    public void removeMethodInUI(GenerateCaseMethodItemPanel methodItemPanel) {
        this.methodArea.remove(methodItemPanel);
        if (this.methodArea.getComponents().length == 0) {
            this.parentFileItemPanel.removeClassInUI(this);
        }
    }

    public void stop() {
        for (Component component : this.methodArea.getComponents()) {
            if (!(component instanceof GenerateCaseMethodItemPanel)) continue;
            ((GenerateCaseMethodItemPanel)component).stop();
        }
    }

    public void updateUiLanguage() {
        for (Component component : this.methodArea.getComponents()) {
            if (!(component instanceof GenerateCaseMethodItemPanel)) continue;
            ((GenerateCaseMethodItemPanel)component).updateUiLanguage();
        }
    }

    private String getDisplayClassName(int width) {
        int maxCharLength = Math.max(width / 6, 20);
        if (this.className.length() <= maxCharLength) {
            return this.className;
        }
        return this.className.substring(0, maxCharLength) + "...";
    }

    public List<String> getCurrentSelectedMethodUuids() {
        ArrayList<String> methodUuids = new ArrayList<String>();
        for (Component component : this.methodArea.getComponents()) {
            if (!(component instanceof GenerateCaseMethodItemPanel) || !((GenerateCaseMethodItemPanel)component).isCurrentSelected()) continue;
            methodUuids.add(((GenerateCaseMethodItemPanel)component).getMethodUuid());
        }
        return methodUuids;
    }

    public void updateCheckBoxStateRecursively(Boolean isSelected) {
        for (Component component : this.methodArea.getComponents()) {
            if (!(component instanceof GenerateCaseMethodItemPanel)) continue;
            ((GenerateCaseMethodItemPanel)component).updateCheckBoxStateFromOutside(isSelected);
        }
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public GenerateCaseFileItemPanel getParentFileItemPanel() {
        return this.parentFileItemPanel;
    }

    @Generated
    public Box getMethodArea() {
        return this.methodArea;
    }
}

