/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.chat.testagent.component.generate;

import com.alibaba.fastjson.JSONObject;
import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.generate.GenerateCaseClassItemPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.generate.GenerateCaseFileListPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.generate.GenerateCaseMethodItemPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.generate.GenerateCaseClassDTO;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.generate.GenerateCaseFileDTO;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.generate.GenerateCaseMethodDTO;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.EditorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;

public class GenerateCaseFileItemPanel
extends JPanel {
    private static final Logger log = Logger.getInstance(GenerateCaseFileItemPanel.class);
    private static final int FOLD_MARGIN = 8;
    public static final int MIN_TOTAL_HEIGHT = 28;
    public static final int MIN_TITLE_PANEL_HEIGHT = 24;
    public static final int SIDE_MARGIN = 4;
    public static final float FILE_PATH_WIDTH_FULLFILE_RATIO = 0.8f;
    public static final int MIN_FILE_PATH_LENGTH = 20;
    public static final int WIDTH_PRE_CHAR = 6;
    private String filePath;
    private GenerateCaseFileListPanel fileListPanel;
    private JLabel expandLabel;
    private JLabel filePathLabel;
    private RoundRectPanel titlePanel;
    private Box classArea;
    private Box textArea;
    private ThreeStateCheckBox checkBox;
    private JLabel statusLabel;
    private Boolean isExpanded;
    private String projectBaseDirPath;
    private MouseAdapter hoverMouseAdapter;

    public GenerateCaseFileItemPanel(GenerateCaseFileListPanel fileListPanel, String filePath) {
        this.fileListPanel = fileListPanel;
        this.filePath = filePath;
        this.isExpanded = true;
        this.projectBaseDirPath = fileListPanel.getParentComponent().project.getBasePath();
        this.hoverMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                GenerateCaseFileItemPanel.this.onMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GenerateCaseFileItemPanel.this.onMouseExited();
            }
        };
        this.setup();
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JPanel titleOuterPanel = new JPanel(new BorderLayout());
        titleOuterPanel.setOpaque(false);
        titleOuterPanel.setPreferredSize(new Dimension(-1, 28));
        JPanel emptyTopPanel = new JPanel();
        emptyTopPanel.setPreferredSize(new Dimension(-1, 2));
        emptyTopPanel.setOpaque(false);
        JPanel emptyBottomPanel = new JPanel();
        emptyBottomPanel.setPreferredSize(new Dimension(-1, 2));
        emptyBottomPanel.setOpaque(false);
        this.titlePanel = new RoundRectPanel(new BorderLayout());
        this.titlePanel.setBackground(this.fileListPanel.getBackground());
        this.titlePanel.setPreferredSize(new Dimension(-1, 24));
        this.titlePanel.setMaximumSize(new Dimension(-1, 24));
        this.titlePanel.setMinimumSize(new Dimension(-1, 24));
        this.titlePanel.setOpaque(false);
        this.titlePanel.setBorder((Border)new JBEmptyBorder(0, 4, 0, 4));
        this.classArea = Box.createVerticalBox();
        this.classArea.setOpaque(false);
        titleOuterPanel.add((Component)emptyTopPanel, "North");
        titleOuterPanel.add((Component)this.titlePanel, "Center");
        titleOuterPanel.add((Component)emptyBottomPanel, "South");
        this.add((Component)titleOuterPanel, "North");
        this.add((Component)this.classArea, "Center");
        this.textArea = Box.createHorizontalBox();
        this.textArea.setOpaque(false);
        this.expandLabel = new JLabel();
        this.expandLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.expandLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GenerateCaseFileItemPanel.this.isExpanded = GenerateCaseFileItemPanel.this.isExpanded == false;
                GenerateCaseFileItemPanel.this.updateExpandLabel();
                GenerateCaseFileItemPanel.this.classArea.setVisible(GenerateCaseFileItemPanel.this.isExpanded);
                if (GenerateCaseFileItemPanel.this.isExpanded.booleanValue()) {
                    GenerateCaseFileItemPanel.this.fileListPanel.getParentComponent().chatStagePanel.getParentAnswerPanel().moveDownRelatively(GenerateCaseFileItemPanel.this.classArea.getHeight());
                }
            }
        });
        this.updateExpandLabel();
        this.textArea.add(this.expandLabel);
        this.textArea.add(Box.createHorizontalStrut(8));
        this.filePathLabel = new JLabel(this.getDisplayFileName((int)((float)(this.titlePanel.getWidth() - this.expandLabel.getWidth() - 8 - 8) * 0.8f)));
        this.textArea.add(this.filePathLabel);
        this.titlePanel.add((Component)this.textArea, "West");
        this.filePathLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GenerateCaseFileItemPanel.this.openFileInEditor();
            }
        });
        this.titlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GenerateCaseFileItemPanel.this.openFileInEditor();
            }
        });
        this.checkBox = new ThreeStateCheckBox(ThreeStateCheckBox.State.SELECTED);
        this.checkBox.setBackground(this.fileListPanel.getBackground());
        for (MouseListener mouseListener : this.checkBox.getMouseListeners()) {
            this.checkBox.removeMouseListener(mouseListener);
        }
        this.checkBox.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!GenerateCaseFileItemPanel.this.checkBox.isEnabled()) {
                    return;
                }
                ThreeStateCheckBox.State currentState = GenerateCaseFileItemPanel.this.checkBox.getState();
                GenerateCaseFileItemPanel.this.updateCheckBoxStateRecursively(!ThreeStateCheckBox.State.SELECTED.equals((Object)currentState));
            }
        });
        this.statusLabel = new JLabel();
        this.statusLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.updateActionArea();
        for (GenerateCaseClassDTO classItem : this.fileListPanel.getParentComponent().fileMap.get(this.filePath).getClasses()) {
            GenerateCaseClassItemPanel classItemPanel = new GenerateCaseClassItemPanel(this.fileListPanel, this, classItem.getName());
            this.classArea.add(classItemPanel);
        }
        this.titlePanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GenerateCaseFileItemPanel.this.adjustFilePathLabelLength();
            }
        });
        SwingUtil.foreachChildComponent(this.titlePanel, jComponent -> jComponent.addMouseListener(this.hoverMouseAdapter));
        this.statusLabel.addMouseListener(this.hoverMouseAdapter);
    }

    private void updateCheckBoxStateRecursively(Boolean isSelected) {
        this.checkBox.setState(isSelected != false ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED);
        for (Component component : this.classArea.getComponents()) {
            if (!(component instanceof GenerateCaseClassItemPanel)) continue;
            ((GenerateCaseClassItemPanel)component).updateCheckBoxStateRecursively(isSelected);
        }
        if (this.fileListPanel.getParentComponent().footerPanel != null) {
            this.fileListPanel.getParentComponent().footerPanel.update();
        }
    }

    private void adjustFilePathLabelLength() {
        int totalWidth = this.titlePanel.getWidth();
        int suitableWidth = (int)((float)(totalWidth - this.expandLabel.getWidth() - 8 - 8 - ((BorderLayout)this.titlePanel.getLayout()).getLayoutComponent("East").getWidth()) * 0.8f);
        this.filePathLabel.setText(this.getDisplayFileName(suitableWidth));
    }

    private void updateExpandLabel() {
        if (this.isExpanded.booleanValue()) {
            this.expandLabel.setIcon(QoderIcons.ArrowdownEmptyGreyIcon);
        } else {
            this.expandLabel.setIcon(QoderIcons.ArrowrightEmptyGreyIcon);
        }
    }

    private String getDisplayFileName(int width) {
        String relativePath = this.filePath;
        if (this.filePath.startsWith(this.projectBaseDirPath)) {
            relativePath = this.filePath.substring(this.projectBaseDirPath.length());
        }
        int maxCharLength = Math.max(width / 6, 20);
        if (relativePath.length() <= maxCharLength) {
            return relativePath;
        }
        return "..." + relativePath.substring(relativePath.length() - maxCharLength);
    }

    public void updateAllActionArea() {
        for (Component component : this.classArea.getComponents()) {
            if (!(component instanceof GenerateCaseClassItemPanel)) continue;
            ((GenerateCaseClassItemPanel)component).updateAllMethodsActionArea();
        }
        this.updateActionArea();
    }

    public void removeClassInUI(GenerateCaseClassItemPanel classItemPanel) {
        this.classArea.remove(classItemPanel);
        if (this.classArea.getComponents().length == 0) {
            this.fileListPanel.removeFileItemInUI(this);
        }
    }

    public boolean updateSingleMethodActionArea(String methodUuid) {
        boolean updated = false;
        block0: for (Component classComponent : this.classArea.getComponents()) {
            if (!(classComponent instanceof GenerateCaseClassItemPanel)) continue;
            for (Component methodComponent : ((GenerateCaseClassItemPanel)classComponent).getMethodArea().getComponents()) {
                GenerateCaseMethodItemPanel methodItemPanel;
                if (!(methodComponent instanceof GenerateCaseMethodItemPanel) || !(methodItemPanel = (GenerateCaseMethodItemPanel)methodComponent).getMethodUuid().equals(methodUuid)) continue;
                methodItemPanel.updateActionArea();
                updated = true;
                break block0;
            }
        }
        if (updated) {
            this.updateActionArea();
        }
        return updated;
    }

    private void updateActionArea() {
        Component component;
        int totalMethodCount = 0;
        int needConfirmMethodCount = 0;
        int waitingMethodCount = 0;
        int runningMethodCount = 0;
        int finishedMethodCount = 0;
        int cancelMethodCount = 0;
        boolean hasFailedCases = false;
        GenerateCaseFileDTO generateCaseFileDTO = this.fileListPanel.getParentComponent().fileMap.get(this.filePath);
        if (generateCaseFileDTO != null && generateCaseFileDTO.getClasses() != null) {
            for (GenerateCaseClassDTO classItem : generateCaseFileDTO.getClasses()) {
                for (GenerateCaseMethodDTO methodItem : classItem.getMethods()) {
                    ++totalMethodCount;
                    if (methodItem.getState() == null || methodItem.getState().isNeedConfirm().booleanValue()) {
                        ++needConfirmMethodCount;
                    } else if (methodItem.getState().isWaiting().booleanValue()) {
                        ++waitingMethodCount;
                    } else if (methodItem.getState().isFinished().booleanValue()) {
                        ++finishedMethodCount;
                    } else if (methodItem.getState().isRunning().booleanValue()) {
                        ++runningMethodCount;
                    } else if (methodItem.getState().isCanceled().booleanValue()) {
                        ++cancelMethodCount;
                    }
                    if (methodItem.getStatistics() == null || hasFailedCases || methodItem.getStatistics().getCaseCompileFailedCount() <= 0 && methodItem.getStatistics().getCaseRunningFailedCount() <= 0 && methodItem.getStatistics().getCaseRunningSkippedCount() <= 0) continue;
                    hasFailedCases = true;
                }
            }
        } else {
            log.warn("updateActionArea filePath=" + this.filePath + "generateCaseFileDTO=" + JSONObject.toJSONString((Object)generateCaseFileDTO));
        }
        if (needConfirmMethodCount == totalMethodCount) {
            component = ((BorderLayout)this.titlePanel.getLayout()).getLayoutComponent("East");
            if (component != this.checkBox && component != null) {
                this.titlePanel.remove(component);
            }
            this.titlePanel.add((Component)this.checkBox, "East");
            this.adjustFilePathLabelLength();
        } else {
            this.statusLabel.setText(String.format("%d / %d", finishedMethodCount, totalMethodCount));
            if (finishedMethodCount == totalMethodCount) {
                if (hasFailedCases) {
                    this.statusLabel.setIcon(QoderIcons.AttentionYellowIcon);
                } else {
                    this.statusLabel.setIcon(QoderIcons.SuccessGreenIcon);
                }
            } else if (waitingMethodCount == totalMethodCount) {
                this.statusLabel.setIcon(QoderIcons.PendingGreyIcon);
            } else if (cancelMethodCount > 0) {
                this.statusLabel.setIcon(QoderIcons.ErrorRedIcon);
            } else if (runningMethodCount > 0) {
                this.statusLabel.setIcon(QoderIcons.StatusBarLoadingIcon);
            }
            component = ((BorderLayout)this.titlePanel.getLayout()).getLayoutComponent("East");
            if (component != null && component != this.statusLabel) {
                this.titlePanel.remove(component);
            }
            this.titlePanel.add((Component)this.statusLabel, "East");
            this.adjustFilePathLabelLength();
        }
    }

    private void onMouseEntered() {
        this.titlePanel.setOpaque(true);
        this.titlePanel.setBackground(this.fileListPanel.getParentComponent().getBackground());
        this.checkBox.setOpaque(true);
        this.checkBox.setBackground(this.fileListPanel.getParentComponent().getBackground());
    }

    private void onMouseExited() {
        this.titlePanel.setOpaque(false);
        this.titlePanel.setBackground(this.fileListPanel.getBackground());
        this.checkBox.setOpaque(false);
        this.checkBox.setBackground(this.fileListPanel.getBackground());
    }

    public void stop() {
        this.checkBox.setEnabled(false);
        for (Component component : this.classArea.getComponents()) {
            if (!(component instanceof GenerateCaseClassItemPanel)) continue;
            ((GenerateCaseClassItemPanel)component).stop();
        }
        this.updateActionArea();
    }

    public void updateUiLanguage() {
        for (Component component : this.classArea.getComponents()) {
            if (!(component instanceof GenerateCaseClassItemPanel)) continue;
            ((GenerateCaseClassItemPanel)component).updateUiLanguage();
        }
    }

    private void openFileInEditor() {
        GenerateCaseFileDTO generateCaseFileDTO = this.fileListPanel.getParentComponent().fileMap.get(this.filePath);
        if (generateCaseFileDTO != null && BooleanUtils.isTrue((Boolean)generateCaseFileDTO.getBelongsToWorkingSpace())) {
            EditorUtil.openEditorFile(this.fileListPanel.getParentComponent().project, generateCaseFileDTO.getWorkingSpaceFilePath(), null, this.filePathLabel);
        } else {
            EditorUtil.openEditorFile(this.fileListPanel.getParentComponent().project, this.filePath, null, this.filePathLabel);
        }
    }

    public List<String> getCurrentSelectedMethodUuids() {
        ArrayList<String> methodUuids = new ArrayList<String>();
        for (Component component : this.classArea.getComponents()) {
            if (!(component instanceof GenerateCaseClassItemPanel)) continue;
            methodUuids.addAll(((GenerateCaseClassItemPanel)component).getCurrentSelectedMethodUuids());
        }
        return methodUuids;
    }

    public void updateCheckBoxState() {
        int selectedCount = 0;
        int totalCount = 0;
        for (Component classComponent : this.classArea.getComponents()) {
            if (!(classComponent instanceof GenerateCaseClassItemPanel)) continue;
            for (Component methodComponent : ((GenerateCaseClassItemPanel)classComponent).getMethodArea().getComponents()) {
                if (!(methodComponent instanceof GenerateCaseMethodItemPanel)) continue;
                ++totalCount;
                GenerateCaseMethodItemPanel methodItemPanel = (GenerateCaseMethodItemPanel)methodComponent;
                if (!methodItemPanel.isCurrentSelected()) continue;
                ++selectedCount;
            }
        }
        if (totalCount == selectedCount) {
            this.checkBox.setState(ThreeStateCheckBox.State.SELECTED);
        } else if (selectedCount == 0) {
            this.checkBox.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        } else {
            this.checkBox.setState(ThreeStateCheckBox.State.DONT_CARE);
        }
        if (this.fileListPanel.getParentComponent().footerPanel != null) {
            this.fileListPanel.getParentComponent().footerPanel.update();
        }
    }

    public boolean isSelected() {
        return this.checkBox.getState() != ThreeStateCheckBox.State.NOT_SELECTED;
    }

    @Generated
    public String getFilePath() {
        return this.filePath;
    }
}

