/*
 * Decompiled with CFR 0.152.
 */
package com.alibabacloud.intellij.qoder.ui.chat.testagent.component.generate;

import com.alibabacloud.intellij.qoder.icons.QoderIcons;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.generate.GenerateCaseClassItemPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.component.generate.GenerateCaseFileListPanel;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.enums.GenerateCaseMethodStateEnum;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.generate.GenerateCaseFileDTO;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.generate.GenerateCaseMethodDTO;
import com.alibabacloud.intellij.qoder.ui.chat.testagent.model.generate.GenerateCaseMethodParameterDTO;
import com.alibabacloud.intellij.qoder.ui.notifications.NotificationFactory;
import com.alibabacloud.intellij.qoder.ui.search.component.RoundRectPanel;
import com.alibabacloud.intellij.qoder.ui.search.location.CosyBundle;
import com.alibabacloud.intellij.qoder.util.ColorUtil;
import com.alibabacloud.intellij.qoder.util.SwingUtil;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

public class GenerateCaseMethodItemPanel
extends JPanel {
    private String methodUuid;
    private GenerateCaseFileListPanel fileListPanel;
    private GenerateCaseClassItemPanel parentClassPanel;
    private static final int LEFT_MARGIN = 24;
    private Box actionArea;
    private JBCheckBox checkBox;
    private JLabel runningStatusLabel;
    private JLabel methodNameLabel;
    private RoundRectPanel bodyPanel;
    public static final int MIN_TOTAL_HEIGHT = 28;
    public static final int MIN_TITLE_PANEL_HEIGHT = 24;
    private MouseAdapter hoverMouseAdapter;
    private JLabel runningSuccessIcon;
    private JLabel runningFailedLabel;
    private JLabel compileErrorIcon;

    public GenerateCaseMethodItemPanel(GenerateCaseFileListPanel parentComponent, GenerateCaseClassItemPanel parentClassPanel, String methodUuid) {
        this.fileListPanel = parentComponent;
        this.parentClassPanel = parentClassPanel;
        this.methodUuid = methodUuid;
        this.hoverMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                GenerateCaseMethodItemPanel.this.onMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GenerateCaseMethodItemPanel.this.onMouseExited();
            }
        };
        this.setup();
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(-1, 28));
        JPanel emptyTopPanel = new JPanel();
        emptyTopPanel.setPreferredSize(new Dimension(-1, 2));
        emptyTopPanel.setOpaque(false);
        JPanel emptyBottomPanel = new JPanel();
        emptyBottomPanel.setPreferredSize(new Dimension(-1, 2));
        emptyBottomPanel.setOpaque(false);
        this.bodyPanel = new RoundRectPanel(new BorderLayout());
        this.bodyPanel.setBackground(this.fileListPanel.getBackground());
        this.bodyPanel.setPreferredSize(new Dimension(-1, 24));
        this.bodyPanel.setMaximumSize(new Dimension(-1, 24));
        this.bodyPanel.setMinimumSize(new Dimension(-1, 24));
        this.bodyPanel.setOpaque(false);
        this.bodyPanel.setBorder((Border)new JBEmptyBorder(0, 24, 0, 4));
        this.add((Component)emptyTopPanel, "North");
        this.add((Component)this.bodyPanel, "Center");
        this.add((Component)emptyBottomPanel, "South");
        this.methodNameLabel = new JLabel();
        this.methodNameLabel.setIcon(AllIcons.Nodes.Method);
        this.methodNameLabel.setText(this.getDisplayMethodName((int)((float)(this.getWidth() - 24 - 4 - 20) * 0.8f)));
        this.actionArea = Box.createHorizontalBox();
        this.actionArea.setOpaque(false);
        this.checkBox = new JBCheckBox();
        this.checkBox.setBackground(this.fileListPanel.getBackground());
        this.checkBox.setSelected(true);
        for (MouseListener mouseListener : this.checkBox.getMouseListeners()) {
            this.checkBox.removeMouseListener(mouseListener);
        }
        this.checkBox.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!GenerateCaseMethodItemPanel.this.checkBox.isEnabled()) {
                    return;
                }
                GenerateCaseMethodItemPanel.this.checkBox.setSelected(!GenerateCaseMethodItemPanel.this.checkBox.isSelected());
                GenerateCaseMethodItemPanel.this.parentClassPanel.getParentFileItemPanel().updateCheckBoxState();
            }
        });
        this.runningStatusLabel = new JLabel();
        this.runningStatusLabel.setFont(this.runningStatusLabel.getFont().deriveFont(12.0f));
        this.runningStatusLabel.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        this.updateActionArea();
        this.bodyPanel.add((Component)this.methodNameLabel, "West");
        this.bodyPanel.add((Component)this.actionArea, "East");
        this.bodyPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int totalWidth = e.getComponent().getWidth();
                int suitableWidth = (int)((float)(totalWidth - 24 - 4 - 20 - GenerateCaseMethodItemPanel.this.actionArea.getWidth()) * 0.8f);
                GenerateCaseMethodItemPanel.this.methodNameLabel.setText(GenerateCaseMethodItemPanel.this.getDisplayMethodName(suitableWidth));
            }
        });
        this.bodyPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GenerateCaseMethodItemPanel.this.navigate2Method();
            }
        });
        this.methodNameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GenerateCaseMethodItemPanel.this.navigate2Method();
            }
        });
        SwingUtil.foreachChildComponent(this.bodyPanel, jComponent -> jComponent.addMouseListener(this.hoverMouseAdapter));
    }

    private String getMethodName() {
        Object paramsType = "";
        GenerateCaseMethodDTO methodItem = this.fileListPanel.getParentComponent().methodMap.get(this.methodUuid);
        for (int i = 0; i < methodItem.getParameterList().size(); ++i) {
            GenerateCaseMethodParameterDTO parameter = methodItem.getParameterList().get(i);
            paramsType = i < methodItem.getParameterList().size() - 1 ? (String)paramsType + parameter.getType() + ", " : (String)paramsType + parameter.getType();
        }
        return String.format("%s(%s)", methodItem.getName(), paramsType);
    }

    private String getDisplayMethodName(int width) {
        int maxCharLength = Math.max(width / 6, 20);
        String methodName = this.getMethodName();
        if (methodName.length() <= maxCharLength) {
            return methodName;
        }
        return methodName.substring(0, maxCharLength) + "...";
    }

    public void updateActionArea() {
        this.actionArea.removeAll();
        GenerateCaseMethodDTO methodItem = this.fileListPanel.getParentComponent().methodMap.get(this.methodUuid);
        if (methodItem == null) {
            this.parentClassPanel.removeMethodInUI(this);
            return;
        }
        if (GenerateCaseMethodStateEnum.NEED_CONFIRM.equals((Object)methodItem.getState())) {
            this.actionArea.add((Component)this.checkBox);
        } else if (GenerateCaseMethodStateEnum.PENDING.equals((Object)methodItem.getState())) {
            this.runningStatusLabel.setIcon(QoderIcons.PendingGreyIcon);
            this.runningStatusLabel.setText(CosyBundle.message("test.agent.generateCase.method.state.pending", new Object[0]));
            this.actionArea.add(this.runningStatusLabel);
        } else if (GenerateCaseMethodStateEnum.GENERATING.equals((Object)methodItem.getState())) {
            this.runningStatusLabel.setIcon(QoderIcons.StatusBarLoadingIcon);
            this.runningStatusLabel.setText(CosyBundle.message("test.agent.generateCase.method.state.generating", new Object[0]));
            this.actionArea.add(this.runningStatusLabel);
        } else if (GenerateCaseMethodStateEnum.COMPILING.equals((Object)methodItem.getState())) {
            this.runningStatusLabel.setIcon(QoderIcons.StatusBarLoadingIcon);
            this.runningStatusLabel.setText(CosyBundle.message("test.agent.generateCase.method.state.compiling", new Object[0]));
            this.actionArea.add(this.runningStatusLabel);
        } else if (GenerateCaseMethodStateEnum.FIXING.equals((Object)methodItem.getState())) {
            this.runningStatusLabel.setIcon(QoderIcons.StatusBarLoadingIcon);
            this.runningStatusLabel.setText(CosyBundle.message("test.agent.generateCase.method.state.fixing", new Object[0]));
            this.actionArea.add(this.runningStatusLabel);
        } else if (GenerateCaseMethodStateEnum.RUNNING.equals((Object)methodItem.getState())) {
            this.runningStatusLabel.setIcon(QoderIcons.StatusBarLoadingIcon);
            this.runningStatusLabel.setText(CosyBundle.message("test.agent.generateCase.method.state.running", new Object[0]));
            this.actionArea.add(this.runningStatusLabel);
        } else if (GenerateCaseMethodStateEnum.CANCELED.equals((Object)methodItem.getState())) {
            this.runningStatusLabel.setIcon(QoderIcons.ErrorRedIcon);
            this.runningStatusLabel.setText(CosyBundle.message("test.agent.generateCase.method.state.canceled", new Object[0]));
            this.actionArea.add(this.runningStatusLabel);
        } else if (GenerateCaseMethodStateEnum.FINISH.equals((Object)methodItem.getState()) && methodItem.getStatistics() != null) {
            this.runningSuccessIcon = this.createClickableStatusIcon(QoderIcons.TestRunSuccessIcon, String.valueOf(methodItem.getStatistics().getCaseRunningSuccessCount()), CosyBundle.message("test.agent.run.success.icon.tooltips", new Object[0]), e -> this.showTestCasesContent(methodItem));
            this.actionArea.add(this.runningSuccessIcon);
            this.actionArea.add(Box.createHorizontalStrut(12));
            this.runningFailedLabel = this.createClickableStatusIcon(QoderIcons.TestRunErrorIcon, String.valueOf(methodItem.getStatistics().getCaseRunningFailedCount() + methodItem.getStatistics().getCaseRunningSkippedCount()), CosyBundle.message("test.agent.run.fail.icon.tooltips", new Object[0]), e -> this.showTestCasesContent(methodItem));
            this.actionArea.add(this.runningFailedLabel);
            this.actionArea.add(Box.createHorizontalStrut(12));
            this.compileErrorIcon = this.createClickableStatusIcon(QoderIcons.TestCompileErrorIcon, String.valueOf(methodItem.getStatistics().getCaseCompileFailedCount()), CosyBundle.message("test.agent.compile.error.icon.tooltips", new Object[0]), e -> this.showTestCasesContent(methodItem));
            this.actionArea.add(this.compileErrorIcon);
            int suitableWidth = (int)((float)(this.getWidth() - 24 - 4 - 20 - this.actionArea.getWidth()) * 0.8f);
            this.methodNameLabel.setText(this.getDisplayMethodName(suitableWidth));
            this.actionArea.setPreferredSize(this.actionArea.getMinimumSize());
        }
        SwingUtil.foreachChildComponent(this.actionArea, jComponent -> jComponent.addMouseListener(this.hoverMouseAdapter));
    }

    private JLabel createClickableStatusIcon(Icon icon, String text, String tooltip, final Consumer<MouseEvent> clickListener) {
        JLabel label = new JLabel();
        label.setIcon(icon);
        label.setText(text);
        label.setToolTipText(tooltip);
        label.setPreferredSize(new Dimension(40, -1));
        label.setFont(this.runningStatusLabel.getFont().deriveFont(12.0f));
        label.setForeground(ColorUtil.getAuxiliaryForegroundColor());
        label.setCursor(Cursor.getPredefinedCursor(12));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                clickListener.accept(e);
            }
        });
        return label;
    }

    private void showTestCasesContent(GenerateCaseMethodDTO methodItem) {
        if (methodItem == null || StringUtils.isBlank((String)methodItem.getTempTestFilePath())) {
            NotificationFactory.showToast((JComponent)this.methodNameLabel, MessageType.ERROR, CosyBundle.message("test.agent.generateCase.method.cases.not.found", new Object[0]));
            return;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile testFile = localFileSystem.findFileByPath(methodItem.getTempTestFilePath());
        if (testFile == null || !testFile.exists()) {
            NotificationFactory.showToast((JComponent)this.methodNameLabel, MessageType.ERROR, CosyBundle.message("test.agent.generateCase.method.cases.not.found", new Object[0]));
            return;
        }
        EmptyContent originalContent = DiffContentFactory.getInstance().createEmpty();
        DiffContent modifiedContent = DiffContentFactory.getInstance().create(this.fileListPanel.getParentComponent().project, testFile);
        SimpleDiffRequest request = new SimpleDiffRequest(testFile.getName(), (DiffContent)originalContent, modifiedContent, null, testFile.getPath());
        request.putUserData(DiffUserDataKeys.FORCE_READ_ONLY, (Object)true);
        SwingUtilities.invokeLater(() -> WriteAction.run(() -> DiffManager.getInstance().showDiff(this.fileListPanel.getParentComponent().project, (DiffRequest)request, DiffDialogHints.DEFAULT)));
    }

    private void onMouseEntered() {
        this.bodyPanel.setOpaque(true);
        this.bodyPanel.setBackground(this.fileListPanel.getParentComponent().getBackground());
        this.checkBox.setOpaque(true);
        this.checkBox.setBackground(this.fileListPanel.getParentComponent().getBackground());
    }

    private void onMouseExited() {
        this.bodyPanel.setOpaque(false);
        this.bodyPanel.setBackground(this.fileListPanel.getBackground());
        this.checkBox.setOpaque(false);
        this.checkBox.setBackground(this.fileListPanel.getBackground());
    }

    private void navigate2Method() {
        PsiMethod method;
        PsiFile psiFile;
        FileEditorManager fileEditorManager;
        Editor editor;
        GenerateCaseMethodDTO methodItem = this.fileListPanel.getParentComponent().methodMap.get(this.methodUuid);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        GenerateCaseFileDTO generateCaseFileDTO = this.fileListPanel.getParentComponent().fileMap.get(this.parentClassPanel.getParentFileItemPanel().getFilePath());
        VirtualFile virtualFile = generateCaseFileDTO.getBelongsToWorkingSpace() != false ? localFileSystem.findFileByPath(generateCaseFileDTO.getWorkingSpaceFilePath()) : localFileSystem.findFileByPath(this.parentClassPanel.getParentFileItemPanel().getFilePath());
        if (virtualFile == null) {
            NotificationFactory.showToast((JComponent)this.methodNameLabel, MessageType.ERROR, CosyBundle.message("notifications.not.found.file", new Object[0]));
        }
        if ((editor = (fileEditorManager = FileEditorManager.getInstance((Project)this.fileListPanel.getParentComponent().project)).openTextEditor(new OpenFileDescriptor(this.fileListPanel.getParentComponent().project, virtualFile), true)) != null && (psiFile = PsiDocumentManager.getInstance((Project)this.fileListPanel.getParentComponent().project).getPsiFile(editor.getDocument())) != null && (method = this.findMethod(psiFile, methodItem.getName(), methodItem.getParameterList())) != null) {
            editor.getCaretModel().moveToOffset(method.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            editor.getSelectionModel().setSelection(method.getTextRange().getStartOffset(), method.getTextRange().getEndOffset());
            return;
        }
        NotificationFactory.showToast((JComponent)this.methodNameLabel, MessageType.ERROR, CosyBundle.message("test.agent.generateCase.method.not.found", new Object[0]));
    }

    private PsiMethod findMethod(PsiFile psiFile, String methodName, List<GenerateCaseMethodParameterDTO> parameterList) {
        String className = this.parentClassPanel.getClassName();
        for (PsiMethod method : PsiTreeUtil.findChildrenOfType((PsiElement)psiFile, PsiMethod.class)) {
            PsiParameterList psiParameterList;
            PsiClass psiClass;
            if (!method.getName().equals(methodName) || StringUtils.isNotBlank((String)className) && ((psiClass = method.getContainingClass()) == null || !className.equals(psiClass.getName())) || (psiParameterList = method.getParameterList()).getParameters().length != parameterList.size()) continue;
            boolean match = true;
            for (int i = 0; i < parameterList.size(); ++i) {
                if (Objects.requireNonNull(psiParameterList.getParameter(i)).getType().getPresentableText().replaceAll(" ", "").equals(parameterList.get(i).getType().replaceAll(" ", ""))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return method;
        }
        return null;
    }

    public void stop() {
        GenerateCaseMethodDTO methodItem = this.fileListPanel.getParentComponent().methodMap.get(this.methodUuid);
        if (!methodItem.getState().isNeedConfirm().booleanValue() && !methodItem.getState().isFinalState().booleanValue()) {
            methodItem.setState(GenerateCaseMethodStateEnum.CANCELED);
        }
        this.updateActionArea();
        this.checkBox.setEnabled(false);
    }

    public void updateUiLanguage() {
        if (this.runningSuccessIcon != null) {
            this.runningSuccessIcon.setToolTipText(CosyBundle.message("test.agent.run.success.icon.tooltips", new Object[0]));
        }
        if (this.runningFailedLabel != null) {
            this.runningFailedLabel.setToolTipText(CosyBundle.message("test.agent.run.fail.icon.tooltips", new Object[0]));
        }
        if (this.compileErrorIcon != null) {
            this.compileErrorIcon.setToolTipText(CosyBundle.message("test.agent.compile.error.icon.tooltips", new Object[0]));
        }
    }

    public void updateCheckBoxStateFromOutside(Boolean selectedState) {
        this.checkBox.setSelected(selectedState.booleanValue());
    }

    public boolean isCurrentSelected() {
        return this.checkBox.isSelected();
    }

    @Generated
    public String getMethodUuid() {
        return this.methodUuid;
    }
}

